(function() {
  var CompositeDisposable, Notification, NotificationElement, Notifications, NotificationsLog, StackTraceParser, fs, isCoreOrPackageStackTrace, ref;

  ref = require('atom'), Notification = ref.Notification, CompositeDisposable = ref.CompositeDisposable;

  fs = require('fs-plus');

  StackTraceParser = null;

  NotificationElement = require('./notification-element');

  NotificationsLog = require('./notifications-log');

  Notifications = {
    isInitialized: false,
    subscriptions: null,
    duplicateTimeDelay: 500,
    lastNotification: null,
    activate: function(state) {
      var CommandLogger, i, len, notification, ref1;
      CommandLogger = require('./command-logger');
      CommandLogger.start();
      this.subscriptions = new CompositeDisposable;
      ref1 = atom.notifications.getNotifications();
      for (i = 0, len = ref1.length; i < len; i++) {
        notification = ref1[i];
        this.addNotificationView(notification);
      }
      this.subscriptions.add(atom.notifications.onDidAddNotification((function(_this) {
        return function(notification) {
          return _this.addNotificationView(notification);
        };
      })(this)));
      this.subscriptions.add(atom.onWillThrowError(function(arg) {
        var line, match, message, options, originalError, preventDefault, url;
        message = arg.message, url = arg.url, line = arg.line, originalError = arg.originalError, preventDefault = arg.preventDefault;
        if (originalError.name === 'BufferedProcessError') {
          message = message.replace('Uncaught BufferedProcessError: ', '');
          return atom.notifications.addError(message, {
            dismissable: true
          });
        } else if (originalError.code === 'ENOENT' && !/\/atom/i.test(message) && (match = /spawn (.+) ENOENT/.exec(message))) {
          message = "'" + match[1] + "' could not be spawned.\nIs it installed and on your path?\nIf so please open an issue on the package spawning the process.";
          return atom.notifications.addError(message, {
            dismissable: true
          });
        } else if (!atom.inDevMode() || atom.config.get('notifications.showErrorsInDevMode')) {
          preventDefault();
          if (originalError.stack && !isCoreOrPackageStackTrace(originalError.stack)) {
            return;
          }
          options = {
            detail: url + ":" + line,
            stack: originalError.stack,
            dismissable: true
          };
          return atom.notifications.addFatalError(message, options);
        }
      }));
      this.subscriptions.add(atom.commands.add('atom-workspace', 'core:cancel', function() {
        var j, len1, ref2, results;
        ref2 = atom.notifications.getNotifications();
        results = [];
        for (j = 0, len1 = ref2.length; j < len1; j++) {
          notification = ref2[j];
          results.push(notification.dismiss());
        }
        return results;
      }));
      this.subscriptions.add(atom.config.observe('notifications.defaultTimeout', (function(_this) {
        return function(value) {
          return _this.visibilityDuration = value;
        };
      })(this)));
      if (atom.inDevMode()) {
        this.subscriptions.add(atom.commands.add('atom-workspace', 'notifications:trigger-error', function() {
          var error, options;
          try {
            return abc + 2;
          } catch (error1) {
            error = error1;
            options = {
              detail: error.stack.split('\n')[1],
              stack: error.stack,
              dismissable: true
            };
            return atom.notifications.addFatalError("Uncaught " + (error.stack.split('\n')[0]), options);
          }
        }));
      }
      if (this.notificationsLog != null) {
        this.addNotificationsLogSubscriptions();
      }
      this.subscriptions.add(atom.workspace.addOpener((function(_this) {
        return function(uri) {
          if (uri === NotificationsLog.prototype.getURI()) {
            return _this.createLog();
          }
        };
      })(this)));
      return this.subscriptions.add(atom.commands.add('atom-workspace', 'notifications:toggle-log', function() {
        return atom.workspace.toggle(NotificationsLog.prototype.getURI());
      }));
    },
    deactivate: function() {
      var ref1, ref2, ref3;
      this.subscriptions.dispose();
      if ((ref1 = this.notificationsElement) != null) {
        ref1.remove();
      }
      if ((ref2 = this.notificationsPanel) != null) {
        ref2.destroy();
      }
      if ((ref3 = this.notificationsLog) != null) {
        ref3.destroy();
      }
      this.subscriptions = null;
      this.notificationsElement = null;
      this.notificationsPanel = null;
      return this.isInitialized = false;
    },
    initializeIfNotInitialized: function() {
      if (this.isInitialized) {
        return;
      }
      this.subscriptions.add(atom.views.addViewProvider(Notification, (function(_this) {
        return function(model) {
          return new NotificationElement(model, _this.visibilityDuration);
        };
      })(this)));
      this.notificationsElement = document.createElement('atom-notifications');
      atom.views.getView(atom.workspace).appendChild(this.notificationsElement);
      return this.isInitialized = true;
    },
    createLog: function(state) {
      this.notificationsLog = new NotificationsLog(this.duplicateTimeDelay, state != null ? state.typesHidden : void 0);
      if (this.subscriptions != null) {
        this.addNotificationsLogSubscriptions();
      }
      return this.notificationsLog;
    },
    addNotificationsLogSubscriptions: function() {
      this.subscriptions.add(this.notificationsLog.onDidDestroy((function(_this) {
        return function() {
          return _this.notificationsLog = null;
        };
      })(this)));
      return this.subscriptions.add(this.notificationsLog.onItemClick((function(_this) {
        return function(notification) {
          var view;
          view = atom.views.getView(notification);
          view.makeDismissable();
          if (!view.element.classList.contains('remove')) {
            return;
          }
          view.element.classList.remove('remove');
          _this.notificationsElement.appendChild(view.element);
          notification.dismissed = false;
          return notification.setDisplayed(true);
        };
      })(this)));
    },
    addNotificationView: function(notification) {
      var ref1, ref2, timeSpan;
      if (notification == null) {
        return;
      }
      this.initializeIfNotInitialized();
      if (notification.wasDisplayed()) {
        return;
      }
      if (this.lastNotification != null) {
        timeSpan = notification.getTimestamp() - this.lastNotification.getTimestamp();
        if (!(timeSpan < this.duplicateTimeDelay && notification.isEqual(this.lastNotification))) {
          this.notificationsElement.appendChild(atom.views.getView(notification).element);
          if ((ref1 = this.notificationsLog) != null) {
            ref1.addNotification(notification);
          }
        }
      } else {
        this.notificationsElement.appendChild(atom.views.getView(notification).element);
        if ((ref2 = this.notificationsLog) != null) {
          ref2.addNotification(notification);
        }
      }
      notification.setDisplayed(true);
      return this.lastNotification = notification;
    }
  };

  isCoreOrPackageStackTrace = function(stack) {
    var file, i, len, ref1;
    if (StackTraceParser == null) {
      StackTraceParser = require('stacktrace-parser');
    }
    ref1 = StackTraceParser.parse(stack);
    for (i = 0, len = ref1.length; i < len; i++) {
      file = ref1[i].file;
      if (file === '<embedded>' || fs.isAbsolute(file)) {
        return true;
      }
    }
    return false;
  };

  module.exports = Notifications;

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
