(function() {
  var CSON, FunctionsURL, Promise, functionsPromise, path, request, sanitizeFunc;

  path = require('path');

  request = require('request');

  Promise = require('bluebird');

  CSON = require('season');

  FunctionsURL = 'https://raw.githubusercontent.com/less/less-docs/master/content/functions/data/functions.json';

  functionsPromise = new Promise(function(resolve) {
    return request({
      json: true,
      url: FunctionsURL
    }, function(error, response, properties) {
      if (error != null) {
        console.error(error.message);
        resolve(null);
      }
      if (response.statusCode !== 200) {
        console.error("Request failed: " + response.statusCode);
        resolve(null);
      }
      return resolve(properties);
    });
  });

  functionsPromise.then(function(results) {
    var builtins, config, configPath, func, functionType, functions, i, len, suggestions;
    suggestions = [];
    for (functionType in results) {
      functions = results[functionType];
      for (i = 0, len = functions.length; i < len; i++) {
        func = functions[i];
        suggestions.push({
          type: 'function',
          rightLabel: 'Less Builtin',
          snippet: sanitizeFunc(func.example),
          description: func.description,
          descriptionMoreURL: "http://lesscss.org/functions/#" + functionType + "-" + func.name
        });
      }
    }
    configPath = path.join(__dirname, 'settings', 'language-less.cson');
    config = CSON.readFileSync(configPath);
    builtins = config['.source.css.less .meta.property-value'].autocomplete.symbols.builtins;
    builtins.suggestions = suggestions;
    return CSON.writeFileSync(configPath, config);
  });

  sanitizeFunc = function(functionExample) {
    var argsRe;
    functionExample = functionExample.replace(';', '');
    functionExample = functionExample.replace(/\[, /g, ', [');
    functionExample = functionExample.replace(/\,] /g, '], ');
    argsRe = /\(([^\)]+)\)/;
    functionExample = functionExample.replace(argsRe, function(args) {
      var arg, index;
      args = argsRe.exec(args)[1];
      args = args.split(',');
      args = (function() {
        var i, len, results1;
        results1 = [];
        for (index = i = 0, len = args.length; i < len; index = ++i) {
          arg = args[index];
          results1.push("${" + (index + 1) + ":" + (arg.trim()) + "}");
        }
        return results1;
      })();
      return "(" + (args.join(', ')) + ")${" + (index + 1) + ":;}";
    });
    return functionExample + "$0";
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
