Object.defineProperty(exports, '__esModule', {
  value: true
});
exports.activate = activate;
exports.deactivate = deactivate;
exports.consumeStatusBar = consumeStatusBar;
exports.deserializeIncompatiblePackagesComponent = deserializeIncompatiblePackagesComponent;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/** @babel */

var _atom = require('atom');

var _viewUri = require('./view-uri');

var _viewUri2 = _interopRequireDefault(_viewUri);

var disposables = null;

function activate() {
  disposables = new _atom.CompositeDisposable();

  disposables.add(atom.workspace.addOpener(function (uri) {
    if (uri === _viewUri2['default']) {
      return deserializeIncompatiblePackagesComponent();
    }
  }));

  disposables.add(atom.commands.add('atom-workspace', {
    'incompatible-packages:view': function incompatiblePackagesView() {
      atom.workspace.open(_viewUri2['default']);
    }
  }));
}

function deactivate() {
  disposables.dispose();
}

function consumeStatusBar(statusBar) {
  var incompatibleCount = 0;
  for (var pack of atom.packages.getLoadedPackages()) {
    if (!pack.isCompatible()) incompatibleCount++;
  }

  if (incompatibleCount > 0) {
    (function () {
      var icon = createIcon(incompatibleCount);
      var tile = statusBar.addRightTile({ item: icon, priority: 200 });
      icon.element.addEventListener('click', function () {
        atom.commands.dispatch(icon.element, 'incompatible-packages:view');
      });
      disposables.add(new _atom.Disposable(function () {
        return tile.destroy();
      }));
    })();
  }
}

function deserializeIncompatiblePackagesComponent() {
  var IncompatiblePackagesComponent = require('./incompatible-packages-component');
  return new IncompatiblePackagesComponent(atom.packages);
}

function createIcon(count) {
  var StatusIconComponent = require('./status-icon-component');
  return new StatusIconComponent({ count: count });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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