"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareCommitView = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareCommitView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "openCommitDetailItem", () => this.props.openCommit({
      sha: this.props.commit.sha
    }));
  }

  authoredByCommitter(commit) {
    if (commit.authoredByCommitter) {
      return true;
    } // If you commit on GitHub online the committer details would be:
    //
    //    name: "GitHub"
    //    email: "noreply@github.com"
    //    user: null
    //


    if (commit.committer.email === 'noreply@github.com') {
      return true;
    }

    if (commit.committer.name === 'GitHub' && commit.committer.user === null) {
      return true;
    }

    return false;
  }

  renderCommitter(commit) {
    if (!this.authoredByCommitter(commit)) {
      return _react["default"].createElement("img", {
        className: "author-avatar",
        alt: "author's avatar",
        src: commit.committer.avatarUrl,
        title: commit.committer.user ? commit.committer.user.login : commit.committer.name
      });
    } else {
      return null;
    }
  }

  render() {
    const commit = this.props.commit;
    return _react["default"].createElement("div", {
      className: "commit"
    }, _react["default"].createElement(_octicon["default"], {
      className: "pre-timeline-item-icon",
      icon: "git-commit"
    }), _react["default"].createElement("span", {
      className: "commit-author"
    }, _react["default"].createElement("img", {
      className: "author-avatar",
      alt: "author's avatar",
      src: commit.author.avatarUrl,
      title: commit.author.user ? commit.author.user.login : commit.author.name
    }), this.renderCommitter(commit)), _react["default"].createElement("p", {
      className: "commit-message-headline"
    }, this.props.onBranch ? _react["default"].createElement("button", {
      className: "open-commit-detail-button",
      title: commit.message,
      dangerouslySetInnerHTML: {
        __html: commit.messageHeadlineHTML
      },
      onClick: this.openCommitDetailItem
    }) : _react["default"].createElement("span", {
      title: commit.message,
      dangerouslySetInnerHTML: {
        __html: commit.messageHeadlineHTML
      }
    })), _react["default"].createElement("a", {
      className: "commit-sha",
      href: commit.commitUrl
    }, commit.sha.slice(0, 8)));
  }

}

exports.BareCommitView = BareCommitView;

_defineProperty(BareCommitView, "propTypes", {
  commit: _propTypes["default"].object.isRequired,
  onBranch: _propTypes["default"].bool.isRequired,
  openCommit: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareCommitView, {
  commit: function () {
    const node = require("./__generated__/commitView_commit.graphql");

    if (node.hash && node.hash !== "9d2823ee95f39173f656043ddfc8d47c") {
      console.error("The definition of 'commitView_commit' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/commitView_commit.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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