"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReviewsFooterView extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "logStartReviewClick", () => {
      (0, _reporterProxy.addEvent)('start-pr-review', {
        "package": 'github',
        component: this.constructor.name
      });
    });
  }

  render() {
    return _react["default"].createElement("footer", {
      className: "github-ReviewsFooterView-footer"
    }, _react["default"].createElement("span", {
      className: "github-ReviewsFooterView-footerTitle"
    }, "Reviews"), _react["default"].createElement("span", {
      className: "github-ReviewsFooterView"
    }, _react["default"].createElement("span", {
      className: "github-ReviewsFooterView-commentCount"
    }, "Resolved", ' ', _react["default"].createElement("span", {
      className: "github-ReviewsFooterView-commentsResolved"
    }, this.props.commentsResolved), ' ', "of", ' ', _react["default"].createElement("span", {
      className: "github-ReviewsFooterView-totalComments"
    }, this.props.totalComments), ' ', "comments"), _react["default"].createElement("progress", {
      className: "github-ReviewsFooterView-progessBar",
      value: this.props.commentsResolved,
      max: this.props.totalComments
    }, ' ', "comments", ' ')), _react["default"].createElement("button", {
      className: "github-ReviewsFooterView-openReviewsButton btn btn-primary",
      onClick: this.props.openReviews
    }, "See reviews"), _react["default"].createElement("a", {
      href: this.props.pullRequestURL,
      className: "github-ReviewsFooterView-reviewChangesButton btn",
      onClick: this.logStartReviewClick
    }, "Start a new review"));
  }

}

exports["default"] = ReviewsFooterView;

_defineProperty(ReviewsFooterView, "propTypes", {
  commentsResolved: _propTypes["default"].number.isRequired,
  totalComments: _propTypes["default"].number.isRequired,
  pullRequestURL: _propTypes["default"].string.isRequired,
  // Controller actions
  openReviews: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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