"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _githubLoginView = _interopRequireDefault(require("./github-login-view"));

var _errorView = _interopRequireDefault(require("./error-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class QueryErrorView extends _react["default"].Component {
  render() {
    const e = this.props.error;

    if (e.response) {
      switch (e.response.status) {
        case 401:
          return this.render401();

        case 200:
          // Do the default
          break;

        default:
          return this.renderUnknown(e.response, e.responseText);
      }
    }

    if (e.errors) {
      return this.renderGraphQLErrors(e.errors);
    }

    return _react["default"].createElement(_errorView["default"], _extends({
      title: e.message,
      descriptions: [e.stack],
      preformatted: true
    }, this.errorViewProps()));
  }

  renderGraphQLErrors(errors) {
    return _react["default"].createElement(_errorView["default"], _extends({
      title: "Query errors reported",
      descriptions: errors.map(e => e.message)
    }, this.errorViewProps()));
  }

  render401() {
    return _react["default"].createElement("div", {
      className: "github-GithubLoginView-Container"
    }, _react["default"].createElement(_githubLoginView["default"], {
      onLogin: this.props.login
    }, _react["default"].createElement("p", null, "The API endpoint returned a unauthorized error. Please try to re-authenticate with the endpoint.")));
  }

  renderUnknown(response, text) {
    return _react["default"].createElement(_errorView["default"], _extends({
      title: `Received an error response: ${response.status}`,
      descriptions: [text],
      preformatted: true
    }, this.errorViewProps()));
  }

  errorViewProps() {
    return {
      retry: this.props.retry,
      logout: this.props.logout
    };
  }

}

exports["default"] = QueryErrorView;

_defineProperty(QueryErrorView, "propTypes", {
  error: _propTypes["default"].shape({
    name: _propTypes["default"].string.isRequired,
    message: _propTypes["default"].string.isRequired,
    stack: _propTypes["default"].string.isRequired,
    response: _propTypes["default"].shape({
      status: _propTypes["default"].number.isRequired
    }),
    responseText: _propTypes["default"].string,
    errors: _propTypes["default"].arrayOf(_propTypes["default"].shape({
      message: _propTypes["default"].string.isRequired
    }))
  }).isRequired,
  login: _propTypes["default"].func.isRequired,
  retry: _propTypes["default"].func,
  logout: _propTypes["default"].func
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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