"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _commands = _interopRequireWildcard(require("../atom/commands"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class OpenCommitDialog extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);

    _defineProperty(this, "accept", async () => {
      const ref = this.getCommitRef();
      const valid = await this.props.isValidEntry(ref);

      if (valid === true) {
        this.props.didAccept({
          ref
        });
      } else {
        this.setState({
          error: `There is no commit associated with "${ref}" in this repository`
        });
      }
    });

    _defineProperty(this, "cancel", () => this.props.didCancel());

    _defineProperty(this, "editorRefs", baseName => {
      const elementName = `${baseName}Element`;
      const modelName = `${baseName}Editor`;
      const subName = `${baseName}Subs`;
      const changeMethodName = `didChange${baseName[0].toUpperCase()}${baseName.substring(1)}`;
      return element => {
        if (!element) {
          return;
        }

        this[elementName] = element;
        const editor = element.getModel();

        if (this[modelName] !== editor) {
          this[modelName] = editor;
          /* istanbul ignore if */

          if (this[subName]) {
            this[subName].dispose();
            this.subs.remove(this[subName]);
          }

          this[subName] = editor.onDidChange(this[changeMethodName]);
          this.subs.add(this[subName]);
        }
      };
    });

    _defineProperty(this, "didChangeCommitRef", () => new Promise(resolve => {
      this.setState({
        error: null
      }, resolve);
    }));

    this.state = {
      error: null
    };
    this.subs = new _eventKit.CompositeDisposable();
  }

  componentDidMount() {
    setTimeout(() => this.commitRefElement.focus());
  }

  componentWillUnmount() {
    this.subs.dispose();
  }

  render() {
    return this.renderDialog();
  }

  renderDialog() {
    return _react["default"].createElement("div", {
      className: "github-Dialog github-OpenCommit modal"
    }, _react["default"].createElement(_commands["default"], {
      registry: this.props.commandRegistry,
      target: ".github-OpenCommit"
    }, _react["default"].createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancel
    }), _react["default"].createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.accept
    })), _react["default"].createElement("main", {
      className: "github-DialogInputs"
    }, _react["default"].createElement("label", {
      className: "github-DialogLabel github-CommitRef"
    }, "Commit sha or Git ref:", _react["default"].createElement("atom-text-editor", {
      mini: true,
      ref: this.editorRefs('commitRef'),
      tabIndex: "1"
    })), this.state.error && _react["default"].createElement("span", {
      className: "error"
    }, this.state.error)), _react["default"].createElement("div", {
      className: "github-DialogButtons"
    }, _react["default"].createElement("button", {
      className: "btn github-CancelButton",
      onClick: this.cancel,
      tabIndex: "3"
    }, "Cancel"), _react["default"].createElement("button", {
      className: "btn btn-primary icon icon-commit",
      onClick: this.accept,
      disabled: !!this.state.error || this.getCommitRef().length === 0,
      tabIndex: "2"
    }, "Open Commit")));
  }

  getCommitRef() {
    return this.commitRefEditor ? this.commitRefEditor.getText() : '';
  }

}

exports["default"] = OpenCommitDialog;

_defineProperty(OpenCommitDialog, "propTypes", {
  commandRegistry: _propTypes["default"].object.isRequired,
  didAccept: _propTypes["default"].func.isRequired,
  didCancel: _propTypes["default"].func.isRequired,
  isValidEntry: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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