"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _accordion = _interopRequireDefault(require("./accordion"));

var _timeago = _interopRequireDefault(require("./timeago"));

var _statusDonutChart = _interopRequireDefault(require("./status-donut-chart"));

var _queryErrorTile = _interopRequireDefault(require("./query-error-tile"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishListView extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "renderReviewsButton", () => {
      if (!this.props.needReviewsButton || this.props.issueishes.length < 1) {
        return null;
      }

      return _react["default"].createElement("button", {
        className: "btn btn-primary btn-sm github-IssueishList-openReviewsButton",
        onClick: this.openReviews
      }, "See reviews");
    });

    _defineProperty(this, "openReviews", e => {
      e.stopPropagation();
      this.props.openReviews(this.props.issueishes[0]);
    });

    (0, _helpers.autobind)(this, 'renderIssueish', 'renderLoadingTile', 'renderEmptyTile', 'renderMoreTile');
  }

  render() {
    return _react["default"].createElement(_accordion["default"], {
      leftTitle: this.props.title,
      isLoading: this.props.isLoading,
      results: this.props.issueishes,
      total: this.props.total,
      loadingComponent: this.renderLoadingTile,
      emptyComponent: this.renderEmptyTile,
      moreComponent: this.renderMoreTile,
      reviewsButton: this.renderReviewsButton,
      onClickItem: this.props.onIssueishClick
    }, this.renderIssueish);
  }

  renderIssueish(issueish) {
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement("img", {
      className: "github-IssueishList-item github-IssueishList-item--avatar",
      src: issueish.getAuthorAvatarURL(32),
      title: issueish.getAuthorLogin(),
      alt: issueish.getAuthorLogin()
    }), _react["default"].createElement("span", {
      className: "github-IssueishList-item github-IssueishList-item--title"
    }, issueish.getTitle()), _react["default"].createElement("span", {
      className: "github-IssueishList-item github-IssueishList-item--number"
    }, "#", issueish.getNumber()), this.renderStatusSummary(issueish.getStatusCounts()), _react["default"].createElement(_timeago["default"], {
      time: issueish.getCreatedAt(),
      displayStyle: "short",
      className: "github-IssueishList-item github-IssueishList-item--age"
    }), _react["default"].createElement(_octicon["default"], {
      icon: "ellipses",
      className: "github-IssueishList-item github-IssueishList-item--menu",
      onClick: event => this.showActionsMenu(event, issueish)
    }));
  }

  showActionsMenu(event, issueish) {
    event.preventDefault();
    event.stopPropagation();
    this.props.showActionsMenu(issueish);
  }

  renderStatusSummary(statusCounts) {
    if (['success', 'failure', 'pending'].every(kind => statusCounts[kind] === 0)) {
      return _react["default"].createElement(_octicon["default"], {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "dash"
      });
    }

    if (statusCounts.success > 0 && statusCounts.failure === 0 && statusCounts.pending === 0) {
      return _react["default"].createElement(_octicon["default"], {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "check"
      });
    }

    if (statusCounts.success === 0 && statusCounts.failure > 0 && statusCounts.pending === 0) {
      return _react["default"].createElement(_octicon["default"], {
        className: "github-IssueishList-item github-IssueishList-item--status",
        icon: "x"
      });
    }

    return _react["default"].createElement(_statusDonutChart["default"], _extends({}, statusCounts, {
      className: "github-IssueishList-item github-IssueishList-item--status"
    }));
  }

  renderLoadingTile() {
    return _react["default"].createElement("div", {
      className: "github-IssueishList-loading"
    }, "Loading");
  }

  renderEmptyTile() {
    if (this.props.error) {
      return _react["default"].createElement(_queryErrorTile["default"], {
        error: this.props.error
      });
    }

    if (this.props.emptyComponent) {
      const EmptyComponent = this.props.emptyComponent;
      return _react["default"].createElement(EmptyComponent, null);
    }

    return null;
  }

  renderMoreTile() {
    /* eslint-disable jsx-a11y/anchor-is-valid */
    if (this.props.onMoreClick) {
      return _react["default"].createElement("div", {
        className: "github-IssueishList-more"
      }, _react["default"].createElement("a", {
        onClick: this.props.onMoreClick
      }, "More..."));
    }

    return null;
  }

}

exports["default"] = IssueishListView;

_defineProperty(IssueishListView, "propTypes", {
  title: _propTypes["default"].string.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  total: _propTypes["default"].number.isRequired,
  issueishes: _propTypes["default"].arrayOf(_propTypes2.IssueishPropType).isRequired,
  repository: _propTypes["default"].shape({
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }),
  needReviewsButton: _propTypes["default"].bool,
  onIssueishClick: _propTypes["default"].func.isRequired,
  onMoreClick: _propTypes["default"].func,
  openReviews: _propTypes["default"].func.isRequired,
  openOnGitHub: _propTypes["default"].func.isRequired,
  showActionsMenu: _propTypes["default"].func.isRequired,
  emptyComponent: _propTypes["default"].func,
  error: _propTypes["default"].object
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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