"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _atom = require("atom");

var _stagingView = _interopRequireDefault(require("./staging-view"));

var _commitController = _interopRequireDefault(require("../controllers/commit-controller"));

var _recentCommitsController = _interopRequireDefault(require("../controllers/recent-commits-controller"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitTabView extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'initializeRepo', 'blur', 'advanceFocus', 'retreatFocus', 'quietlySelectItem');
    this.subscriptions = new _atom.CompositeDisposable();
    this.refCommitController = new _refHolder["default"]();
    this.refRecentCommitsController = new _refHolder["default"]();
  }

  componentDidMount() {
    this.props.refRoot.map(root => {
      return this.subscriptions.add(this.props.commandRegistry.add(root, {
        'tool-panel:unfocus': this.blur,
        'core:focus-next': this.advanceFocus,
        'core:focus-previous': this.retreatFocus
      }));
    });
  }

  render() {
    if (this.props.repository.isTooLarge()) {
      return _react["default"].createElement("div", {
        className: "github-Git is-empty",
        tabIndex: "-1",
        ref: this.props.refRoot.setter
      }, _react["default"].createElement("div", {
        ref: "noRepoMessage",
        className: "github-Git too-many-changes"
      }, _react["default"].createElement("div", {
        className: "github-Git-LargeIcon icon icon-diff"
      }), _react["default"].createElement("h1", null, "Too many changes"), _react["default"].createElement("div", {
        className: "initialize-repo-description"
      }, "The repository at ", _react["default"].createElement("strong", null, this.props.workingDirectoryPath), " has too many changed files to display in Atom. Ensure that you have set up an appropriate ", _react["default"].createElement("code", null, ".gitignore"), " file.")));
    } else if (this.props.repository.hasDirectory() && !(0, _helpers.isValidWorkdir)(this.props.repository.getWorkingDirectoryPath())) {
      return _react["default"].createElement("div", {
        className: "github-Git is-empty",
        tabIndex: "-1",
        ref: this.props.refRoot.setter
      }, _react["default"].createElement("div", {
        ref: "noRepoMessage",
        className: "github-Git unsupported-directory"
      }, _react["default"].createElement("div", {
        className: "github-Git-LargeIcon icon icon-alert"
      }), _react["default"].createElement("h1", null, "Unsupported directory"), _react["default"].createElement("div", {
        className: "initialize-repo-description"
      }, "Atom does not support managing Git repositories in your home or root directories.")));
    } else if (this.props.repository.showGitTabInit()) {
      const inProgress = this.props.repository.showGitTabInitInProgress();
      const message = this.props.repository.hasDirectory() ? _react["default"].createElement("span", null, "Initialize ", _react["default"].createElement("strong", null, this.props.workingDirectoryPath), " with a Git repository") : _react["default"].createElement("span", null, "Initialize a new project directory with a Git repository");
      return _react["default"].createElement("div", {
        className: "github-Git is-empty",
        tabIndex: "-1",
        ref: this.props.refRoot.setter
      }, _react["default"].createElement("div", {
        ref: "noRepoMessage",
        className: "github-Git no-repository"
      }, _react["default"].createElement("div", {
        className: "github-Git-LargeIcon icon icon-repo"
      }), _react["default"].createElement("h1", null, "Create Repository"), _react["default"].createElement("div", {
        className: "initialize-repo-description"
      }, message), _react["default"].createElement("button", {
        onClick: this.initializeRepo,
        disabled: inProgress,
        className: "btn btn-primary"
      }, inProgress ? 'Creating repository...' : 'Create repository')));
    } else {
      const isLoading = this.props.isLoading || this.props.repository.showGitTabLoading();
      return _react["default"].createElement("div", {
        className: (0, _classnames["default"])('github-Git', {
          'is-loading': isLoading
        }),
        tabIndex: "-1",
        ref: this.props.refRoot.setter
      }, _react["default"].createElement(_stagingView["default"], {
        ref: this.props.refStagingView.setter,
        commandRegistry: this.props.commandRegistry,
        notificationManager: this.props.notificationManager,
        workspace: this.props.workspace,
        stagedChanges: this.props.stagedChanges,
        unstagedChanges: this.props.unstagedChanges,
        mergeConflicts: this.props.mergeConflicts,
        workingDirectoryPath: this.props.workingDirectoryPath,
        resolutionProgress: this.props.resolutionProgress,
        openFiles: this.props.openFiles,
        discardWorkDirChangesForPaths: this.props.discardWorkDirChangesForPaths,
        attemptFileStageOperation: this.props.attemptFileStageOperation,
        attemptStageAllOperation: this.props.attemptStageAllOperation,
        undoLastDiscard: this.props.undoLastDiscard,
        abortMerge: this.props.abortMerge,
        resolveAsOurs: this.props.resolveAsOurs,
        resolveAsTheirs: this.props.resolveAsTheirs,
        lastCommit: this.props.lastCommit,
        isLoading: this.props.isLoading,
        hasUndoHistory: this.props.hasUndoHistory,
        isMerging: this.props.isMerging
      }), _react["default"].createElement(_commitController["default"], {
        ref: this.refCommitController.setter,
        tooltips: this.props.tooltips,
        config: this.props.config,
        stagedChangesExist: this.props.stagedChanges.length > 0,
        mergeConflictsExist: this.props.mergeConflicts.length > 0,
        prepareToCommit: this.props.prepareToCommit,
        commit: this.props.commit,
        abortMerge: this.props.abortMerge,
        currentBranch: this.props.currentBranch,
        workspace: this.props.workspace,
        commandRegistry: this.props.commandRegistry,
        notificationManager: this.props.notificationManager,
        grammars: this.props.grammars,
        mergeMessage: this.props.mergeMessage,
        isMerging: this.props.isMerging,
        isLoading: this.props.isLoading,
        lastCommit: this.props.lastCommit,
        repository: this.props.repository,
        userStore: this.props.userStore,
        selectedCoAuthors: this.props.selectedCoAuthors,
        updateSelectedCoAuthors: this.props.updateSelectedCoAuthors
      }), _react["default"].createElement(_recentCommitsController["default"], {
        ref: this.refRecentCommitsController.setter,
        commandRegistry: this.props.commandRegistry,
        commits: this.props.recentCommits,
        isLoading: this.props.isLoading,
        undoLastCommit: this.props.undoLastCommit,
        workspace: this.props.workspace,
        repository: this.props.repository
      }));
    }
  }

  componentWillUnmount() {
    this.subscriptions.dispose();
  }

  initializeRepo(event) {
    event.preventDefault();
    let initPath = null;
    const activeEditor = this.props.workspace.getActiveTextEditor();

    if (activeEditor) {
      const [projectPath] = this.props.project.relativizePath(activeEditor.getPath());

      if (projectPath) {
        initPath = projectPath;
      }
    }

    this.props.initializeRepo(initPath);
  }

  getFocus(element) {
    for (const ref of [this.props.refStagingView, this.refCommitController, this.refRecentCommitsController]) {
      const focus = ref.map(sub => sub.getFocus(element)).getOr(null);

      if (focus !== null) {
        return focus;
      }
    }

    return null;
  }

  setFocus(focus) {
    for (const ref of [this.props.refStagingView, this.refCommitController, this.refRecentCommitsController]) {
      if (ref.map(sub => sub.setFocus(focus)).getOr(false)) {
        return true;
      }
    }

    return false;
  }

  blur() {
    this.props.workspace.getCenter().activate();
  }

  async advanceFocus(evt) {
    const currentFocus = this.getFocus(document.activeElement);
    let nextSeen = false;

    for (const subHolder of [this.props.refStagingView, this.refCommitController, this.refRecentCommitsController]) {
      const next = await subHolder.map(sub => sub.advanceFocusFrom(currentFocus)).getOr(null);

      if (next !== null && !nextSeen) {
        nextSeen = true;
        evt.stopPropagation();

        if (next !== currentFocus) {
          this.setFocus(next);
        }
      }
    }
  }

  async retreatFocus(evt) {
    const currentFocus = this.getFocus(document.activeElement);
    let previousSeen = false;

    for (const subHolder of [this.refRecentCommitsController, this.refCommitController, this.props.refStagingView]) {
      const previous = await subHolder.map(sub => sub.retreatFocusFrom(currentFocus)).getOr(null);

      if (previous !== null && !previousSeen) {
        previousSeen = true;
        evt.stopPropagation();

        if (previous !== currentFocus) {
          this.setFocus(previous);
        }
      }
    }
  }

  async focusAndSelectStagingItem(filePath, stagingStatus) {
    await this.quietlySelectItem(filePath, stagingStatus);
    this.setFocus(GitTabView.focus.STAGING);
  }

  focusAndSelectRecentCommit() {
    this.setFocus(_recentCommitsController["default"].focus.RECENT_COMMIT);
  }

  focusAndSelectCommitPreviewButton() {
    this.setFocus(GitTabView.focus.COMMIT_PREVIEW_BUTTON);
  }

  quietlySelectItem(filePath, stagingStatus) {
    return this.props.refStagingView.map(view => view.quietlySelectItem(filePath, stagingStatus)).getOr(false);
  }

  hasFocus() {
    return this.props.refRoot.map(root => root.contains(document.activeElement)).getOr(false);
  }

}

exports["default"] = GitTabView;

_defineProperty(GitTabView, "focus", _objectSpread({}, _stagingView["default"].focus, _commitController["default"].focus, _recentCommitsController["default"].focus));

_defineProperty(GitTabView, "propTypes", {
  refRoot: _propTypes2.RefHolderPropType,
  refStagingView: _propTypes2.RefHolderPropType,
  repository: _propTypes["default"].object.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  lastCommit: _propTypes["default"].object.isRequired,
  currentBranch: _propTypes["default"].object,
  recentCommits: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired,
  isMerging: _propTypes["default"].bool,
  isRebasing: _propTypes["default"].bool,
  hasUndoHistory: _propTypes["default"].bool,
  unstagedChanges: _propTypes["default"].arrayOf(_propTypes["default"].object),
  stagedChanges: _propTypes["default"].arrayOf(_propTypes["default"].object),
  mergeConflicts: _propTypes["default"].arrayOf(_propTypes["default"].object),
  workingDirectoryPath: _propTypes["default"].string,
  mergeMessage: _propTypes["default"].string,
  userStore: _propTypes2.UserStorePropType.isRequired,
  selectedCoAuthors: _propTypes["default"].arrayOf(_propTypes2.AuthorPropType),
  updateSelectedCoAuthors: _propTypes["default"].func.isRequired,
  workspace: _propTypes["default"].object.isRequired,
  commandRegistry: _propTypes["default"].object.isRequired,
  grammars: _propTypes["default"].object.isRequired,
  resolutionProgress: _propTypes["default"].object.isRequired,
  notificationManager: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  project: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  initializeRepo: _propTypes["default"].func.isRequired,
  abortMerge: _propTypes["default"].func.isRequired,
  commit: _propTypes["default"].func.isRequired,
  undoLastCommit: _propTypes["default"].func.isRequired,
  prepareToCommit: _propTypes["default"].func.isRequired,
  resolveAsOurs: _propTypes["default"].func.isRequired,
  resolveAsTheirs: _propTypes["default"].func.isRequired,
  undoLastDiscard: _propTypes["default"].func.isRequired,
  attemptStageAllOperation: _propTypes["default"].func.isRequired,
  attemptFileStageOperation: _propTypes["default"].func.isRequired,
  discardWorkDirChangesForPaths: _propTypes["default"].func.isRequired,
  openFiles: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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