"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _helpers = require("../helpers");

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CredentialDialog extends _react["default"].Component {
  constructor(props, context) {
    super(props, context);
    (0, _helpers.autobind)(this, 'confirm', 'cancel', 'onUsernameChange', 'onPasswordChange', 'onRememberChange', 'focusFirstInput', 'toggleShowPassword');
    this.state = {
      username: '',
      password: '',
      remember: false,
      showPassword: false
    };
  }

  componentDidMount() {
    setTimeout(this.focusFirstInput);
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-Dialog github-Credentials modal native-key-bindings"
    }, _react["default"].createElement(_commands["default"], {
      registry: this.props.commandRegistry,
      target: ".github-Credentials"
    }, _react["default"].createElement(_commands.Command, {
      command: "core:cancel",
      callback: this.cancel
    }), _react["default"].createElement(_commands.Command, {
      command: "core:confirm",
      callback: this.confirm
    })), _react["default"].createElement("header", {
      className: "github-DialogPrompt"
    }, this.props.prompt), _react["default"].createElement("main", {
      className: "github-DialogInputs"
    }, this.props.includeUsername ? _react["default"].createElement("label", {
      className: "github-DialogLabel"
    }, "Username:", _react["default"].createElement("input", {
      type: "text",
      ref: e => this.usernameInput = e,
      className: "input-text github-CredentialDialog-Username",
      value: this.state.username,
      onChange: this.onUsernameChange,
      tabIndex: "1"
    })) : null, _react["default"].createElement("label", {
      className: "github-DialogLabel"
    }, "Password:", _react["default"].createElement("input", {
      type: this.state.showPassword ? 'text' : 'password',
      ref: e => this.passwordInput = e,
      className: "input-text github-CredentialDialog-Password",
      value: this.state.password,
      onChange: this.onPasswordChange,
      tabIndex: "2"
    }), _react["default"].createElement("button", {
      className: "github-DialogLabelButton",
      onClick: this.toggleShowPassword
    }, this.state.showPassword ? 'Hide' : 'Show'))), _react["default"].createElement("footer", {
      className: "github-DialogButtons"
    }, this.props.includeRemember ? _react["default"].createElement("label", {
      className: "github-DialogButtons-leftItem input-label"
    }, _react["default"].createElement("input", {
      className: "github-CredentialDialog-remember input-checkbox",
      type: "checkbox",
      checked: this.state.remember,
      onChange: this.onRememberChange
    }), "Remember") : null, _react["default"].createElement("button", {
      className: "btn github-CancelButton",
      tabIndex: "3",
      onClick: this.cancel
    }, "Cancel"), _react["default"].createElement("button", {
      className: "btn btn-primary",
      tabIndex: "4",
      onClick: this.confirm
    }, "Sign in")));
  }

  confirm() {
    const payload = {
      password: this.state.password
    };

    if (this.props.includeUsername) {
      payload.username = this.state.username;
    }

    if (this.props.includeRemember) {
      payload.remember = this.state.remember;
    }

    this.props.onSubmit(payload);
  }

  cancel() {
    this.props.onCancel();
  }

  onUsernameChange(e) {
    this.setState({
      username: e.target.value
    });
  }

  onPasswordChange(e) {
    this.setState({
      password: e.target.value
    });
  }

  onRememberChange(e) {
    this.setState({
      remember: e.target.checked
    });
  }

  focusFirstInput() {
    (this.usernameInput || this.passwordInput).focus();
  }

  toggleShowPassword() {
    this.setState({
      showPassword: !this.state.showPassword
    });
  }

}

exports["default"] = CredentialDialog;

_defineProperty(CredentialDialog, "propTypes", {
  commandRegistry: _propTypes["default"].object.isRequired,
  prompt: _propTypes["default"].string.isRequired,
  includeUsername: _propTypes["default"].bool,
  includeRemember: _propTypes["default"].bool,
  onSubmit: _propTypes["default"].func,
  onCancel: _propTypes["default"].func
});

_defineProperty(CredentialDialog, "defaultProps", {
  includeUsername: false,
  includeRemember: false,
  onSubmit: () => {},
  onCancel: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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