"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CreatePullRequestTile extends _react["default"].Component {
  render() {
    if (this.isRepositoryNotFound()) {
      return _react["default"].createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, _react["default"].createElement("strong", null, "Repository not found"), " for the remote ", _react["default"].createElement("code", null, this.props.remote.getName()), ".", _react["default"].createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react["default"].createElement(_octicon["default"], {
        icon: "link"
      }), "Do you need to update your ", _react["default"].createElement("strong", null, "remote URL"), "?");
    }

    if (this.isDetachedHead()) {
      return _react["default"].createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, "You are not currently on ", _react["default"].createElement("strong", null, "any branch"), ".", _react["default"].createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react["default"].createElement(_octicon["default"], {
        icon: "git-branch"
      }), _react["default"].createElement("strong", null, "Create a new branch"), "\xA0 to share your work with a pull request.");
    }

    if (this.hasNoDefaultRef()) {
      return _react["default"].createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, "The repository at remote ", _react["default"].createElement("code", null, this.props.remote.getName()), " is ", _react["default"].createElement("strong", null, "empty"), ".", _react["default"].createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react["default"].createElement(_octicon["default"], {
        icon: "arrow-up"
      }), _react["default"].createElement("strong", null, "Push a main branch"), " to begin sharing your work.");
    }

    if (this.isOnDefaultRef()) {
      return _react["default"].createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, "You are currently on your repository's ", _react["default"].createElement("strong", null, "default branch"), ".", _react["default"].createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react["default"].createElement(_octicon["default"], {
        icon: "git-branch"
      }), _react["default"].createElement("strong", null, "Checkout or create a new branch"), "\xA0 to share your work with a pull request.");
    }

    if (this.isSameAsDefaultRef()) {
      return _react["default"].createElement("div", {
        className: "github-CreatePullRequestTile-message"
      }, "Your current branch ", _react["default"].createElement("strong", null, "has not moved"), " from the repository's default branch.", _react["default"].createElement("hr", {
        className: "github-CreatePullRequestTile-divider"
      }), _react["default"].createElement(_octicon["default"], {
        icon: "git-commit"
      }), _react["default"].createElement("strong", null, "Make some commits"), "\xA0 to share your work with a pull request.");
    }

    let message = 'Open new pull request';
    let disable = false;
    const differentRemote = this.pushesToDifferentRemote();

    if (this.props.pushInProgress) {
      message = 'Pushing...';
      disable = true;
    } else if (!this.hasUpstreamBranch() || differentRemote) {
      message = 'Publish + open new pull request';
    } else if (this.props.aheadCount > 0) {
      message = 'Push + open new pull request';
    }

    return _react["default"].createElement("div", null, differentRemote && _react["default"].createElement("div", {
      className: "github-CreatePullRequestTile-message"
    }, "Your current branch is ", _react["default"].createElement("strong", null, "configured"), " to push to the remote ", _react["default"].createElement("code", null, this.props.branches.getHeadBranch().getPush().getRemoteName()), ".", _react["default"].createElement("hr", {
      className: "github-CreatePullRequestTile-divider"
    }), _react["default"].createElement(_octicon["default"], {
      icon: "cloud-upload"
    }), _react["default"].createElement("strong", null, "Publish"), " it to ", _react["default"].createElement("code", null, this.props.remote.getName()), " instead?"), _react["default"].createElement("div", {
      className: "github-CreatePullRequestTile-controls"
    }, _react["default"].createElement("button", {
      className: "github-CreatePullRequestTile-createPr btn btn-primary",
      onClick: this.props.onCreatePr,
      disabled: disable
    }, message)));
  }

  isRepositoryNotFound() {
    return !this.props.repository;
  }

  isDetachedHead() {
    return !this.props.branches.getHeadBranch().isPresent();
  }

  hasNoDefaultRef() {
    return !this.props.repository.defaultBranchRef;
  }

  isOnDefaultRef() {
    /* istanbul ignore if */
    if (!this.props.repository) {
      return false;
    }

    const defaultRef = this.props.repository.defaultBranchRef;
    /* istanbul ignore if */

    if (!defaultRef) {
      return false;
    }

    const currentBranch = this.props.branches.getHeadBranch();
    return currentBranch.getPush().getRemoteRef() === `${defaultRef.prefix}${defaultRef.name}`;
  }

  isSameAsDefaultRef() {
    /* istanbul ignore if */
    if (!this.props.repository) {
      return false;
    }

    const defaultRef = this.props.repository.defaultBranchRef;
    /* istanbul ignore if */

    if (!defaultRef) {
      return false;
    }

    const currentBranch = this.props.branches.getHeadBranch();
    const mainBranches = this.props.branches.getPushSources(this.props.remote.getName(), `${defaultRef.prefix}${defaultRef.name}`);
    return mainBranches.some(branch => branch.getSha() === currentBranch.getSha());
  }

  pushesToDifferentRemote() {
    const p = this.props.branches.getHeadBranch().getPush();

    if (!p.isRemoteTracking()) {
      return false;
    }

    const pushRemoteName = p.getRemoteName();
    return pushRemoteName !== this.props.remote.getName();
  }

  hasUpstreamBranch() {
    return this.props.branches.getHeadBranch().getUpstream().isPresent();
  }

}

exports["default"] = CreatePullRequestTile;

_defineProperty(CreatePullRequestTile, "propTypes", {
  repository: _propTypes["default"].shape({
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }),
  remote: _propTypes2.RemotePropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  onCreatePr: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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