"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

var _relayRuntime = require("relay-runtime");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/addPrReviewMutation.graphql");

  if (node.hash && node.hash !== "765a0aef6c6805d1733e99f53db0e82b") {
    console.error("The definition of 'addPrReviewMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/addPrReviewMutation.graphql");
};

let placeholderID = 0;

var _default = (environment, {
  body,
  event,
  pullRequestID,
  viewerID
}) => {
  const variables = {
    input: {
      pullRequestId: pullRequestID
    }
  };

  if (body) {
    variables.input.body = body;
  }

  if (event) {
    variables.input.event = event;
  }

  const configs = [{
    type: 'RANGE_ADD',
    parentID: pullRequestID,
    connectionInfo: [{
      key: 'ReviewSummariesAccumulator_reviews',
      rangeBehavior: 'append'
    }],
    edgeName: 'reviewEdge'
  }];

  function optimisticUpdater(store) {
    const pullRequest = store.get(pullRequestID);

    if (!pullRequest) {
      return;
    }

    const id = `add-pr-review:review:${placeholderID++}`;
    const review = store.create(id, 'PullRequestReview');
    review.setValue(id, 'id');
    review.setValue('PENDING', 'state');
    review.setValue(body || '...', 'bodyHTML');
    review.setLinkedRecords([], 'reactionGroups');
    let author;

    if (viewerID) {
      author = store.get(viewerID);
    } else {
      author = store.create(`add-pr-review-comment:author:${placeholderID++}`, 'User');
      author.setValue('...', 'login');
      author.setValue('atom://github/img/avatar.svg', 'avatarUrl');
    }

    review.setLinkedRecord(author, 'author');

    const reviews = _relayRuntime.ConnectionHandler.getConnection(pullRequest, 'ReviewSummariesAccumulator_reviews');

    const edge = _relayRuntime.ConnectionHandler.createEdge(store, reviews, review, 'PullRequestReviewEdge');

    _relayRuntime.ConnectionHandler.insertEdgeAfter(reviews, edge);
  }

  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      configs,
      optimisticUpdater,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZC1wci1yZXZpZXcuanMiXSwibmFtZXMiOlsibXV0YXRpb24iLCJwbGFjZWhvbGRlcklEIiwiZW52aXJvbm1lbnQiLCJib2R5IiwiZXZlbnQiLCJwdWxsUmVxdWVzdElEIiwidmlld2VySUQiLCJ2YXJpYWJsZXMiLCJpbnB1dCIsInB1bGxSZXF1ZXN0SWQiLCJjb25maWdzIiwidHlwZSIsInBhcmVudElEIiwiY29ubmVjdGlvbkluZm8iLCJrZXkiLCJyYW5nZUJlaGF2aW9yIiwiZWRnZU5hbWUiLCJvcHRpbWlzdGljVXBkYXRlciIsInN0b3JlIiwicHVsbFJlcXVlc3QiLCJnZXQiLCJpZCIsInJldmlldyIsImNyZWF0ZSIsInNldFZhbHVlIiwic2V0TGlua2VkUmVjb3JkcyIsImF1dGhvciIsInNldExpbmtlZFJlY29yZCIsInJldmlld3MiLCJDb25uZWN0aW9uSGFuZGxlciIsImdldENvbm5lY3Rpb24iLCJlZGdlIiwiY3JlYXRlRWRnZSIsImluc2VydEVkZ2VBZnRlciIsIlByb21pc2UiLCJyZXNvbHZlIiwicmVqZWN0Iiwib25Db21wbGV0ZWQiLCJvbkVycm9yIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBRUE7O0FBQ0E7O0FBSEE7QUFLQSxNQUFNQSxRQUFRO0FBQUE7O0FBQUE7QUFBQTtBQUFBOztBQUFBO0FBQUEsQ0FBZDs7QUFvQkEsSUFBSUMsYUFBYSxHQUFHLENBQXBCOztlQUVlLENBQUNDLFdBQUQsRUFBYztBQUFDQyxFQUFBQSxJQUFEO0FBQU9DLEVBQUFBLEtBQVA7QUFBY0MsRUFBQUEsYUFBZDtBQUE2QkMsRUFBQUE7QUFBN0IsQ0FBZCxLQUF5RDtBQUN0RSxRQUFNQyxTQUFTLEdBQUc7QUFDaEJDLElBQUFBLEtBQUssRUFBRTtBQUFDQyxNQUFBQSxhQUFhLEVBQUVKO0FBQWhCO0FBRFMsR0FBbEI7O0FBSUEsTUFBSUYsSUFBSixFQUFVO0FBQ1JJLElBQUFBLFNBQVMsQ0FBQ0MsS0FBVixDQUFnQkwsSUFBaEIsR0FBdUJBLElBQXZCO0FBQ0Q7O0FBQ0QsTUFBSUMsS0FBSixFQUFXO0FBQ1RHLElBQUFBLFNBQVMsQ0FBQ0MsS0FBVixDQUFnQkosS0FBaEIsR0FBd0JBLEtBQXhCO0FBQ0Q7O0FBRUQsUUFBTU0sT0FBTyxHQUFHLENBQUM7QUFDZkMsSUFBQUEsSUFBSSxFQUFFLFdBRFM7QUFFZkMsSUFBQUEsUUFBUSxFQUFFUCxhQUZLO0FBR2ZRLElBQUFBLGNBQWMsRUFBRSxDQUFDO0FBQUNDLE1BQUFBLEdBQUcsRUFBRSxvQ0FBTjtBQUE0Q0MsTUFBQUEsYUFBYSxFQUFFO0FBQTNELEtBQUQsQ0FIRDtBQUlmQyxJQUFBQSxRQUFRLEVBQUU7QUFKSyxHQUFELENBQWhCOztBQU9BLFdBQVNDLGlCQUFULENBQTJCQyxLQUEzQixFQUFrQztBQUNoQyxVQUFNQyxXQUFXLEdBQUdELEtBQUssQ0FBQ0UsR0FBTixDQUFVZixhQUFWLENBQXBCOztBQUNBLFFBQUksQ0FBQ2MsV0FBTCxFQUFrQjtBQUNoQjtBQUNEOztBQUVELFVBQU1FLEVBQUUsR0FBSSx3QkFBdUJwQixhQUFhLEVBQUcsRUFBbkQ7QUFDQSxVQUFNcUIsTUFBTSxHQUFHSixLQUFLLENBQUNLLE1BQU4sQ0FBYUYsRUFBYixFQUFpQixtQkFBakIsQ0FBZjtBQUNBQyxJQUFBQSxNQUFNLENBQUNFLFFBQVAsQ0FBZ0JILEVBQWhCLEVBQW9CLElBQXBCO0FBQ0FDLElBQUFBLE1BQU0sQ0FBQ0UsUUFBUCxDQUFnQixTQUFoQixFQUEyQixPQUEzQjtBQUNBRixJQUFBQSxNQUFNLENBQUNFLFFBQVAsQ0FBZ0JyQixJQUFJLElBQUksS0FBeEIsRUFBK0IsVUFBL0I7QUFDQW1CLElBQUFBLE1BQU0sQ0FBQ0csZ0JBQVAsQ0FBd0IsRUFBeEIsRUFBNEIsZ0JBQTVCO0FBRUEsUUFBSUMsTUFBSjs7QUFDQSxRQUFJcEIsUUFBSixFQUFjO0FBQ1pvQixNQUFBQSxNQUFNLEdBQUdSLEtBQUssQ0FBQ0UsR0FBTixDQUFVZCxRQUFWLENBQVQ7QUFDRCxLQUZELE1BRU87QUFDTG9CLE1BQUFBLE1BQU0sR0FBR1IsS0FBSyxDQUFDSyxNQUFOLENBQWMsZ0NBQStCdEIsYUFBYSxFQUFHLEVBQTdELEVBQWdFLE1BQWhFLENBQVQ7QUFDQXlCLE1BQUFBLE1BQU0sQ0FBQ0YsUUFBUCxDQUFnQixLQUFoQixFQUF1QixPQUF2QjtBQUNBRSxNQUFBQSxNQUFNLENBQUNGLFFBQVAsQ0FBZ0IsOEJBQWhCLEVBQWdELFdBQWhEO0FBQ0Q7O0FBQ0RGLElBQUFBLE1BQU0sQ0FBQ0ssZUFBUCxDQUF1QkQsTUFBdkIsRUFBK0IsUUFBL0I7O0FBRUEsVUFBTUUsT0FBTyxHQUFHQyxnQ0FBa0JDLGFBQWxCLENBQWdDWCxXQUFoQyxFQUE2QyxvQ0FBN0MsQ0FBaEI7O0FBQ0EsVUFBTVksSUFBSSxHQUFHRixnQ0FBa0JHLFVBQWxCLENBQTZCZCxLQUE3QixFQUFvQ1UsT0FBcEMsRUFBNkNOLE1BQTdDLEVBQXFELHVCQUFyRCxDQUFiOztBQUNBTyxvQ0FBa0JJLGVBQWxCLENBQWtDTCxPQUFsQyxFQUEyQ0csSUFBM0M7QUFDRDs7QUFFRCxTQUFPLElBQUlHLE9BQUosQ0FBWSxDQUFDQyxPQUFELEVBQVVDLE1BQVYsS0FBcUI7QUFDdEMsb0NBQ0VsQyxXQURGLEVBRUU7QUFDRUYsTUFBQUEsUUFERjtBQUVFTyxNQUFBQSxTQUZGO0FBR0VHLE1BQUFBLE9BSEY7QUFJRU8sTUFBQUEsaUJBSkY7QUFLRW9CLE1BQUFBLFdBQVcsRUFBRUYsT0FMZjtBQU1FRyxNQUFBQSxPQUFPLEVBQUVGO0FBTlgsS0FGRjtBQVdELEdBWk0sQ0FBUDtBQWFELEMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zOC4xL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbIi8qIGlzdGFuYnVsIGlnbm9yZSBmaWxlICovXG5cbmltcG9ydCB7Y29tbWl0TXV0YXRpb24sIGdyYXBocWx9IGZyb20gJ3JlYWN0LXJlbGF5JztcbmltcG9ydCB7Q29ubmVjdGlvbkhhbmRsZXJ9IGZyb20gJ3JlbGF5LXJ1bnRpbWUnO1xuXG5jb25zdCBtdXRhdGlvbiA9IGdyYXBocWxgXG4gIG11dGF0aW9uIGFkZFByUmV2aWV3TXV0YXRpb24oJGlucHV0OiBBZGRQdWxsUmVxdWVzdFJldmlld0lucHV0ISkge1xuICAgIGFkZFB1bGxSZXF1ZXN0UmV2aWV3KGlucHV0OiAkaW5wdXQpIHtcbiAgICAgIHJldmlld0VkZ2Uge1xuICAgICAgICBub2RlIHtcbiAgICAgICAgICBpZFxuICAgICAgICAgIGJvZHlIVE1MXG4gICAgICAgICAgc3RhdGVcbiAgICAgICAgICBzdWJtaXR0ZWRBdFxuICAgICAgICAgIGF1dGhvciB7XG4gICAgICAgICAgICBsb2dpblxuICAgICAgICAgICAgYXZhdGFyVXJsXG4gICAgICAgICAgfVxuICAgICAgICAgIC4uLmVtb2ppUmVhY3Rpb25zQ29udHJvbGxlcl9yZWFjdGFibGVcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgfVxuYDtcblxubGV0IHBsYWNlaG9sZGVySUQgPSAwO1xuXG5leHBvcnQgZGVmYXVsdCAoZW52aXJvbm1lbnQsIHtib2R5LCBldmVudCwgcHVsbFJlcXVlc3RJRCwgdmlld2VySUR9KSA9PiB7XG4gIGNvbnN0IHZhcmlhYmxlcyA9IHtcbiAgICBpbnB1dDoge3B1bGxSZXF1ZXN0SWQ6IHB1bGxSZXF1ZXN0SUR9LFxuICB9O1xuXG4gIGlmIChib2R5KSB7XG4gICAgdmFyaWFibGVzLmlucHV0LmJvZHkgPSBib2R5O1xuICB9XG4gIGlmIChldmVudCkge1xuICAgIHZhcmlhYmxlcy5pbnB1dC5ldmVudCA9IGV2ZW50O1xuICB9XG5cbiAgY29uc3QgY29uZmlncyA9IFt7XG4gICAgdHlwZTogJ1JBTkdFX0FERCcsXG4gICAgcGFyZW50SUQ6IHB1bGxSZXF1ZXN0SUQsXG4gICAgY29ubmVjdGlvbkluZm86IFt7a2V5OiAnUmV2aWV3U3VtbWFyaWVzQWNjdW11bGF0b3JfcmV2aWV3cycsIHJhbmdlQmVoYXZpb3I6ICdhcHBlbmQnfV0sXG4gICAgZWRnZU5hbWU6ICdyZXZpZXdFZGdlJyxcbiAgfV07XG5cbiAgZnVuY3Rpb24gb3B0aW1pc3RpY1VwZGF0ZXIoc3RvcmUpIHtcbiAgICBjb25zdCBwdWxsUmVxdWVzdCA9IHN0b3JlLmdldChwdWxsUmVxdWVzdElEKTtcbiAgICBpZiAoIXB1bGxSZXF1ZXN0KSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuXG4gICAgY29uc3QgaWQgPSBgYWRkLXByLXJldmlldzpyZXZpZXc6JHtwbGFjZWhvbGRlcklEKyt9YDtcbiAgICBjb25zdCByZXZpZXcgPSBzdG9yZS5jcmVhdGUoaWQsICdQdWxsUmVxdWVzdFJldmlldycpO1xuICAgIHJldmlldy5zZXRWYWx1ZShpZCwgJ2lkJyk7XG4gICAgcmV2aWV3LnNldFZhbHVlKCdQRU5ESU5HJywgJ3N0YXRlJyk7XG4gICAgcmV2aWV3LnNldFZhbHVlKGJvZHkgfHwgJy4uLicsICdib2R5SFRNTCcpO1xuICAgIHJldmlldy5zZXRMaW5rZWRSZWNvcmRzKFtdLCAncmVhY3Rpb25Hcm91cHMnKTtcblxuICAgIGxldCBhdXRob3I7XG4gICAgaWYgKHZpZXdlcklEKSB7XG4gICAgICBhdXRob3IgPSBzdG9yZS5nZXQodmlld2VySUQpO1xuICAgIH0gZWxzZSB7XG4gICAgICBhdXRob3IgPSBzdG9yZS5jcmVhdGUoYGFkZC1wci1yZXZpZXctY29tbWVudDphdXRob3I6JHtwbGFjZWhvbGRlcklEKyt9YCwgJ1VzZXInKTtcbiAgICAgIGF1dGhvci5zZXRWYWx1ZSgnLi4uJywgJ2xvZ2luJyk7XG4gICAgICBhdXRob3Iuc2V0VmFsdWUoJ2F0b206Ly9naXRodWIvaW1nL2F2YXRhci5zdmcnLCAnYXZhdGFyVXJsJyk7XG4gICAgfVxuICAgIHJldmlldy5zZXRMaW5rZWRSZWNvcmQoYXV0aG9yLCAnYXV0aG9yJyk7XG5cbiAgICBjb25zdCByZXZpZXdzID0gQ29ubmVjdGlvbkhhbmRsZXIuZ2V0Q29ubmVjdGlvbihwdWxsUmVxdWVzdCwgJ1Jldmlld1N1bW1hcmllc0FjY3VtdWxhdG9yX3Jldmlld3MnKTtcbiAgICBjb25zdCBlZGdlID0gQ29ubmVjdGlvbkhhbmRsZXIuY3JlYXRlRWRnZShzdG9yZSwgcmV2aWV3cywgcmV2aWV3LCAnUHVsbFJlcXVlc3RSZXZpZXdFZGdlJyk7XG4gICAgQ29ubmVjdGlvbkhhbmRsZXIuaW5zZXJ0RWRnZUFmdGVyKHJldmlld3MsIGVkZ2UpO1xuICB9XG5cbiAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICBjb21taXRNdXRhdGlvbihcbiAgICAgIGVudmlyb25tZW50LFxuICAgICAge1xuICAgICAgICBtdXRhdGlvbixcbiAgICAgICAgdmFyaWFibGVzLFxuICAgICAgICBjb25maWdzLFxuICAgICAgICBvcHRpbWlzdGljVXBkYXRlcixcbiAgICAgICAgb25Db21wbGV0ZWQ6IHJlc29sdmUsXG4gICAgICAgIG9uRXJyb3I6IHJlamVjdCxcbiAgICAgIH0sXG4gICAgKTtcbiAgfSk7XG59O1xuIl19