"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Git is asynchronously cloning a repository into this working directory.
 */
class Cloning extends _state["default"] {
  constructor(repository, remoteUrl) {
    super(repository);
    this.remoteUrl = remoteUrl;
  }

  async start() {
    await _fsExtra["default"].mkdirs(this.workdir());
    await this.doClone(this.remoteUrl, {
      recursive: true
    });
    await this.transitionTo('Loading');
  }

  showGitTabLoading() {
    return true;
  }

  directClone(remoteUrl, options) {
    return this.git().clone(remoteUrl, options);
  }

}

exports["default"] = Cloning;

_state["default"].register(Cloning);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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