"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _url = require("url");

var _moment = _interopRequireDefault(require("moment"));

var _prStatusesView = require("../views/pr-statuses-view");

var _helpers = require("../helpers");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

class Issueish {
  constructor(data) {
    const author = data.author || _helpers.GHOST_USER;
    this.number = data.number;
    this.title = data.title;
    this.url = new _url.URL(data.url);
    this.authorLogin = author.login;
    this.authorAvatarURL = new _url.URL(author.avatarUrl);
    this.createdAt = (0, _moment["default"])(data.createdAt, _moment["default"].ISO_8601);
    this.headRefName = data.headRefName;
    this.headRepositoryID = data.repository.id;
    this.statusContexts = data.commits.nodes.reduce((acc, node) => {
      const status = node.commit.status;

      if (status !== null) {
        acc.push(...status.contexts);
      }

      return acc;
    }, []);
  }

  getNumber() {
    return this.number;
  }

  getTitle() {
    return this.title;
  }

  getGitHubURL() {
    return this.url.toString();
  }

  getAuthorLogin() {
    return this.authorLogin;
  }

  getAuthorAvatarURL(size = 32) {
    const u = new _url.URL(this.authorAvatarURL.toString());
    u.searchParams.set('s', size);
    return u.toString();
  }

  getCreatedAt() {
    return this.createdAt;
  }

  getHeadRefName() {
    return this.headRefName;
  }

  getHeadRepositoryID() {
    return this.headRepositoryID;
  }

  getStatusCounts() {
    return this.statusContexts.reduce((acc, context) => {
      acc[(0, _prStatusesView.category)(context.state).toLowerCase()]++;
      return acc;
    }, {
      pending: 0,
      failure: 0,
      success: 0
    });
  }

}

exports["default"] = Issueish;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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