"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BASE = exports.THEIRS = exports.OURS = void 0;

class Source {
  constructor(name, uiString, cssClass) {
    this.name = name.toLowerCase();
    this.uiString = uiString;
    this.cssClass = cssClass;
  }

  when(actions) {
    const chosen = actions[this.name] || actions["default"] || (() => {
      throw new Error(`Unexpected conflict side source: ${this.name}`);
    });

    return chosen();
  }

  getName() {
    return this.name;
  }

  getCSSClass() {
    return this.cssClass;
  }

  getBannerCSSClass() {
    return this.cssClass + 'Banner';
  }

  getBlockCSSClass() {
    return this.cssClass + 'Block';
  }

  toUIString() {
    return this.uiString;
  }

  toString() {
    return `<Source: ${this.name.toUpperCase()}>`;
  }

}

const OURS = new Source('OURS', 'our changes', 'github-ConflictOurs');
exports.OURS = OURS;
const THEIRS = new Source('THEIRS', 'their changes', 'github-ConflictTheirs');
exports.THEIRS = THEIRS;
const BASE = new Source('BASE', 'common ancestor', 'github-ConflictBase');
exports.BASE = BASE;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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