"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nullAuthor = exports["default"] = exports.NO_REPLY_GITHUB_EMAIL = void 0;
const NEW = Symbol('new');
const NO_REPLY_GITHUB_EMAIL = 'noreply@github.com';
exports.NO_REPLY_GITHUB_EMAIL = NO_REPLY_GITHUB_EMAIL;

class Author {
  constructor(email, fullName, login = null, isNew = null) {
    this.email = email;
    this.fullName = fullName;
    this.login = login;
    this["new"] = isNew === NEW;
  }

  static createNew(email, fullName) {
    return new this(email, fullName, null, NEW);
  }

  getEmail() {
    return this.email;
  }

  getFullName() {
    return this.fullName;
  }

  getLogin() {
    return this.login;
  }

  isNoReply() {
    return this.email === NO_REPLY_GITHUB_EMAIL;
  }

  hasLogin() {
    return this.login !== null;
  }

  isNew() {
    return this["new"];
  }

  isPresent() {
    return true;
  }

  matches(other) {
    return this.getEmail() === other.getEmail();
  }

  toString() {
    let s = `${this.fullName} <${this.email}>`;

    if (this.hasLogin()) {
      s += ` @${this.login}`;
    }

    return s;
  }

  static compare(a, b) {
    if (a.getFullName() < b.getFullName()) {
      return -1;
    }

    if (a.getFullName() > b.getFullName()) {
      return 1;
    }

    return 0;
  }

}

exports["default"] = Author;
const nullAuthor = {
  getEmail() {
    return '';
  },

  getFullName() {
    return '';
  },

  getLogin() {
    return null;
  },

  isNoReply() {
    return false;
  },

  hasLogin() {
    return false;
  },

  isNew() {
    return false;
  },

  isPresent() {
    return false;
  },

  matches(other) {
    return other === this;
  },

  toString() {
    return 'null author';
  }

};
exports.nullAuthor = nullAuthor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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