"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _reporterProxy = require("../reporter-proxy");

var _repository = _interopRequireDefault(require("../models/repository"));

var _endpoint = require("../models/endpoint");

var _issueishDetailContainer = _interopRequireDefault(require("../containers/issueish-detail-container"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishDetailItem extends _react.Component {
  static buildURI({
    host,
    owner,
    repo,
    number,
    workdir
  }) {
    const encodeOptionalParam = param => param ? encodeURIComponent(param) : '';

    return 'atom-github://issueish/' + encodeURIComponent(host) + '/' + encodeURIComponent(owner) + '/' + encodeURIComponent(repo) + '/' + encodeURIComponent(number) + '?workdir=' + encodeOptionalParam(workdir);
  }

  constructor(props) {
    super(props);

    _defineProperty(this, "destroy", () => {
      /* istanbul ignore else */
      if (!this.isDestroyed) {
        this.emitter.emit('did-destroy');
        this.isDestroyed = true;
      }
    });

    _defineProperty(this, "onTabSelected", index => new Promise(resolve => {
      this.setState({
        selectedTab: index,
        initChangedFilePath: '',
        initChangedFilePosition: 0
      }, resolve);
    }));

    _defineProperty(this, "onOpenFilesTab", callback => this.emitter.on('on-open-files-tab', callback));

    (0, _helpers.autobind)(this, 'switchToIssueish', 'handleTitleChanged');
    this.emitter = new _eventKit.Emitter();
    this.title = `${this.props.owner}/${this.props.repo}#${this.props.issueishNumber}`;
    this.hasTerminatedPendingState = false;
    const repository = this.props.workingDirectory === '' ? _repository["default"].absent() : this.props.workdirContextPool.add(this.props.workingDirectory).getRepository();
    this.state = {
      host: this.props.host,
      owner: this.props.owner,
      repo: this.props.repo,
      issueishNumber: this.props.issueishNumber,
      repository,
      initChangedFilePath: '',
      initChangedFilePosition: 0,
      selectedTab: this.props.initSelectedTab
    };

    if (repository.isAbsent()) {
      this.switchToIssueish(this.props.owner, this.props.repo, this.props.issueishNumber);
    }

    this.refEditor = new _refHolder["default"]();
    this.refEditor.observe(editor => {
      if (editor.isAlive()) {
        this.emitter.emit('did-change-embedded-text-editor', editor);
      }
    });
  }

  render() {
    return _react["default"].createElement(_issueishDetailContainer["default"], {
      endpoint: (0, _endpoint.getEndpoint)(this.state.host),
      owner: this.state.owner,
      repo: this.state.repo,
      issueishNumber: this.state.issueishNumber,
      initChangedFilePath: this.state.initChangedFilePath,
      initChangedFilePosition: this.state.initChangedFilePosition,
      selectedTab: this.state.selectedTab,
      onTabSelected: this.onTabSelected,
      onOpenFilesTab: this.onOpenFilesTab,
      repository: this.state.repository,
      workspace: this.props.workspace,
      loginModel: this.props.loginModel,
      onTitleChange: this.handleTitleChanged,
      switchToIssueish: this.switchToIssueish,
      commands: this.props.commands,
      keymaps: this.props.keymaps,
      tooltips: this.props.tooltips,
      config: this.props.config,
      destroy: this.destroy,
      itemType: this.constructor,
      refEditor: this.refEditor,
      reportMutationErrors: this.props.reportMutationErrors
    });
  }

  async switchToIssueish(owner, repo, issueishNumber) {
    const pool = this.props.workdirContextPool;
    const prev = {
      owner: this.state.owner,
      repo: this.state.repo,
      issueishNumber: this.state.issueishNumber
    };
    const nextRepository = (await this.state.repository.hasGitHubRemote(this.state.host, owner, repo)) ? this.state.repository : (await pool.getMatchingContext(this.state.host, owner, repo)).getRepository();
    await new Promise(resolve => {
      this.setState((prevState, props) => {
        if (pool === props.workdirContextPool && prevState.owner === prev.owner && prevState.repo === prev.repo && prevState.issueishNumber === prev.issueishNumber) {
          (0, _reporterProxy.addEvent)('open-issueish-in-pane', {
            "package": 'github',
            from: 'issueish-link',
            target: 'current-tab'
          });
          return {
            owner,
            repo,
            issueishNumber,
            repository: nextRepository
          };
        }

        return {};
      }, resolve);
    });
  }

  handleTitleChanged(title) {
    if (this.title !== title) {
      this.title = title;
      this.emitter.emit('did-change-title', title);
    }
  }

  onDidChangeTitle(cb) {
    return this.emitter.on('did-change-title', cb);
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  serialize() {
    return {
      uri: IssueishDetailItem.buildURI({
        host: this.props.host,
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.issueishNumber,
        workdir: this.props.workingDirectory
      }),
      selectedTab: this.state.selectedTab,
      deserializer: 'IssueishDetailItem'
    };
  }

  getTitle() {
    return this.title;
  }

  observeEmbeddedTextEditor(cb) {
    this.refEditor.map(editor => editor.isAlive() && cb(editor));
    return this.emitter.on('did-change-embedded-text-editor', cb);
  }

  openFilesTab({
    changedFilePath,
    changedFilePosition
  }) {
    this.setState({
      selectedTab: IssueishDetailItem.tabs.FILES,
      initChangedFilePath: changedFilePath,
      initChangedFilePosition: changedFilePosition
    }, () => {
      this.emitter.emit('on-open-files-tab', {
        changedFilePath,
        changedFilePosition
      });
    });
  }

}

exports["default"] = IssueishDetailItem;

_defineProperty(IssueishDetailItem, "tabs", {
  OVERVIEW: 0,
  BUILD_STATUS: 1,
  COMMITS: 2,
  FILES: 3
});

_defineProperty(IssueishDetailItem, "propTypes", {
  // Issueish selection criteria
  // Parsed from item URI
  host: _propTypes["default"].string.isRequired,
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  issueishNumber: _propTypes["default"].number.isRequired,
  workingDirectory: _propTypes["default"].string.isRequired,
  // Package models
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  initSelectedTab: _propTypes["default"].oneOf(Object.keys(IssueishDetailItem.tabs).map(k => IssueishDetailItem.tabs[k])),
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // Action methods
  reportMutationErrors: _propTypes["default"].func.isRequired
});

_defineProperty(IssueishDetailItem, "defaultProps", {
  initSelectedTab: IssueishDetailItem.tabs.OVERVIEW
});

_defineProperty(IssueishDetailItem, "uriPattern", 'atom-github://issueish/{host}/{owner}/{repo}/{issueishNumber}?workdir={workingDirectory}');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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