"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _branchView = _interopRequireDefault(require("../views/branch-view"));

var _branchMenuView = _interopRequireDefault(require("../views/branch-menu-view"));

var _pushPullView = _interopRequireDefault(require("../views/push-pull-view"));

var _changedFilesCountView = _interopRequireDefault(require("../views/changed-files-count-view"));

var _githubTileView = _interopRequireDefault(require("../views/github-tile-view"));

var _tooltip = _interopRequireDefault(require("../atom/tooltip"));

var _commands = _interopRequireWildcard(require("../atom/commands"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class StatusBarTileController extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "fetchData", repository => {
      return (0, _yubikiri["default"])({
        currentBranch: repository.getCurrentBranch(),
        branches: repository.getBranches(),
        statusesForChangedFiles: repository.getStatusesForChangedFiles(),
        currentRemote: async query => repository.getRemoteForBranch((await query.currentBranch).getName()),
        aheadCount: async query => repository.getAheadCount((await query.currentBranch).getName()),
        behindCount: async query => repository.getBehindCount((await query.currentBranch).getName()),
        originExists: async () => (await repository.getRemotes()).withName('origin').isPresent()
      });
    });

    _defineProperty(this, "handleOpenGitTimingsView", e => {
      e && e.preventDefault();
      this.props.workspace.open('atom-github://debug/timings');
    });

    _defineProperty(this, "checkout", (branchName, options) => {
      return this.props.repository.checkout(branchName, options);
    });

    this.refBranchViewRoot = new _refHolder["default"]();
  }

  getChangedFilesCount(data) {
    const {
      stagedFiles,
      unstagedFiles,
      mergeConflictFiles
    } = data.statusesForChangedFiles;
    const changedFiles = new Set();

    for (const filePath in unstagedFiles) {
      changedFiles.add(filePath);
    }

    for (const filePath in stagedFiles) {
      changedFiles.add(filePath);
    }

    for (const filePath in mergeConflictFiles) {
      changedFiles.add(filePath);
    }

    return changedFiles.size;
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.repository,
      fetchData: this.fetchData
    }, data => data ? this.renderWithData(data) : null);
  }

  renderWithData(data) {
    let changedFilesCount, mergeConflictsPresent;

    if (data.statusesForChangedFiles) {
      changedFilesCount = this.getChangedFilesCount(data);
      mergeConflictsPresent = Object.keys(data.statusesForChangedFiles.mergeConflictFiles).length > 0;
    }

    const repoProps = {
      repository: this.props.repository,
      currentBranch: data.currentBranch,
      branches: data.branches,
      currentRemote: data.currentRemote,
      aheadCount: data.aheadCount,
      behindCount: data.behindCount,
      originExists: data.originExists,
      changedFilesCount,
      mergeConflictsPresent
    };
    return _react["default"].createElement(_react.Fragment, null, this.renderTiles(repoProps), _react["default"].createElement(_githubTileView["default"], {
      didClick: this.props.toggleGithubTab
    }), _react["default"].createElement(_changedFilesCountView["default"], {
      didClick: this.props.toggleGitTab,
      changedFilesCount: repoProps.changedFilesCount,
      mergeConflictsPresent: repoProps.mergeConflictsPresent
    }));
  }

  renderTiles(repoProps) {
    if (!this.props.repository.showStatusBarTiles()) {
      return null;
    }

    const operationStates = this.props.repository.getOperationStates();
    const pushInProgress = operationStates.isPushInProgress();
    const pullInProgress = operationStates.isPullInProgress();
    const fetchInProgress = operationStates.isFetchInProgress();
    return _react["default"].createElement(_react.Fragment, null, _react["default"].createElement(_commands["default"], {
      registry: this.props.commandRegistry,
      target: "atom-workspace"
    }, _react["default"].createElement(_commands.Command, {
      command: "github:fetch",
      callback: this.fetch(repoProps)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:pull",
      callback: this.pull(repoProps)
    }), _react["default"].createElement(_commands.Command, {
      command: "github:push",
      callback: () => this.push(repoProps)({
        force: false,
        setUpstream: !repoProps.currentRemote.isPresent()
      })
    }), _react["default"].createElement(_commands.Command, {
      command: "github:force-push",
      callback: () => this.push(repoProps)({
        force: true,
        setUpstream: !repoProps.currentRemote.isPresent()
      })
    })), _react["default"].createElement(_branchView["default"], {
      refRoot: this.refBranchViewRoot.setter,
      workspace: this.props.workspace,
      checkout: this.checkout,
      currentBranch: repoProps.currentBranch
    }), _react["default"].createElement(_tooltip["default"], {
      manager: this.props.tooltips,
      target: this.refBranchViewRoot,
      trigger: "click",
      className: "github-StatusBarTileController-tooltipMenu"
    }, _react["default"].createElement(_branchMenuView["default"], {
      workspace: this.props.workspace,
      notificationManager: this.props.notificationManager,
      commandRegistry: this.props.commandRegistry,
      checkout: this.checkout,
      branches: repoProps.branches,
      currentBranch: repoProps.currentBranch
    })), _react["default"].createElement(_pushPullView["default"], {
      isSyncing: fetchInProgress || pullInProgress || pushInProgress,
      isFetching: fetchInProgress,
      isPulling: pullInProgress,
      isPushing: pushInProgress,
      push: this.push(repoProps),
      pull: this.pull(repoProps),
      fetch: this.fetch(repoProps),
      tooltipManager: this.props.tooltips,
      currentBranch: repoProps.currentBranch,
      currentRemote: repoProps.currentRemote,
      behindCount: repoProps.behindCount,
      aheadCount: repoProps.aheadCount,
      originExists: repoProps.originExists
    }));
  }

  push(data) {
    return ({
      force,
      setUpstream
    } = {}) => {
      return this.props.repository.push(data.currentBranch.getName(), {
        force,
        setUpstream,
        refSpec: data.currentBranch.getRefSpec('PUSH')
      });
    };
  }

  pull(data) {
    return () => {
      return this.props.repository.pull(data.currentBranch.getName(), {
        refSpec: data.currentBranch.getRefSpec('PULL')
      });
    };
  }

  fetch(data) {
    return () => {
      const upstream = data.currentBranch.getUpstream();
      return this.props.repository.fetch(upstream.getRemoteRef(), {
        remoteName: upstream.getRemoteName()
      });
    };
  }

}

exports["default"] = StatusBarTileController;

_defineProperty(StatusBarTileController, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  notificationManager: _propTypes["default"].object.isRequired,
  commandRegistry: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  confirm: _propTypes["default"].func.isRequired,
  repository: _propTypes["default"].object.isRequired,
  toggleGitTab: _propTypes["default"].func,
  toggleGithubTab: _propTypes["default"].func
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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