"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _electron = require("electron");

var _propTypes2 = require("../prop-types");

var _search = _interopRequireDefault(require("../models/search"));

var _issueishSearchContainer = _interopRequireDefault(require("../containers/issueish-search-container"));

var _currentPullRequestContainer = _interopRequireDefault(require("../containers/current-pull-request-container"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _reviewsItem = _interopRequireDefault(require("../items/reviews-item"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishSearchesController extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {});

    _defineProperty(this, "onOpenReviews", issueish => {
      const uri = _reviewsItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.remote.getOwner(),
        repo: this.props.remote.getRepo(),
        number: issueish.getNumber(),
        workdir: this.props.workingDirectory
      });

      return this.props.workspace.open(uri).then(() => {
        (0, _reporterProxy.addEvent)('open-reviews-tab', {
          "package": 'github',
          from: this.constructor.name
        });
      });
    });

    _defineProperty(this, "onOpenIssueish", issueish => {
      return this.props.workspace.open(_issueishDetailItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.remote.getOwner(),
        repo: this.props.remote.getRepo(),
        number: issueish.getNumber(),
        workdir: this.props.workingDirectory
      }), {
        pending: true,
        searchAllPanes: true
      }).then(() => {
        (0, _reporterProxy.addEvent)('open-issueish-in-pane', {
          "package": 'github',
          from: 'issueish-list'
        });
      });
    });

    _defineProperty(this, "onOpenSearch", search => {
      const searchURL = search.getWebURL(this.props.remote);
      return new Promise((resolve, reject) => {
        _electron.shell.openExternal(searchURL, {}, err => {
          if (err) {
            reject(err);
          } else {
            resolve();
          }
        });
      });
    });
  }

  static getDerivedStateFromProps(props) {
    return {
      searches: [_search["default"].inRemote(props.remote, 'Open pull requests', 'type:pr state:open')]
    };
  }

  render() {
    return _react["default"].createElement("div", {
      className: "github-IssueishSearch"
    }, _react["default"].createElement(_currentPullRequestContainer["default"], {
      repository: this.props.repository,
      token: this.props.token,
      endpoint: this.props.endpoint,
      remoteOperationObserver: this.props.remoteOperationObserver,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      workspace: this.props.workspace,
      workingDirectory: this.props.workingDirectory,
      onOpenIssueish: this.onOpenIssueish,
      onOpenReviews: this.onOpenReviews,
      onCreatePr: this.props.onCreatePr
    }), this.state.searches.map(search => _react["default"].createElement(_issueishSearchContainer["default"], {
      key: search.getName(),
      token: this.props.token,
      endpoint: this.props.endpoint,
      search: search,
      remoteOperationObserver: this.props.remoteOperationObserver,
      onOpenIssueish: this.onOpenIssueish,
      onOpenSearch: this.onOpenSearch,
      onOpenReviews: this.onOpenReviews
    })));
  }

}

exports["default"] = IssueishSearchesController;

_defineProperty(IssueishSearchesController, "propTypes", {
  // Relay payload
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }),
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  // Repository model attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  workingDirectory: _propTypes["default"].string,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  // Actions
  onCreatePr: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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