"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _atom = require("atom");

var _propTypes2 = require("../prop-types");

var _marker = _interopRequireDefault(require("../atom/marker"));

var _decoration = _interopRequireDefault(require("../atom/decoration"));

var _commentGutterDecorationController = _interopRequireDefault(require("../controllers/comment-gutter-decoration-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class EditorCommentDecorationsController extends _react["default"].Component {
  constructor(props) {
    super(props);
    this.rangesByRootID = new Map();
  }

  shouldComponentUpdate(nextProps) {
    return translationDigestFrom(this.props) !== translationDigestFrom(nextProps);
  }

  render() {
    if (!this.props.commentTranslationsForPath) {
      return null;
    }

    return this.props.threadsForPath.map(thread => {
      const range = this.getRangeForThread(thread);

      if (!range) {
        return null;
      }

      return _react["default"].createElement(_react.Fragment, {
        key: `github-editor-review-decoration-${thread.rootCommentID}`
      }, _react["default"].createElement(_marker["default"], {
        editor: this.props.editor,
        exclusive: true,
        invalidate: "surround",
        bufferRange: range,
        didChange: evt => this.markerDidChange(thread.rootCommentID, evt)
      }, _react["default"].createElement(_decoration["default"], {
        type: "line",
        editor: this.props.editor,
        className: "github-editorCommentHighlight",
        omitEmptyLastRow: false
      })), _react["default"].createElement(_commentGutterDecorationController["default"], {
        commentRow: range.start.row,
        threadId: thread.threadID,
        editor: this.props.editor,
        workspace: this.props.workspace,
        endpoint: this.props.endpoint,
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        workdir: this.props.workdir,
        parent: this.constructor.name
      }));
    });
  }

  markerDidChange(rootCommentID, {
    newRange
  }) {
    this.rangesByRootID.set(rootCommentID, _atom.Range.fromObject(newRange));
  }

  getRangeForThread(thread) {
    const translations = this.props.commentTranslationsForPath;

    if (thread.position === null) {
      this.rangesByRootID["delete"](thread.rootCommentID);
      return null;
    }

    let adjustedPosition = translations.diffToFilePosition.get(thread.position);

    if (!adjustedPosition) {
      this.rangesByRootID["delete"](thread.rootCommentID);
      return null;
    }

    if (translations.fileTranslations) {
      adjustedPosition = translations.fileTranslations.get(adjustedPosition).newPosition;

      if (!adjustedPosition) {
        this.rangesByRootID["delete"](thread.rootCommentID);
        return null;
      }
    }

    const editorRow = adjustedPosition - 1;
    let localRange = this.rangesByRootID.get(thread.rootCommentID);

    if (!localRange) {
      localRange = _atom.Range.fromObject([[editorRow, 0], [editorRow, Infinity]]);
      this.rangesByRootID.set(thread.rootCommentID, localRange);
    }

    return localRange;
  }

}

exports["default"] = EditorCommentDecorationsController;

_defineProperty(EditorCommentDecorationsController, "propTypes", {
  endpoint: _propTypes2.EndpointPropType.isRequired,
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  workspace: _propTypes["default"].object.isRequired,
  editor: _propTypes["default"].object.isRequired,
  threadsForPath: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    rootCommentID: _propTypes["default"].string.isRequired,
    position: _propTypes["default"].number,
    threadID: _propTypes["default"].string.isRequired
  })).isRequired,
  commentTranslationsForPath: _propTypes["default"].shape({
    diffToFilePosition: _propTypes["default"].shape({
      get: _propTypes["default"].func.isRequired
    }).isRequired,
    fileTranslations: _propTypes["default"].shape({
      get: _propTypes["default"].func.isRequired
    }),
    digest: _propTypes["default"].string
  })
});

function translationDigestFrom(props) {
  const translations = props.commentTranslationsForPath;
  return translations ? translations.digest : null;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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