"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _reactRelay = require("react-relay");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _keytarStrategy = require("../shared/keytar-strategy");

var _prPatchContainer = _interopRequireDefault(require("./pr-patch-container"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _githubLoginView = _interopRequireDefault(require("../views/github-login-view"));

var _errorView = _interopRequireDefault(require("../views/error-view"));

var _queryErrorView = _interopRequireDefault(require("../views/query-error-view"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _relayEnvironment = _interopRequireDefault(require("../views/relay-environment"));

var _reviewsController = _interopRequireDefault(require("../controllers/reviews-controller"));

var _aggregatedReviewsContainer = _interopRequireDefault(require("./aggregated-reviews-container"));

var _commentPositioningContainer = _interopRequireDefault(require("./comment-positioning-container"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReviewsContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderWithToken", token => {
      if (!token) {
        return _react["default"].createElement(_loadingView["default"], null);
      }

      if (token === _keytarStrategy.UNAUTHENTICATED) {
        return _react["default"].createElement(_githubLoginView["default"], {
          onLogin: this.handleLogin
        });
      }

      if (token === _keytarStrategy.INSUFFICIENT) {
        return _react["default"].createElement(_githubLoginView["default"], {
          onLogin: this.handleLogin
        }, _react["default"].createElement("p", null, "Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one."));
      }

      return _react["default"].createElement(_prPatchContainer["default"], {
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        endpoint: this.props.endpoint,
        token: token
      }, (error, patch) => this.renderWithPatch(error, {
        token,
        patch
      }));
    });

    _defineProperty(this, "fetchToken", loginModel => loginModel.getToken(this.props.endpoint.getLoginAccount()));

    _defineProperty(this, "fetchRepositoryData", repository => {
      return (0, _yubikiri["default"])({
        branches: repository.getBranches(),
        remotes: repository.getRemotes(),
        isAbsent: repository.isAbsent(),
        isLoading: repository.isLoading(),
        isPresent: repository.isPresent(),
        isMerging: repository.isMerging(),
        isRebasing: repository.isRebasing()
      });
    });

    _defineProperty(this, "handleLogin", token => this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token));

    _defineProperty(this, "handleLogout", () => this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount()));
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.loginModel,
      fetchData: this.fetchToken
    }, this.renderWithToken);
  }

  renderWithPatch(error, {
    token,
    patch
  }) {
    if (error) {
      return _react["default"].createElement(_errorView["default"], {
        descriptions: [error]
      });
    }

    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.repository,
      fetchData: this.fetchRepositoryData
    }, repoData => this.renderWithRepositoryData(repoData, {
      token,
      patch
    }));
  }

  renderWithRepositoryData(repoData, {
    token,
    patch
  }) {
    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/reviewsContainerQuery.graphql");

      if (node.hash && node.hash !== "b05cc30cb078003afba9bd8c2de989fa") {
        console.error("The definition of 'reviewsContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/reviewsContainerQuery.graphql");
    });

    const variables = {
      repoOwner: this.props.owner,
      repoName: this.props.repo,
      prNumber: this.props.number,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      threadCount: _helpers.PAGE_SIZE,
      threadCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null
    };
    return _react["default"].createElement(_relayEnvironment["default"].Provider, {
      value: environment
    }, _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      query: query,
      variables: variables,
      render: queryResult => this.renderWithQuery(queryResult, {
        repoData,
        patch
      })
    }));
  }

  renderWithQuery({
    error,
    props,
    retry
  }, {
    repoData,
    patch
  }) {
    if (error) {
      return _react["default"].createElement(_queryErrorView["default"], {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (!props || !repoData || !patch) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    return _react["default"].createElement(_aggregatedReviewsContainer["default"], {
      pullRequest: props.repository.pullRequest
    }, ({
      errors,
      summaries,
      commentThreads,
      refetch
    }) => {
      if (errors && errors.length > 0) {
        return errors.map((err, i) => _react["default"].createElement(_errorView["default"], {
          key: `error-${i}`,
          title: "Pagination error",
          descriptions: [err.stack || err.toString()]
        }));
      }

      const aggregationResult = {
        summaries,
        commentThreads,
        refetch
      };
      return this.renderWithResult({
        aggregationResult,
        queryProps: props,
        repoData,
        patch,
        refetch
      });
    });
  }

  renderWithResult({
    aggregationResult,
    queryProps,
    repoData,
    patch
  }) {
    return _react["default"].createElement(_commentPositioningContainer["default"], _extends({
      multiFilePatch: patch
    }, aggregationResult, {
      prCommitSha: queryProps.repository.pullRequest.headRefOid,
      localRepository: this.props.repository
    }), commentTranslations => {
      return _react["default"].createElement(_reviewsController["default"], _extends({}, this.props, aggregationResult, {
        commentTranslations: commentTranslations,
        localRepository: this.props.repository,
        multiFilePatch: patch,
        repository: queryProps.repository,
        pullRequest: queryProps.repository.pullRequest,
        viewer: queryProps.viewer
      }, repoData));
    });
  }

}

exports["default"] = ReviewsContainer;

_defineProperty(ReviewsContainer, "propTypes", {
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // Pull request selection criteria
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  // Package models
  repository: _propTypes["default"].object.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  initThreadID: _propTypes["default"].string,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  // Action methods
  reportMutationErrors: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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