"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _whatTheDiff = require("what-the-diff");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _patch = require("../models/patch");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PullRequestPatchContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      multiFilePatch: null,
      error: null
    });
  }

  componentDidMount() {
    this.mounted = true;
    this.fetchDiff();
  }

  componentDidUpdate(prevProps) {
    if (this.props.refetch && !prevProps.refetch) {
      this.setState({
        multiFilePatch: null,
        error: null
      });
      this.fetchDiff();
    }
  }

  componentWillUnmount() {
    this.mounted = false;
  }

  render() {
    return this.props.children(this.state.error, this.state.multiFilePatch);
  } // Generate a v3 GitHub API REST URL for the pull request resource.
  // Example: https://api.github.com/repos/atom/github/pulls/1829


  getDiffURL() {
    return this.props.endpoint.getRestURI('repos', this.props.owner, this.props.repo, 'pulls', this.props.number);
  }

  buildPatch(rawDiff) {
    const diffs = (0, _whatTheDiff.parse)(rawDiff).map(diff => {
      // diff coming from API will have the defaul git diff prefixes a/ and b/ and use *nix-style / path separators.
      // e.g. a/dir/file1.js and b/dir/file2.js
      // see https://git-scm.com/docs/git-diff#_generating_patches_with_p
      return _objectSpread({}, diff, {
        newPath: diff.newPath ? (0, _helpers.toNativePathSep)(diff.newPath.replace(/^[a|b]\//, '')) : diff.newPath,
        oldPath: diff.oldPath ? (0, _helpers.toNativePathSep)(diff.oldPath.replace(/^[a|b]\//, '')) : diff.oldPath
      });
    });
    return (0, _patch.buildMultiFilePatch)(diffs, {
      preserveOriginal: true
    });
  }

  async fetchDiff() {
    const url = this.getDiffURL();
    let response;

    try {
      response = await fetch(url, {
        headers: {
          Accept: 'application/vnd.github.v3.diff',
          Authorization: `bearer ${this.props.token}`
        }
      });
    } catch (err) {
      return this.reportDiffError(`Network error encountered fetching the patch: ${err.message}.`, err);
    }

    if (!response.ok) {
      return this.reportDiffError(`Unable to fetch the diff for this pull request: ${response.statusText}.`);
    }

    try {
      const rawDiff = await response.text();

      if (!this.mounted) {
        return null;
      }

      const multiFilePatch = this.buildPatch(rawDiff);
      return new Promise(resolve => this.setState({
        multiFilePatch
      }, resolve));
    } catch (err) {
      return this.reportDiffError('Unable to parse the diff for this pull request.', err);
    }
  }

  reportDiffError(message, error) {
    return new Promise(resolve => {
      if (error) {
        // eslint-disable-next-line no-console
        console.error(error);
      }

      if (!this.mounted) {
        resolve();
        return;
      }

      this.setState({
        error: message
      }, resolve);
    });
  }

}

exports["default"] = PullRequestPatchContainer;

_defineProperty(PullRequestPatchContainer, "propTypes", {
  // Pull request properties
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  // Connection properties
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Refetch diff on next component update
  refetch: _propTypes["default"].bool,
  // Render prop. Called with (error or null, multiFilePatch or null)
  children: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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