"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _issueishListController = _interopRequireWildcard(require("../controllers/issueish-list-controller"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _graphql;

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class IssueishSearchContainer extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult');
    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, this.props.token);

    if (this.props.search.isNull()) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false
      }, this.controllerProps()));
    }

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/issueishSearchContainerQuery.graphql");

      if (node.hash && node.hash !== "fc553ba742c51417ea1a857b96038345") {
        console.error("The definition of 'issueishSearchContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/issueishSearchContainerQuery.graphql");
    });

    const variables = {
      query: this.props.search.createQuery(),
      first: this.props.limit
    };
    return _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderQueryResult({
    error,
    props,
    retry
  }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react["default"].createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    return _react["default"].createElement(_issueishListController["default"], _extends({
      total: props.search.issueCount,
      results: props.search.nodes,
      isLoading: false
    }, this.controllerProps()));
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: this.props.search.getName(),
      onOpenIssueish: this.props.onOpenIssueish,
      onOpenReviews: this.props.onOpenReviews,
      onOpenMore: () => this.props.onOpenSearch(this.props.search)
    };
  }

}

exports["default"] = IssueishSearchContainer;

_defineProperty(IssueishSearchContainer, "propTypes", {
  // Connection information
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Search model
  limit: _propTypes["default"].number,
  search: _propTypes2.SearchPropType.isRequired,
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  // Action methods
  onOpenIssueish: _propTypes["default"].func.isRequired,
  onOpenSearch: _propTypes["default"].func.isRequired,
  onOpenReviews: _propTypes["default"].func.isRequired
});

_defineProperty(IssueishSearchContainer, "defaultProps", {
  limit: 20
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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