"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareAggregatedReviewsContainer = void 0;

var _react = _interopRequireDefault(require("react"));

var _eventKit = require("event-kit");

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

var _reviewSummariesAccumulator = _interopRequireDefault(require("./accumulators/review-summaries-accumulator"));

var _reviewThreadsAccumulator = _interopRequireDefault(require("./accumulators/review-threads-accumulator"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareAggregatedReviewsContainer extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "refetch", callback => this.props.relay.refetch({
      prId: this.props.pullRequest.id,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      threadCount: _helpers.PAGE_SIZE,
      threadCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null
    }, null, () => {
      this.emitter.emit('did-refetch');
      callback();
    }, {
      force: true
    }));

    _defineProperty(this, "onDidRefetch", callback => this.emitter.on('did-refetch', callback));

    this.emitter = new _eventKit.Emitter();
  }

  render() {
    return _react["default"].createElement(_reviewSummariesAccumulator["default"], {
      onDidRefetch: this.onDidRefetch,
      pullRequest: this.props.pullRequest
    }, ({
      error: summaryError,
      summaries,
      loading: summariesLoading
    }) => {
      return _react["default"].createElement(_reviewThreadsAccumulator["default"], {
        onDidRefetch: this.onDidRefetch,
        pullRequest: this.props.pullRequest
      }, payload => {
        const result = {
          errors: [],
          refetch: this.refetch,
          summaries,
          commentThreads: payload.commentThreads,
          loading: payload.loading || summariesLoading
        };

        if (summaryError) {
          result.errors.push(summaryError);
        }

        result.errors.push(...payload.errors);
        return this.props.children(result);
      });
    });
  }

}

exports.BareAggregatedReviewsContainer = BareAggregatedReviewsContainer;

_defineProperty(BareAggregatedReviewsContainer, "propTypes", {
  // Relay response
  relay: _propTypes["default"].shape({
    refetch: _propTypes["default"].func.isRequired
  }),
  // Relay results.
  pullRequest: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  // Render prop. Called with {errors, summaries, commentThreads, loading}.
  children: _propTypes["default"].func.isRequired,
  // only fetch summaries when we specify a summariesRenderer
  summariesRenderer: _propTypes["default"].func
});

var _default = (0, _reactRelay.createRefetchContainer)(BareAggregatedReviewsContainer, {
  pullRequest: function () {
    const node = require("./__generated__/aggregatedReviewsContainer_pullRequest.graphql");

    if (node.hash && node.hash !== "830225d5b83d6c320e16cf824fe0cca6") {
      console.error("The definition of 'aggregatedReviewsContainer_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/aggregatedReviewsContainer_pullRequest.graphql");
  }
}, function () {
  const node = require("./__generated__/aggregatedReviewsContainerRefetchQuery.graphql");

  if (node.hash && node.hash !== "2bf1bb4fa69d264bcecbe81f41621908") {
    console.error("The definition of 'aggregatedReviewsContainerRefetchQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/aggregatedReviewsContainerRefetchQuery.graphql");
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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