"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareReviewCommentsAccumulator = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _helpers = require("../../helpers");

var _propTypes2 = require("../../prop-types");

var _accumulator = _interopRequireDefault(require("./accumulator"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareReviewCommentsAccumulator extends _react["default"].Component {
  render() {
    const resultBatch = this.props.reviewThread.comments.edges.map(edge => edge.node);
    return _react["default"].createElement(_accumulator["default"], {
      relay: this.props.relay,
      resultBatch: resultBatch,
      onDidRefetch: this.props.onDidRefetch,
      pageSize: _helpers.PAGE_SIZE,
      waitTimeMs: _helpers.PAGINATION_WAIT_TIME_MS
    }, (error, comments, loading) => this.props.children({
      error,
      comments,
      loading
    }));
  }

}

exports.BareReviewCommentsAccumulator = BareReviewCommentsAccumulator;

_defineProperty(BareReviewCommentsAccumulator, "propTypes", {
  // Relay props
  relay: _propTypes["default"].shape({
    hasMore: _propTypes["default"].func.isRequired,
    loadMore: _propTypes["default"].func.isRequired,
    isLoading: _propTypes["default"].func.isRequired
  }).isRequired,
  reviewThread: _propTypes["default"].shape({
    comments: (0, _propTypes2.RelayConnectionPropType)(_propTypes["default"].object)
  }),
  // Render prop. Called with (error or null, array of all review comments, loading)
  children: _propTypes["default"].func,
  // Called right after refetch happens
  onDidRefetch: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createPaginationContainer)(BareReviewCommentsAccumulator, {
  reviewThread: function () {
    const node = require("./__generated__/reviewCommentsAccumulator_reviewThread.graphql");

    if (node.hash && node.hash !== "6a1d075c882842171dfeaf52d4241b35") {
      console.error("The definition of 'reviewCommentsAccumulator_reviewThread' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewCommentsAccumulator_reviewThread.graphql");
  }
}, {
  direction: 'forward',

  /* istanbul ignore next */
  getConnectionFromProps(props) {
    return props.reviewThread.comments;
  },

  /* istanbul ignore next */
  getFragmentVariables(prevVars, totalCount) {
    return _objectSpread({}, prevVars, {
      totalCount
    });
  },

  /* istanbul ignore next */
  getVariables(props, {
    count,
    cursor
  }) {
    return {
      id: props.reviewThread.id,
      commentCount: count,
      commentCursor: cursor
    };
  },

  query: function () {
    const node = require("./__generated__/reviewCommentsAccumulatorQuery.graphql");

    if (node.hash && node.hash !== "25bc4376239d278025fc1f353900572a") {
      console.error("The definition of 'reviewCommentsAccumulatorQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewCommentsAccumulatorQuery.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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