(function() {
  var CompositeDisposable, DeprecationCopStatusBarView, Disposable, Grim, _, ref,
    bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  ref = require('atom'), CompositeDisposable = ref.CompositeDisposable, Disposable = ref.Disposable;

  _ = require('underscore-plus');

  Grim = require('grim');

  module.exports = DeprecationCopStatusBarView = (function() {
    DeprecationCopStatusBarView.prototype.lastLength = null;

    DeprecationCopStatusBarView.prototype.toolTipDisposable = null;

    function DeprecationCopStatusBarView() {
      this.update = bind(this.update, this);
      var clickHandler, debouncedUpdateDeprecatedSelectorCount;
      this.subscriptions = new CompositeDisposable;
      this.element = document.createElement('div');
      this.element.classList.add('deprecation-cop-status', 'inline-block', 'text-warning');
      this.element.setAttribute('tabindex', -1);
      this.icon = document.createElement('span');
      this.icon.classList.add('icon', 'icon-alert');
      this.element.appendChild(this.icon);
      this.deprecationNumber = document.createElement('span');
      this.deprecationNumber.classList.add('deprecation-number');
      this.deprecationNumber.textContent = '0';
      this.element.appendChild(this.deprecationNumber);
      clickHandler = function() {
        var workspaceElement;
        workspaceElement = atom.views.getView(atom.workspace);
        return atom.commands.dispatch(workspaceElement, 'deprecation-cop:view');
      };
      this.element.addEventListener('click', clickHandler);
      this.subscriptions.add(new Disposable((function(_this) {
        return function() {
          return _this.element.removeEventListener('click', clickHandler);
        };
      })(this)));
      this.update();
      debouncedUpdateDeprecatedSelectorCount = _.debounce(this.update, 1000);
      this.subscriptions.add(Grim.on('updated', this.update));
      if (atom.styles.onDidUpdateDeprecations != null) {
        this.subscriptions.add(atom.styles.onDidUpdateDeprecations(debouncedUpdateDeprecatedSelectorCount));
      }
    }

    DeprecationCopStatusBarView.prototype.destroy = function() {
      this.subscriptions.dispose();
      return this.element.remove();
    };

    DeprecationCopStatusBarView.prototype.getDeprecatedCallCount = function() {
      return Grim.getDeprecations().map(function(d) {
        return d.getStackCount();
      }).reduce((function(a, b) {
        return a + b;
      }), 0);
    };

    DeprecationCopStatusBarView.prototype.getDeprecatedStyleSheetsCount = function() {
      if (atom.styles.getDeprecations != null) {
        return Object.keys(atom.styles.getDeprecations()).length;
      } else {
        return 0;
      }
    };

    DeprecationCopStatusBarView.prototype.update = function() {
      var length, ref1;
      length = this.getDeprecatedCallCount() + this.getDeprecatedStyleSheetsCount();
      if (this.lastLength === length) {
        return;
      }
      this.lastLength = length;
      this.deprecationNumber.textContent = "" + (_.pluralize(length, 'deprecation'));
      if ((ref1 = this.toolTipDisposable) != null) {
        ref1.dispose();
      }
      this.toolTipDisposable = atom.tooltips.add(this.element, {
        title: (_.pluralize(length, 'call')) + " to deprecated methods"
      });
      if (length === 0) {
        return this.element.style.display = 'none';
      } else {
        return this.element.style.display = '';
      }
    };

    return DeprecationCopStatusBarView;

  })();

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
