function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var assert = require('assert');
var fs = require('fs');
var sinon = require('sinon');
var path = require('path');

var dalek = require('../lib/dalek');

describe('dalek', function () {
  describe('enumerate', function () {
    var availablePackages = {};
    var realPaths = {};
    var bundledPackages = [];
    var packageDirPaths = [];
    var sandbox = null;

    beforeEach(function () {
      availablePackages = {
        'an-unduplicated-installed-package': path.join('Users', 'username', '.atom', 'packages', 'an-unduplicated-installed-package'),
        'duplicated-package': path.join('Users', 'username', '.atom', 'packages', 'duplicated-package'),
        'unduplicated-package': path.join('' + atom.getLoadSettings().resourcePath, 'node_modules', 'unduplicated-package')
      };

      atom.devMode = false;
      bundledPackages = ['duplicated-package', 'unduplicated-package'];
      packageDirPaths = [path.join('Users', 'username', '.atom', 'packages')];
      sandbox = sinon.sandbox.create();
      sandbox.stub(dalek, 'realpath').callsFake(function (filePath) {
        return Promise.resolve(realPaths[filePath] || filePath);
      });
      sandbox.stub(atom.packages, 'isBundledPackage').callsFake(function (packageName) {
        return bundledPackages.includes(packageName);
      });
      sandbox.stub(atom.packages, 'getAvailablePackageNames').callsFake(function () {
        return Object.keys(availablePackages);
      });
      sandbox.stub(atom.packages, 'getPackageDirPaths').callsFake(function () {
        return packageDirPaths;
      });
      sandbox.stub(fs, 'existsSync').callsFake(function (candidate) {
        return Object.values(availablePackages).includes(candidate) && !candidate.includes(atom.getLoadSettings().resourcePath);
      });
    });

    afterEach(function () {
      sandbox.restore();
    });

    it('returns a list of duplicate names', _asyncToGenerator(function* () {
      assert.deepEqual((yield dalek.enumerate()), ['duplicated-package']);
    }));

    describe('when in dev mode', function () {
      beforeEach(function () {
        atom.devMode = true;
      });

      it('always returns an empty list', _asyncToGenerator(function* () {
        assert.deepEqual((yield dalek.enumerate()), []);
      }));
    });

    describe('when a package is symlinked into the package directory', _asyncToGenerator(function* () {
      beforeEach(function () {
        var realPath = path.join('Users', 'username', 'duplicated-package');
        var packagePath = path.join('Users', 'username', '.atom', 'packages', 'duplicated-package');
        realPaths[packagePath] = realPath;
      });

      it('is not included in the list of duplicate names', _asyncToGenerator(function* () {
        assert.deepEqual((yield dalek.enumerate()), []);
      }));
    }));
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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