function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var fs = require('fs');
var path = require('path');

module.exports = {
  enumerate: _asyncToGenerator(function* () {
    if (atom.inDevMode()) {
      return [];
    }

    var duplicatePackages = [];
    var names = atom.packages.getAvailablePackageNames();
    for (var _name of names) {
      if (atom.packages.isBundledPackage(_name)) {
        var isDuplicatedPackage = yield this.isInstalledAsCommunityPackage(_name);
        if (isDuplicatedPackage) {
          duplicatePackages.push(_name);
        }
      }
    }

    return duplicatePackages;
  }),

  isInstalledAsCommunityPackage: _asyncToGenerator(function* (name) {
    var availablePackagePaths = atom.packages.getPackageDirPaths();

    for (var packagePath of availablePackagePaths) {
      var candidate = path.join(packagePath, name);

      if (fs.existsSync(candidate)) {
        var realPath = yield this.realpath(candidate);
        if (realPath === candidate) {
          return true;
        }
      }
    }

    return false;
  }),

  realpath: function realpath(path) {
    return new Promise(function (resolve, reject) {
      fs.realpath(path, function (error, realpath) {
        if (error) {
          reject(error);
        } else {
          resolve(realpath);
        }
      });
    });
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzguMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9kYWxlay9saWIvZGFsZWsuanMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7OztBQUVBLElBQU0sRUFBRSxHQUFHLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQTtBQUN4QixJQUFNLElBQUksR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLENBQUE7O0FBRTVCLE1BQU0sQ0FBQyxPQUFPLEdBQUc7QUFDZixBQUFNLFdBQVMsb0JBQUMsYUFBRztBQUNqQixRQUFJLElBQUksQ0FBQyxTQUFTLEVBQUUsRUFBRTtBQUNwQixhQUFPLEVBQUUsQ0FBQTtLQUNWOztBQUVELFFBQU0saUJBQWlCLEdBQUcsRUFBRSxDQUFBO0FBQzVCLFFBQU0sS0FBSyxHQUFHLElBQUksQ0FBQyxRQUFRLENBQUMsd0JBQXdCLEVBQUUsQ0FBQTtBQUN0RCxTQUFLLElBQUksS0FBSSxJQUFJLEtBQUssRUFBRTtBQUN0QixVQUFJLElBQUksQ0FBQyxRQUFRLENBQUMsZ0JBQWdCLENBQUMsS0FBSSxDQUFDLEVBQUU7QUFDeEMsWUFBTSxtQkFBbUIsR0FBRyxNQUFNLElBQUksQ0FBQyw2QkFBNkIsQ0FDbEUsS0FBSSxDQUNMLENBQUE7QUFDRCxZQUFJLG1CQUFtQixFQUFFO0FBQ3ZCLDJCQUFpQixDQUFDLElBQUksQ0FBQyxLQUFJLENBQUMsQ0FBQTtTQUM3QjtPQUNGO0tBQ0Y7O0FBRUQsV0FBTyxpQkFBaUIsQ0FBQTtHQUN6QixDQUFBOztBQUVELEFBQU0sK0JBQTZCLG9CQUFDLFdBQUMsSUFBSSxFQUFFO0FBQ3pDLFFBQU0scUJBQXFCLEdBQUcsSUFBSSxDQUFDLFFBQVEsQ0FBQyxrQkFBa0IsRUFBRSxDQUFBOztBQUVoRSxTQUFLLElBQUksV0FBVyxJQUFJLHFCQUFxQixFQUFFO0FBQzdDLFVBQU0sU0FBUyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLElBQUksQ0FBQyxDQUFBOztBQUU5QyxVQUFJLEVBQUUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLEVBQUU7QUFDNUIsWUFBTSxRQUFRLEdBQUcsTUFBTSxJQUFJLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxDQUFBO0FBQy9DLFlBQUksUUFBUSxLQUFLLFNBQVMsRUFBRTtBQUMxQixpQkFBTyxJQUFJLENBQUE7U0FDWjtPQUNGO0tBQ0Y7O0FBRUQsV0FBTyxLQUFLLENBQUE7R0FDYixDQUFBOztBQUVELFVBQVEsRUFBQyxrQkFBQyxJQUFJLEVBQUU7QUFDZCxXQUFPLElBQUksT0FBTyxDQUFDLFVBQUMsT0FBTyxFQUFFLE1BQU0sRUFBSztBQUN0QyxRQUFFLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxVQUFVLEtBQUssRUFBRSxRQUFRLEVBQUU7QUFDM0MsWUFBSSxLQUFLLEVBQUU7QUFDVCxnQkFBTSxDQUFDLEtBQUssQ0FBQyxDQUFBO1NBQ2QsTUFBTTtBQUNMLGlCQUFPLENBQUMsUUFBUSxDQUFDLENBQUE7U0FDbEI7T0FDRixDQUFDLENBQUE7S0FDSCxDQUFDLENBQUE7R0FDSDtDQUNGLENBQUEiLCJmaWxlIjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zOC4xL291dC9hcHAvbm9kZV9tb2R1bGVzL2RhbGVrL2xpYi9kYWxlay5qcyIsInNvdXJjZXNDb250ZW50IjpbIi8qKiBAYmFiZWwgKi9cblxuY29uc3QgZnMgPSByZXF1aXJlKCdmcycpXG5jb25zdCBwYXRoID0gcmVxdWlyZSgncGF0aCcpXG5cbm1vZHVsZS5leHBvcnRzID0ge1xuICBhc3luYyBlbnVtZXJhdGUgKCkge1xuICAgIGlmIChhdG9tLmluRGV2TW9kZSgpKSB7XG4gICAgICByZXR1cm4gW11cbiAgICB9XG5cbiAgICBjb25zdCBkdXBsaWNhdGVQYWNrYWdlcyA9IFtdXG4gICAgY29uc3QgbmFtZXMgPSBhdG9tLnBhY2thZ2VzLmdldEF2YWlsYWJsZVBhY2thZ2VOYW1lcygpXG4gICAgZm9yIChsZXQgbmFtZSBvZiBuYW1lcykge1xuICAgICAgaWYgKGF0b20ucGFja2FnZXMuaXNCdW5kbGVkUGFja2FnZShuYW1lKSkge1xuICAgICAgICBjb25zdCBpc0R1cGxpY2F0ZWRQYWNrYWdlID0gYXdhaXQgdGhpcy5pc0luc3RhbGxlZEFzQ29tbXVuaXR5UGFja2FnZShcbiAgICAgICAgICBuYW1lXG4gICAgICAgIClcbiAgICAgICAgaWYgKGlzRHVwbGljYXRlZFBhY2thZ2UpIHtcbiAgICAgICAgICBkdXBsaWNhdGVQYWNrYWdlcy5wdXNoKG5hbWUpXG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG5cbiAgICByZXR1cm4gZHVwbGljYXRlUGFja2FnZXNcbiAgfSxcblxuICBhc3luYyBpc0luc3RhbGxlZEFzQ29tbXVuaXR5UGFja2FnZSAobmFtZSkge1xuICAgIGNvbnN0IGF2YWlsYWJsZVBhY2thZ2VQYXRocyA9IGF0b20ucGFja2FnZXMuZ2V0UGFja2FnZURpclBhdGhzKClcblxuICAgIGZvciAobGV0IHBhY2thZ2VQYXRoIG9mIGF2YWlsYWJsZVBhY2thZ2VQYXRocykge1xuICAgICAgY29uc3QgY2FuZGlkYXRlID0gcGF0aC5qb2luKHBhY2thZ2VQYXRoLCBuYW1lKVxuXG4gICAgICBpZiAoZnMuZXhpc3RzU3luYyhjYW5kaWRhdGUpKSB7XG4gICAgICAgIGNvbnN0IHJlYWxQYXRoID0gYXdhaXQgdGhpcy5yZWFscGF0aChjYW5kaWRhdGUpXG4gICAgICAgIGlmIChyZWFsUGF0aCA9PT0gY2FuZGlkYXRlKSB7XG4gICAgICAgICAgcmV0dXJuIHRydWVcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cblxuICAgIHJldHVybiBmYWxzZVxuICB9LFxuXG4gIHJlYWxwYXRoIChwYXRoKSB7XG4gICAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlLCByZWplY3QpID0+IHtcbiAgICAgIGZzLnJlYWxwYXRoKHBhdGgsIGZ1bmN0aW9uIChlcnJvciwgcmVhbHBhdGgpIHtcbiAgICAgICAgaWYgKGVycm9yKSB7XG4gICAgICAgICAgcmVqZWN0KGVycm9yKVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgIHJlc29sdmUocmVhbHBhdGgpXG4gICAgICAgIH1cbiAgICAgIH0pXG4gICAgfSlcbiAgfVxufVxuIl19