Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _fileView = require('./file-view');

var _fileView2 = _interopRequireDefault(_fileView);

var _getIconServices = require('./get-icon-services');

var _getIconServices2 = _interopRequireDefault(_getIconServices);

var DirectoryView = (function () {
  function DirectoryView(parentView, indexInParentView, archivePath, entry) {
    _classCallCheck(this, DirectoryView);

    this.entries = [];
    this.parentView = parentView;
    this.indexInParentView = indexInParentView;
    this.element = document.createElement('li');
    this.element.classList.add('list-nested-item', 'entry');

    var listItem = document.createElement('span');
    listItem.classList.add('list-item');

    var entrySpan = document.createElement('span');
    entrySpan.textContent = entry.getName();
    listItem.appendChild(entrySpan);
    this.element.appendChild(listItem);

    this.entry = entry;
    this.entrySpan = entrySpan;
    (0, _getIconServices2['default'])().updateDirectoryIcon(this);

    this.entriesTree = document.createElement('ol');
    this.entriesTree.classList.add('list-tree');
    var index = 0;
    for (var child of entry.children) {
      if (child.isDirectory()) {
        var entryView = new DirectoryView(this, index, archivePath, child);
        this.entries.push(entryView);
        this.entriesTree.appendChild(entryView.element);
      } else {
        var entryView = new _fileView2['default'](this, index, archivePath, child);
        this.entries.push(entryView);
        this.entriesTree.appendChild(entryView.element);
      }

      index++;
    }
    this.element.appendChild(this.entriesTree);
  }

  _createClass(DirectoryView, [{
    key: 'destroy',
    value: function destroy() {
      if (this.iconDisposable) {
        this.iconDisposable.dispose();
        this.iconDisposable = null;
      }

      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }

      this.element.remove();
    }
  }, {
    key: 'selectFileBeforeIndex',
    value: function selectFileBeforeIndex(index) {
      for (var i = index - 1; i >= 0; i--) {
        var previousEntry = this.entries[i];
        if (previousEntry instanceof _fileView2['default']) {
          previousEntry.select();
          return;
        } else {
          if (previousEntry.selectLastFile()) {
            return;
          }
        }
      }

      this.parentView.selectFileBeforeIndex(this.indexInParentView);
    }
  }, {
    key: 'selectFileAfterIndex',
    value: function selectFileAfterIndex(index) {
      for (var i = index + 1; i < this.entries.length; i++) {
        var nextEntry = this.entries[i];
        if (nextEntry instanceof _fileView2['default']) {
          nextEntry.select();
          return;
        } else {
          if (nextEntry.selectFirstFile()) {
            return;
          }
        }
      }

      this.parentView.selectFileAfterIndex(this.indexInParentView);
    }
  }, {
    key: 'selectFirstFile',
    value: function selectFirstFile() {
      for (var entry of this.entries) {
        if (entry instanceof _fileView2['default']) {
          entry.select();
          return true;
        } else {
          if (entry.selectFirstFile()) {
            return true;
          }
        }
      }

      return false;
    }
  }, {
    key: 'selectLastFile',
    value: function selectLastFile() {
      for (var i = this.entries.length - 1; i >= 0; i--) {
        var entry = this.entries[i];
        if (entry instanceof _fileView2['default']) {
          entry.select();
          return true;
        } else {
          if (entry.selectLastFile()) {
            return true;
          }
        }
      }

      return false;
    }
  }]);

  return DirectoryView;
})();

exports['default'] = DirectoryView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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