/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.ext.awt.geom;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class RectListManager
implements Collection {
    Rectangle[] rects = null;
    int size = 0;
    Rectangle bounds = null;
    public static Comparator comparator = new RectXComparator();

    public void dump() {
        System.err.println("RLM: " + this + " Sz: " + this.size);
        System.err.println("Bounds: " + this.getBounds());
        for (int i = 0; i < this.size; ++i) {
            Rectangle rectangle = this.rects[i];
            System.err.println("  [" + rectangle.x + ", " + rectangle.y + ", " + rectangle.width + ", " + rectangle.height + ']');
        }
    }

    public RectListManager(Collection collection) {
        this.rects = new Rectangle[collection.size()];
        Iterator iterator = collection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.rects[n++] = (Rectangle)iterator.next();
        }
        this.size = this.rects.length;
        Arrays.sort(this.rects, comparator);
    }

    public RectListManager(Rectangle[] rectangleArray) {
        this(rectangleArray, 0, rectangleArray.length);
    }

    public RectListManager(Rectangle[] rectangleArray, int n, int n2) {
        this.size = n2;
        this.rects = new Rectangle[n2];
        System.arraycopy(rectangleArray, n, this.rects, 0, n2);
        Arrays.sort(this.rects, comparator);
    }

    public RectListManager(RectListManager rectListManager) {
        this(rectListManager.rects);
    }

    public RectListManager(Rectangle rectangle) {
        this();
        this.add(rectangle);
    }

    public RectListManager() {
        this.rects = new Rectangle[10];
        this.size = 0;
    }

    public RectListManager(int n) {
        this.rects = new Rectangle[n];
    }

    public Rectangle getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        if (this.size == 0) {
            return null;
        }
        this.bounds = new Rectangle(this.rects[0]);
        for (int i = 1; i < this.size; ++i) {
            Rectangle rectangle = this.rects[i];
            if (rectangle.x < this.bounds.x) {
                this.bounds.width = this.bounds.x + this.bounds.width - rectangle.x;
                this.bounds.x = rectangle.x;
            }
            if (rectangle.y < this.bounds.y) {
                this.bounds.height = this.bounds.y + this.bounds.height - rectangle.y;
                this.bounds.y = rectangle.y;
            }
            if (rectangle.x + rectangle.width > this.bounds.x + this.bounds.width) {
                this.bounds.width = rectangle.x + rectangle.width - this.bounds.x;
            }
            if (rectangle.y + rectangle.height <= this.bounds.y + this.bounds.height) continue;
            this.bounds.height = rectangle.y + rectangle.height - this.bounds.y;
        }
        return this.bounds;
    }

    public Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public RectListManager copy() {
        return new RectListManager(this.rects);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.rects, null);
        this.size = 0;
        this.bounds = null;
    }

    @Override
    public Iterator iterator() {
        return new RLMIterator();
    }

    public ListIterator listIterator() {
        return new RLMIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Rectangle[this.size];
        System.arraycopy(this.rects, 0, objectArray, 0, this.size);
        return objectArray;
    }

    public Object[] toArray(Object[] objectArray) {
        Class<?> clazz = objectArray.getClass().getComponentType();
        if (clazz != Object.class && clazz != Rectangle.class) {
            Arrays.fill(objectArray, null);
            return objectArray;
        }
        if (objectArray.length < this.size) {
            objectArray = new Rectangle[this.size];
        }
        System.arraycopy(this.rects, 0, objectArray, 0, this.size);
        Arrays.fill(objectArray, this.size, objectArray.length, null);
        return objectArray;
    }

    public boolean add(Object object) {
        this.add((Rectangle)object);
        return true;
    }

    public void add(Rectangle rectangle) {
        this.add(rectangle, 0, this.size - 1);
    }

    protected void add(Rectangle rectangle, int n, int n2) {
        this.ensureCapacity(this.size + 1);
        int n3 = n;
        while (n <= n2) {
            for (n3 = (n + n2) / 2; this.rects[n3] == null && n3 < n2; ++n3) {
            }
            if (this.rects[n3] == null) {
                n2 = (n + n2) / 2;
                n3 = (n + n2) / 2;
                if (n > n2) {
                    n3 = n;
                }
                while (this.rects[n3] == null && n3 > n) {
                    --n3;
                }
                if (this.rects[n3] == null) {
                    this.rects[n3] = rectangle;
                    return;
                }
            }
            if (rectangle.x == this.rects[n3].x) break;
            if (rectangle.x < this.rects[n3].x) {
                if (n3 == 0 || this.rects[n3 - 1] != null && rectangle.x >= this.rects[n3 - 1].x) break;
                n2 = n3 - 1;
                continue;
            }
            if (n3 == this.size - 1) {
                ++n3;
                break;
            }
            if (this.rects[n3 + 1] != null && rectangle.x <= this.rects[n3 + 1].x) {
                ++n3;
                break;
            }
            n = n3 + 1;
        }
        if (n3 < this.size) {
            System.arraycopy(this.rects, n3, this.rects, n3 + 1, this.size - n3);
        }
        this.rects[n3] = rectangle;
        ++this.size;
        this.bounds = null;
    }

    public boolean addAll(Collection collection) {
        if (collection instanceof RectListManager) {
            this.add((RectListManager)collection);
        } else {
            this.add(new RectListManager(collection));
        }
        return collection.size() != 0;
    }

    @Override
    public boolean contains(Object object) {
        int n;
        Rectangle rectangle = (Rectangle)object;
        int n2 = 0;
        int n3 = this.size - 1;
        int n4 = 0;
        while (n2 <= n3) {
            n4 = n2 + n3 >>> 1;
            if (rectangle.x == this.rects[n4].x) break;
            if (rectangle.x < this.rects[n4].x) {
                if (n4 == 0 || rectangle.x >= this.rects[n4 - 1].x) break;
                n3 = n4 - 1;
                continue;
            }
            if (n4 == this.size - 1) {
                ++n4;
                break;
            }
            if (rectangle.x <= this.rects[n4 + 1].x) {
                ++n4;
                break;
            }
            n2 = n4 + 1;
        }
        if (this.rects[n4].x != rectangle.x) {
            return false;
        }
        for (n = n4; n >= 0; --n) {
            if (this.rects[n4].equals(rectangle)) {
                return true;
            }
            if (this.rects[n4].x != rectangle.x) break;
        }
        for (n = n4 + 1; n < this.size; ++n) {
            if (this.rects[n4].equals(rectangle)) {
                return true;
            }
            if (this.rects[n4].x != rectangle.x) break;
        }
        return false;
    }

    public boolean containsAll(Collection collection) {
        if (collection instanceof RectListManager) {
            return this.containsAll((RectListManager)collection);
        }
        return this.containsAll(new RectListManager(collection));
    }

    public boolean containsAll(RectListManager rectListManager) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < rectListManager.size; ++i) {
            n2 = n;
            while (this.rects[n2].x < rectListManager.rects[i].x) {
                if (++n2 != this.size) continue;
                return false;
            }
            n = n2;
            int n3 = this.rects[n2].x;
            while (!rectListManager.rects[i].equals(this.rects[n2])) {
                if (++n2 == this.size) {
                    return false;
                }
                if (n3 == this.rects[n2].x) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean remove(Object object) {
        return this.remove((Rectangle)object);
    }

    public boolean remove(Rectangle rectangle) {
        int n;
        int n2 = 0;
        int n3 = this.size - 1;
        int n4 = 0;
        while (n2 <= n3) {
            n4 = n2 + n3 >>> 1;
            if (rectangle.x == this.rects[n4].x) break;
            if (rectangle.x < this.rects[n4].x) {
                if (n4 == 0 || rectangle.x >= this.rects[n4 - 1].x) break;
                n3 = n4 - 1;
                continue;
            }
            if (n4 == this.size - 1) {
                ++n4;
                break;
            }
            if (rectangle.x <= this.rects[n4 + 1].x) {
                ++n4;
                break;
            }
            n2 = n4 + 1;
        }
        if (this.rects[n4].x != rectangle.x) {
            return false;
        }
        for (n = n4; n >= 0; --n) {
            if (this.rects[n4].equals(rectangle)) {
                System.arraycopy(this.rects, n4 + 1, this.rects, n4, this.size - n4);
                --this.size;
                this.bounds = null;
                return true;
            }
            if (this.rects[n4].x != rectangle.x) break;
        }
        for (n = n4 + 1; n < this.size; ++n) {
            if (this.rects[n4].equals(rectangle)) {
                System.arraycopy(this.rects, n4 + 1, this.rects, n4, this.size - n4);
                --this.size;
                this.bounds = null;
                return true;
            }
            if (this.rects[n4].x != rectangle.x) break;
        }
        return false;
    }

    public boolean removeAll(Collection collection) {
        if (collection instanceof RectListManager) {
            return this.removeAll((RectListManager)collection);
        }
        return this.removeAll(new RectListManager(collection));
    }

    public boolean removeAll(RectListManager rectListManager) {
        int n;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        block0: for (n = 0; n < rectListManager.size; ++n) {
            n3 = n2;
            while ((this.rects[n3] == null || this.rects[n3].x < rectListManager.rects[n].x) && ++n3 != this.size) {
            }
            if (n3 == this.size) break;
            n2 = n3;
            int n4 = this.rects[n3].x;
            while (true) {
                if (this.rects[n3] == null) {
                    if (++n3 != this.size) continue;
                    continue block0;
                }
                if (rectListManager.rects[n].equals(this.rects[n3])) {
                    this.rects[n3] = null;
                    bl = true;
                }
                if (++n3 == this.size || n4 != this.rects[n3].x) continue block0;
            }
        }
        if (bl) {
            n = 0;
            for (n3 = 0; n3 < this.size; ++n3) {
                if (this.rects[n3] == null) continue;
                this.rects[n++] = this.rects[n3];
            }
            this.size = n;
            this.bounds = null;
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        if (collection instanceof RectListManager) {
            return this.retainAll((RectListManager)collection);
        }
        return this.retainAll(new RectListManager(collection));
    }

    public boolean retainAll(RectListManager rectListManager) {
        int n;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        block0: for (n = 0; n < this.size; ++n) {
            n3 = n2;
            while (rectListManager.rects[n3].x < this.rects[n].x && ++n3 != rectListManager.size) {
            }
            if (n3 == rectListManager.size) {
                bl = true;
                for (int i = n; i < this.size; ++i) {
                    this.rects[i] = null;
                }
                this.size = n;
                break;
            }
            n2 = n3;
            int n4 = rectListManager.rects[n3].x;
            while (!this.rects[n].equals(rectListManager.rects[n3])) {
                if (++n3 != rectListManager.size && n4 == rectListManager.rects[n3].x) continue;
                this.rects[n] = null;
                bl = true;
                continue block0;
            }
        }
        if (bl) {
            n = 0;
            for (n3 = 0; n3 < this.size; ++n3) {
                if (this.rects[n3] == null) continue;
                this.rects[n++] = this.rects[n3];
            }
            this.size = n;
            this.bounds = null;
        }
        return bl;
    }

    public void add(RectListManager rectListManager) {
        if (rectListManager.size == 0) {
            return;
        }
        Rectangle[] rectangleArray = this.rects;
        if (this.rects.length < this.size + rectListManager.size) {
            rectangleArray = new Rectangle[this.size + rectListManager.size];
        }
        if (this.size == 0) {
            System.arraycopy(rectListManager.rects, 0, rectangleArray, this.size, rectListManager.size);
            this.size = rectListManager.size;
            this.bounds = null;
            return;
        }
        Rectangle[] rectangleArray2 = rectListManager.rects;
        int n = rectListManager.size;
        int n2 = n - 1;
        Rectangle[] rectangleArray3 = this.rects;
        int n3 = this.size;
        int n4 = n3 - 1;
        int n5 = rectangleArray2[n2].x;
        int n6 = rectangleArray3[n4].x;
        for (int i = this.size + rectListManager.size - 1; i >= 0; --i) {
            if (n5 <= n6) {
                rectangleArray[i] = rectangleArray3[n4];
                if (n4 == 0) {
                    System.arraycopy(rectangleArray2, 0, rectangleArray, 0, n2 + 1);
                    break;
                }
                n6 = rectangleArray3[--n4].x;
                continue;
            }
            rectangleArray[i] = rectangleArray2[n2];
            if (n2 == 0) {
                System.arraycopy(rectangleArray3, 0, rectangleArray, 0, n4 + 1);
                break;
            }
            n5 = rectangleArray2[--n2].x;
        }
        this.rects = rectangleArray;
        this.size += rectListManager.size;
        this.bounds = null;
    }

    public void mergeRects(int n, int n2) {
        int n3;
        Rectangle rectangle;
        int n4;
        if (this.size == 0) {
            return;
        }
        Rectangle[] rectangleArray = new Rectangle[4];
        for (n4 = 0; n4 < this.size; ++n4) {
            rectangle = this.rects[n4];
            if (rectangle == null) continue;
            int n5 = n + rectangle.height * n2 + rectangle.height * rectangle.width;
            block1: do {
                int n6 = rectangle.x + rectangle.width + n / rectangle.height;
                for (n3 = n4 + 1; n3 < this.size; ++n3) {
                    Rectangle rectangle2 = this.rects[n3];
                    if (rectangle2 == null || rectangle2 == rectangle) continue;
                    if (rectangle2.x >= n6) {
                        n3 = this.size;
                        continue block1;
                    }
                    int n7 = n + rectangle2.height * n2 + rectangle2.height * rectangle2.width;
                    Rectangle rectangle3 = rectangle.union(rectangle2);
                    int n8 = n + rectangle3.height * n2 + rectangle3.height * rectangle3.width;
                    if (n8 <= n5 + n7) {
                        rectangle = this.rects[n4] = rectangle3;
                        this.rects[n3] = null;
                        n5 = n8;
                        n3 = -1;
                        continue block1;
                    }
                    if (!rectangle.intersects(rectangle2)) continue;
                    this.splitRect(rectangle2, rectangle, rectangleArray);
                    int n9 = 0;
                    int n10 = 0;
                    for (int i = 0; i < 4; ++i) {
                        if (rectangleArray[i] == null) continue;
                        Rectangle rectangle4 = rectangleArray[i];
                        if (i < 3) {
                            rectangleArray[n10++] = rectangle4;
                        }
                        n9 += n + rectangle4.height * n2 + rectangle4.height * rectangle4.width;
                    }
                    if (n9 >= n7) continue;
                    if (n10 == 0) {
                        this.rects[n3] = null;
                        if (rectangleArray[3] == null) continue;
                        this.add(rectangleArray[3], n3, this.size - 1);
                        continue;
                    }
                    this.rects[n3] = rectangleArray[0];
                    if (n10 > 1) {
                        this.insertRects(rectangleArray, 1, n3 + 1, n10 - 1);
                    }
                    if (rectangleArray[3] == null) continue;
                    this.add(rectangleArray[3], n3, this.size - 1);
                }
            } while (n3 != this.size);
        }
        n3 = 0;
        float f = 0.0f;
        for (n4 = 0; n4 < this.size; ++n4) {
            if (this.rects[n4] == null) continue;
            rectangle = this.rects[n4];
            this.rects[n3++] = rectangle;
            f += (float)(n + rectangle.height * n2 + rectangle.height * rectangle.width);
        }
        this.size = n3;
        this.bounds = null;
        rectangle = this.getBounds();
        if (rectangle == null) {
            return;
        }
        if ((float)(n + rectangle.height * n2 + rectangle.height * rectangle.width) < f) {
            this.rects[0] = rectangle;
            this.size = 1;
        }
    }

    public void subtract(RectListManager rectListManager, int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        Rectangle[] rectangleArray = new Rectangle[4];
        block0: for (n4 = 0; n4 < this.size; ++n4) {
            Rectangle rectangle = this.rects[n4];
            int n6 = n + rectangle.height * n2 + rectangle.height * rectangle.width;
            for (n3 = n5; n3 < rectListManager.size; ++n3) {
                int n7;
                Rectangle rectangle2 = rectListManager.rects[n3];
                if (rectangle2.x + rectangle2.width < rectangle.x) {
                    if (n3 != n5) continue;
                    ++n5;
                    continue;
                }
                if (rectangle2.x > rectangle.x + rectangle.width) continue block0;
                if (!rectangle.intersects(rectangle2)) continue;
                this.splitRect(rectangle, rectangle2, rectangleArray);
                int n8 = 0;
                for (n7 = 0; n7 < 4; ++n7) {
                    Rectangle rectangle3 = rectangleArray[n7];
                    if (rectangle3 == null) continue;
                    n8 += n + rectangle3.height * n2 + rectangle3.height * rectangle3.width;
                }
                if (n8 >= n6) continue;
                n7 = 0;
                for (int i = 0; i < 3; ++i) {
                    if (rectangleArray[i] == null) continue;
                    rectangleArray[n7++] = rectangleArray[i];
                }
                if (n7 == 0) {
                    this.rects[n4].width = 0;
                    if (rectangleArray[3] == null) continue block0;
                    this.add(rectangleArray[3], n4, this.size - 1);
                    continue block0;
                }
                this.rects[n4] = rectangle = rectangleArray[0];
                n6 = n + rectangle.height * n2 + rectangle.height * rectangle.width;
                if (n7 > 1) {
                    this.insertRects(rectangleArray, 1, n4 + 1, n7 - 1);
                }
                if (rectangleArray[3] == null) continue;
                this.add(rectangleArray[3], n4 + n7, this.size - 1);
            }
        }
        n4 = 0;
        for (n3 = 0; n3 < this.size; ++n3) {
            if (this.rects[n3].width == 0) {
                this.rects[n3] = null;
                continue;
            }
            this.rects[n4++] = this.rects[n3];
        }
        this.size = n4;
        this.bounds = null;
    }

    protected void splitRect(Rectangle rectangle, Rectangle rectangle2, Rectangle[] rectangleArray) {
        int n = rectangle.x;
        int n2 = n + rectangle.width - 1;
        int n3 = rectangle.y;
        int n4 = n3 + rectangle.height - 1;
        int n5 = rectangle2.x;
        int n6 = n5 + rectangle2.width - 1;
        int n7 = rectangle2.y;
        int n8 = n7 + rectangle2.height - 1;
        if (n3 < n7 && n4 >= n7) {
            rectangleArray[0] = new Rectangle(n, n3, rectangle.width, n7 - n3);
            n3 = n7;
        } else {
            rectangleArray[0] = null;
        }
        if (n3 <= n8 && n4 > n8) {
            rectangleArray[1] = new Rectangle(n, n8 + 1, rectangle.width, n4 - n8);
            n4 = n8;
        } else {
            rectangleArray[1] = null;
        }
        rectangleArray[2] = n < n5 && n2 >= n5 ? new Rectangle(n, n3, n5 - n, n4 - n3 + 1) : null;
        rectangleArray[3] = n <= n6 && n2 > n6 ? new Rectangle(n6 + 1, n3, n2 - n6, n4 - n3 + 1) : null;
    }

    protected void insertRects(Rectangle[] rectangleArray, int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        this.ensureCapacity(this.size + n3);
        for (int i = this.size - 1; i >= n2; --i) {
            this.rects[i + n3] = this.rects[i];
        }
        System.arraycopy(rectangleArray, n, this.rects, n2, n3);
        this.size += n3;
    }

    public void ensureCapacity(int n) {
        int n2;
        if (n <= this.rects.length) {
            return;
        }
        for (n2 = this.rects.length + (this.rects.length >> 1) + 1; n2 < n; n2 += (n2 >> 1) + 1) {
        }
        Rectangle[] rectangleArray = new Rectangle[n2];
        System.arraycopy(this.rects, 0, rectangleArray, 0, this.size);
        this.rects = rectangleArray;
    }

    private class RLMIterator
    implements ListIterator {
        int idx = 0;
        boolean removeOk = false;
        boolean forward = true;

        RLMIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.idx < RectListManager.this.size;
        }

        @Override
        public int nextIndex() {
            return this.idx;
        }

        @Override
        public Object next() {
            if (this.idx >= RectListManager.this.size) {
                throw new NoSuchElementException("No Next Element");
            }
            this.forward = true;
            this.removeOk = true;
            return RectListManager.this.rects[this.idx++];
        }

        @Override
        public boolean hasPrevious() {
            return this.idx > 0;
        }

        @Override
        public int previousIndex() {
            return this.idx - 1;
        }

        public Object previous() {
            if (this.idx <= 0) {
                throw new NoSuchElementException("No Previous Element");
            }
            this.forward = false;
            this.removeOk = true;
            return RectListManager.this.rects[--this.idx];
        }

        @Override
        public void remove() {
            if (!this.removeOk) {
                throw new IllegalStateException("remove can only be called directly after next/previous");
            }
            if (this.forward) {
                --this.idx;
            }
            if (this.idx != RectListManager.this.size - 1) {
                System.arraycopy(RectListManager.this.rects, this.idx + 1, RectListManager.this.rects, this.idx, RectListManager.this.size - (this.idx + 1));
            }
            --RectListManager.this.size;
            RectListManager.this.rects[RectListManager.this.size] = null;
            this.removeOk = false;
        }

        public void set(Object object) {
            Rectangle rectangle = (Rectangle)object;
            if (!this.removeOk) {
                throw new IllegalStateException("set can only be called directly after next/previous");
            }
            if (this.forward) {
                --this.idx;
            }
            if (this.idx + 1 < RectListManager.this.size && RectListManager.this.rects[this.idx + 1].x < rectangle.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            if (this.idx >= 0 && RectListManager.this.rects[this.idx - 1].x > rectangle.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            RectListManager.this.rects[this.idx] = rectangle;
            this.removeOk = false;
        }

        public void add(Object object) {
            Rectangle rectangle = (Rectangle)object;
            if (this.idx < RectListManager.this.size && RectListManager.this.rects[this.idx].x < rectangle.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            if (this.idx != 0 && RectListManager.this.rects[this.idx - 1].x > rectangle.x) {
                throw new UnsupportedOperationException("RectListManager entries must be sorted");
            }
            RectListManager.this.ensureCapacity(RectListManager.this.size + 1);
            if (this.idx != RectListManager.this.size) {
                System.arraycopy(RectListManager.this.rects, this.idx, RectListManager.this.rects, this.idx + 1, RectListManager.this.size - this.idx);
            }
            RectListManager.this.rects[this.idx] = rectangle;
            ++this.idx;
            this.removeOk = false;
        }
    }

    private static class RectXComparator
    implements Comparator,
    Serializable {
        RectXComparator() {
        }

        public final int compare(Object object, Object object2) {
            return ((Rectangle)object).x - ((Rectangle)object2).x;
        }
    }
}

