/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.stubs;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyTargetExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyClassAttributesIndex
extends StringStubIndexExtension<PyClass> {
    public static final StubIndexKey<String, PyClass> KEY = StubIndexKey.createIndexKey((String)"Py.class.attributes");

    @NotNull
    public StubIndexKey<String, PyClass> getKey() {
        StubIndexKey<String, PyClass> stubIndexKey = KEY;
        if (stubIndexKey == null) {
            PyClassAttributesIndex.$$$reportNull$$$0(0);
        }
        return stubIndexKey;
    }

    public static Collection<PyClass> find(@NotNull String name, @NotNull Project project) {
        if (name == null) {
            PyClassAttributesIndex.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PyClassAttributesIndex.$$$reportNull$$$0(2);
        }
        return StubIndex.getElements(KEY, (Object)name, (Project)project, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project), PyClass.class);
    }

    public static Collection<PyTargetExpression> findClassAndInstanceAttributes(@NotNull String name, @NotNull Project project, GlobalSearchScope scope) {
        if (name == null) {
            PyClassAttributesIndex.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PyClassAttributesIndex.$$$reportNull$$$0(4);
        }
        ArrayList<PyTargetExpression> ret = new ArrayList<PyTargetExpression>();
        StubIndex.getInstance().processElements(KEY, (Object)name, project, scope, PyClass.class, clazz -> {
            PyTargetExpression instAttr;
            ProgressManager.checkCanceled();
            PyTargetExpression classAttr = clazz.findClassAttribute(name, false, null);
            if (classAttr != null) {
                ret.add(classAttr);
            }
            if ((instAttr = clazz.findInstanceAttribute(name, false)) != null) {
                ret.add(instAttr);
            }
            return true;
        });
        return ret;
    }

    @NotNull
    public static List<String> getAllDeclaredAttributeNames(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PyClassAttributesIndex.$$$reportNull$$$0(5);
        }
        List members = ContainerUtil.concat((List[])new List[]{pyClass.getInstanceAttributes(), pyClass.getClassAttributes(), Arrays.asList(pyClass.getMethods())});
        List list = ContainerUtil.mapNotNull((Collection)members, expression -> {
            String attrName = expression.getName();
            return attrName != null ? attrName : null;
        });
        if (list == null) {
            PyClassAttributesIndex.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/stubs/PyClassAttributesIndex";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/stubs/PyClassAttributesIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDeclaredAttributeNames";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findClassAndInstanceAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllDeclaredAttributeNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

