/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.intentions.PyBaseIntentionAction;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyIfStatement;
import org.jetbrains.annotations.NotNull;

public class PyTransformConditionalExpressionIntention
extends PyBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("INTN.transform.into.if.else.statement", new Object[0]);
        if (string == null) {
            PyTransformConditionalExpressionIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = PyBundle.message("INTN.transform.into.if.else.statement", new Object[0]);
        if (string == null) {
            PyTransformConditionalExpressionIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            PyTransformConditionalExpressionIntention.$$$reportNull$$$0(2);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        PyAssignmentStatement expression = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyAssignmentStatement.class);
        return expression != null && expression.getAssignedValue() instanceof PyConditionalExpression;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PyTransformConditionalExpressionIntention.$$$reportNull$$$0(3);
        }
        PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), PyAssignmentStatement.class);
        assert (assignmentStatement != null);
        PyExpression assignedValue = assignmentStatement.getAssignedValue();
        if (assignedValue instanceof PyConditionalExpression) {
            PyConditionalExpression expression = (PyConditionalExpression)assignedValue;
            PyExpression condition = expression.getCondition();
            PyExpression falsePart = expression.getFalsePart();
            if (condition != null && falsePart != null) {
                String truePartText = expression.getTruePart().getText();
                PyExpression leftHandSideExpression = assignmentStatement.getLeftHandSideExpression();
                if (leftHandSideExpression != null) {
                    String targetText = leftHandSideExpression.getText();
                    PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
                    String text2 = "if " + condition.getText() + ":\n\t" + targetText + " = " + truePartText + "\nelse:\n\t" + targetText + " = " + falsePart.getText();
                    PyIfStatement ifStatement = elementGenerator.createFromText(LanguageLevel.forElement((PsiElement)expression), PyIfStatement.class, text2);
                    assignmentStatement.replace((PsiElement)ifStatement);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyTransformConditionalExpressionIntention";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyTransformConditionalExpressionIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

