/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.cvsoperations.cvsErrors;

import com.intellij.cvsSupport2.cvsoperations.cvsErrors.ErrorProcessor;
import com.intellij.cvsSupport2.cvsoperations.cvsMessages.CvsMessagesAdapter;
import com.intellij.cvsSupport2.errorHandling.CvsException;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;

public class ErrorMessagesProcessor
extends CvsMessagesAdapter
implements ErrorProcessor {
    private final List<VcsException> myErrors;

    public ErrorMessagesProcessor(List<VcsException> errors) {
        this.myErrors = errors;
    }

    public ErrorMessagesProcessor() {
        this(new ArrayList<VcsException>());
    }

    @Override
    public void addError(String message, String relativeFilePath, ICvsFileSystem cvsFileSystem, String cvsRoot, boolean warning) {
        VirtualFile vFile = ErrorMessagesProcessor.getVirtualFile(cvsFileSystem, relativeFilePath);
        CvsException vcsException = new CvsException(message, cvsRoot);
        if (vFile != null) {
            vcsException.setVirtualFile(vFile);
        }
        vcsException.setIsWarning(warning);
        this.myErrors.add(vcsException);
    }

    private static VirtualFile getVirtualFile(ICvsFileSystem cvsFileSystem, String relativeFileName) {
        if (cvsFileSystem == null) {
            return null;
        }
        if (relativeFileName == null) {
            return null;
        }
        return CvsVfsUtil.findFileByIoFile(cvsFileSystem.getLocalFileSystem().getFile(relativeFileName));
    }

    @Override
    public List<VcsException> getErrors() {
        return this.myErrors;
    }

    @Override
    public void addError(VcsException ex) {
        this.myErrors.add(ex);
    }
}

