/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.NullableComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class MouseDragHelper
implements MouseListener,
MouseMotionListener,
KeyEventDispatcher,
Weighted {
    public static final int DRAG_START_DEADZONE = 7;
    private final JComponent myDragComponent;
    private Point myPressPointScreen;
    protected Point myPressedOnScreenPoint;
    private Point myPressPointComponent;
    private boolean myDraggingNow;
    private boolean myDragJustStarted;
    private IdeGlassPane myGlassPane;
    private final Disposable myParentDisposable;
    private Dimension myDelta;
    private boolean myDetachPostponed;
    private boolean myDetachingMode;
    private boolean myCancelled;

    public MouseDragHelper(Disposable parent, JComponent dragComponent) {
        this.myDragComponent = dragComponent;
        this.myParentDisposable = parent;
    }

    public static boolean checkModifiers(InputEvent event) {
        if (event == null || !UISettings.getInstance().getDndWithPressedAltOnly()) {
            return true;
        }
        return (event.getModifiers() & 8) != 0;
    }

    public void start() {
        if (this.myGlassPane != null) {
            return;
        }
        new UiNotifyConnector(this.myDragComponent, new Activatable(){

            @Override
            public void showNotify() {
                MouseDragHelper.this.attach();
            }

            @Override
            public void hideNotify() {
                MouseDragHelper.this.detach(true);
            }
        });
        Disposer.register((Disposable)this.myParentDisposable, () -> this.stop());
    }

    private void attach() {
        if (this.myDetachPostponed) {
            this.myDetachPostponed = false;
            return;
        }
        this.myGlassPane = IdeGlassPaneUtil.find(this.myDragComponent);
        this.myGlassPane.addMousePreprocessor(this, this.myParentDisposable);
        this.myGlassPane.addMouseMotionPreprocessor(this, this.myParentDisposable);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        Disposer.register((Disposable)this.myParentDisposable, () -> KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this));
    }

    public void stop() {
        this.detach(false);
    }

    private void detach(boolean canPostponeDetach) {
        if (canPostponeDetach && this.myDraggingNow) {
            this.myDetachPostponed = true;
            return;
        }
        if (this.myGlassPane != null) {
            this.myGlassPane.removeMousePreprocessor(this);
            this.myGlassPane.removeMouseMotionPreprocessor(this);
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
            this.myGlassPane = null;
        }
    }

    @Override
    public double getWeight() {
        return 2.0;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!this.canStartDragging(e)) {
            return;
        }
        this.myPressPointScreen = new RelativePoint(e).getScreenPoint();
        this.myPressedOnScreenPoint = new Point(this.myPressPointScreen);
        this.myPressPointComponent = e.getPoint();
        this.processMousePressed(e);
        this.myDelta = new Dimension();
        if (this.myDragComponent.isShowing()) {
            Point delta = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), this.myDragComponent);
            this.myDelta.width = delta.x;
            this.myDelta.height = delta.y;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.myCancelled) {
            this.myCancelled = false;
            return;
        }
        boolean wasDragging = this.myDraggingNow;
        this.myPressPointScreen = null;
        this.myDraggingNow = false;
        this.myDragJustStarted = false;
        if (wasDragging) {
            try {
                if (this.myDetachingMode) {
                    this.processDragOutFinish(e);
                } else {
                    this.processDragFinish(e, false);
                }
            }
            finally {
                this.myPressedOnScreenPoint = null;
                this.resetDragState();
                e.consume();
                if (this.myDetachPostponed) {
                    this.myDetachPostponed = false;
                    this.detach(false);
                }
            }
        }
    }

    private void resetDragState() {
        this.myDraggingNow = false;
        this.myDragJustStarted = false;
        this.myPressPointComponent = null;
        this.myPressPointScreen = null;
        this.myDetachingMode = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.myPressPointScreen == null || this.myCancelled) {
            return;
        }
        boolean deadZone = this.isWithinDeadZone(e);
        if (!this.myDraggingNow && !deadZone) {
            this.myDraggingNow = true;
            this.myDragJustStarted = true;
        } else if (this.myDraggingNow) {
            this.myDragJustStarted = false;
        }
        if (this.myDraggingNow && this.myPressPointScreen != null) {
            Point draggedTo = new RelativePoint(e).getScreenPoint();
            boolean dragOutStarted = false;
            if (!this.myDetachingMode && this.isDragOut(e, draggedTo, (Point)this.myPressPointScreen.clone())) {
                this.myDetachingMode = true;
                this.processDragFinish(e, true);
                dragOutStarted = true;
            }
            if (this.myDetachingMode) {
                this.processDragOut(e, draggedTo, (Point)this.myPressPointScreen.clone(), dragOutStarted);
            } else {
                this.processDrag(e, draggedTo, (Point)this.myPressPointScreen.clone());
            }
        }
    }

    private boolean canStartDragging(MouseEvent me) {
        if (me.getButton() != 1) {
            return false;
        }
        if (!this.myDragComponent.isShowing()) {
            return false;
        }
        Component component = me.getComponent();
        if (NullableComponent.Check.isNullOrHidden((Component)component)) {
            return false;
        }
        Point dragComponentPoint = SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), this.myDragComponent);
        return this.canStartDragging(this.myDragComponent, dragComponentPoint);
    }

    protected boolean canStartDragging(JComponent dragComponent, Point dragComponentPoint) {
        return true;
    }

    protected void processMousePressed(MouseEvent event) {
    }

    protected void processDragCancel() {
    }

    protected void processDragFinish(@NotNull MouseEvent event, boolean willDragOutStart) {
        if (event == null) {
            MouseDragHelper.$$$reportNull$$$0(0);
        }
    }

    protected void processDragOutFinish(@NotNull MouseEvent event) {
        if (event == null) {
            MouseDragHelper.$$$reportNull$$$0(1);
        }
    }

    protected void processDragOutCancel() {
    }

    public final boolean isDragJustStarted() {
        return this.myDragJustStarted;
    }

    protected abstract void processDrag(@NotNull MouseEvent var1, @NotNull Point var2, @NotNull Point var3);

    protected boolean isDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint) {
        if (event == null) {
            MouseDragHelper.$$$reportNull$$$0(2);
        }
        if (dragToScreenPoint == null) {
            MouseDragHelper.$$$reportNull$$$0(3);
        }
        if (startScreenPoint == null) {
            MouseDragHelper.$$$reportNull$$$0(4);
        }
        return false;
    }

    protected void processDragOut(@NotNull MouseEvent event, @NotNull Point dragToScreenPoint, @NotNull Point startScreenPoint, boolean justStarted) {
        if (event == null) {
            MouseDragHelper.$$$reportNull$$$0(5);
        }
        if (dragToScreenPoint == null) {
            MouseDragHelper.$$$reportNull$$$0(6);
        }
        if (startScreenPoint == null) {
            MouseDragHelper.$$$reportNull$$$0(7);
        }
        event.consume();
    }

    private boolean isWithinDeadZone(MouseEvent e) {
        Point screen = new RelativePoint(e).getScreenPoint();
        return Math.abs(this.myPressPointScreen.x - screen.x - this.myDelta.width) < 7 && Math.abs(this.myPressPointScreen.y - screen.y - this.myDelta.height) < 7;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27 && e.getID() == 401 && this.myDraggingNow) {
            this.myCancelled = true;
            if (this.myDetachingMode) {
                this.processDragOutCancel();
            } else {
                this.processDragCancel();
            }
            this.resetDragState();
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dragToScreenPoint";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startScreenPoint";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/MouseDragHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processDragFinish";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processDragOutFinish";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isDragOut";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processDragOut";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

