/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.mergeinfo;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntry;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.history.LogHierarchyNode;
import org.jetbrains.idea.svn.history.SvnChangeList;
import org.jetbrains.idea.svn.integrate.MergeContext;
import org.jetbrains.idea.svn.mergeinfo.MergeChecker;
import org.jetbrains.idea.svn.mergeinfo.MergeRangeList;
import org.jetbrains.idea.svn.mergeinfo.SvnMergeInfoCache;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;

public class OneShotMergeInfoHelper
implements MergeChecker {
    @NotNull
    private final MergeContext myMergeContext;
    @NotNull
    private final Map<Long, Collection<String>> myPartiallyMerged;
    @NotNull
    private final NavigableMap<String, Map<String, MergeRangeList>> myMergeInfoMap;
    @NotNull
    private final Object myMergeInfoLock;

    public OneShotMergeInfoHelper(@NotNull MergeContext mergeContext) {
        if (mergeContext == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(0);
        }
        this.myMergeContext = mergeContext;
        this.myPartiallyMerged = ContainerUtil.newHashMap();
        this.myMergeInfoLock = new Object();
        this.myMergeInfoMap = new TreeMap(Collections.reverseOrder());
    }

    @Override
    public void prepare() throws VcsException {
        Depth depth = Depth.allOrEmpty(this.myMergeContext.getVcs().getSvnConfiguration().isCheckNestedForQuickMerge());
        File file = this.myMergeContext.getWcInfo().getRootInfo().getIoFile();
        this.myMergeContext.getVcs().getFactory(file).createPropertyClient().getProperty(Target.on(file), "svn:mergeinfo", Revision.WORKING, depth, this.createPropertyHandler());
    }

    @Override
    @Nullable
    public Collection<String> getNotMergedPaths(@NotNull SvnChangeList changeList) {
        if (changeList == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(1);
        }
        return this.myPartiallyMerged.get(changeList.getNumber());
    }

    @Override
    @NotNull
    public SvnMergeInfoCache.MergeCheckResult checkList(@NotNull SvnChangeList changeList) {
        if (changeList == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(2);
        }
        HashSet notMergedPaths = ContainerUtil.newHashSet();
        boolean hasMergedPaths = false;
        for (String path : changeList.getAffectedPaths()) {
            switch (this.checkPath(path, changeList.getNumber())) {
                case MERGED: {
                    hasMergedPaths = true;
                    break;
                }
                case NOT_MERGED: {
                    notMergedPaths.add(path);
                }
            }
        }
        if (hasMergedPaths && !notMergedPaths.isEmpty()) {
            this.myPartiallyMerged.put(changeList.getNumber(), notMergedPaths);
        }
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = notMergedPaths.isEmpty() ? (hasMergedPaths ? SvnMergeInfoCache.MergeCheckResult.MERGED : SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS) : SvnMergeInfoCache.MergeCheckResult.NOT_MERGED;
        if (mergeCheckResult == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(3);
        }
        return mergeCheckResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public SvnMergeInfoCache.MergeCheckResult checkPath(@NotNull String repositoryRelativePath, long revisionNumber) {
        if (repositoryRelativePath == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(4);
        }
        SvnMergeInfoCache.MergeCheckResult result = SvnMergeInfoCache.MergeCheckResult.NOT_EXISTS;
        String sourceRelativePath = Url.getRelative(this.myMergeContext.getRepositoryRelativeSourcePath(), SvnUtil.ensureStartSlash(repositoryRelativePath));
        if (sourceRelativePath != null) {
            InfoProcessor processor = new InfoProcessor(sourceRelativePath, this.myMergeContext.getRepositoryRelativeSourcePath(), revisionNumber);
            String key = OneShotMergeInfoHelper.toKey(sourceRelativePath);
            Object object = this.myMergeInfoLock;
            synchronized (object) {
                Map mergeInfo = (Map)this.myMergeInfoMap.get(key);
                if (mergeInfo != null) {
                    processor.process(key, mergeInfo);
                } else {
                    Map.Entry<String, Map<String, MergeRangeList>> entry;
                    Iterator<Map.Entry<String, Map<String, MergeRangeList>>> iterator = this.myMergeInfoMap.tailMap(key).entrySet().iterator();
                    while (!(!iterator.hasNext() || OneShotMergeInfoHelper.isUnder((entry = iterator.next()).getKey(), key) && processor.process(entry.getKey(), entry.getValue()))) {
                    }
                }
            }
            result = SvnMergeInfoCache.MergeCheckResult.getInstance(processor.isMerged());
        }
        SvnMergeInfoCache.MergeCheckResult mergeCheckResult = result;
        if (mergeCheckResult == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(5);
        }
        return mergeCheckResult;
    }

    private static boolean isUnder(@NotNull String parentUrl, @NotNull String childUrl) {
        if (parentUrl == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(6);
        }
        if (childUrl == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(7);
        }
        return ".".equals(parentUrl) || Url.isAncestor(SvnUtil.ensureStartSlash(parentUrl), SvnUtil.ensureStartSlash(childUrl));
    }

    @NotNull
    private PropertyConsumer createPropertyHandler() {
        PropertyConsumer propertyConsumer = new PropertyConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleProperty(@NotNull File path, @NotNull PropertyData property) throws SvnBindException {
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (property == null) {
                    1.$$$reportNull$$$0(1);
                }
                String workingCopyRelativePath = OneShotMergeInfoHelper.this.getWorkingCopyRelativePath(path);
                Map<String, MergeRangeList> mergeInfo = MergeRangeList.parseMergeInfo(((PropertyValue)ObjectUtils.notNull((Object)property.getValue())).toString());
                Object object = OneShotMergeInfoHelper.this.myMergeInfoLock;
                synchronized (object) {
                    OneShotMergeInfoHelper.this.myMergeInfoMap.put(OneShotMergeInfoHelper.toKey(workingCopyRelativePath), mergeInfo);
                }
            }

            @Override
            public void handleProperty(Url url, PropertyData property) {
            }

            @Override
            public void handleProperty(long revision, PropertyData property) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "property";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$1";
                objectArray[2] = "handleProperty";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (propertyConsumer == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(8);
        }
        return propertyConsumer;
    }

    @NotNull
    private String getWorkingCopyRelativePath(@NotNull File file) {
        if (file == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(9);
        }
        String string = FileUtil.toSystemIndependentName((String)((String)ObjectUtils.notNull((Object)FileUtil.getRelativePath((File)this.myMergeContext.getWcInfo().getRootInfo().getIoFile(), (File)file))));
        if (string == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static String toKey(@NotNull String path) {
        if (path == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(11);
        }
        String string = SystemInfo.isFileSystemCaseSensitive ? path : StringUtil.toUpperCase((String)path);
        if (string == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean checkListForPaths(@NotNull LogHierarchyNode node) {
        boolean isLocalChange;
        if (node == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(13);
        }
        return (isLocalChange = ContainerUtil.or(node.getChildren(), this::checkForSubtree)) || OneShotMergeInfoHelper.checkForEntry(node.getMe(), this.myMergeContext.getRepositoryRelativeWorkingCopyPath(), this.myMergeContext.getRepositoryRelativeSourcePath());
    }

    private boolean checkForSubtree(@NotNull LogHierarchyNode tree) {
        if (tree == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(14);
        }
        LinkedList<LogHierarchyNode> queue = new LinkedList<LogHierarchyNode>();
        queue.addLast(tree);
        while (!queue.isEmpty()) {
            LogHierarchyNode element = (LogHierarchyNode)queue.removeFirst();
            ProgressManager.checkCanceled();
            if (OneShotMergeInfoHelper.checkForEntry(element.getMe(), this.myMergeContext.getRepositoryRelativeSourcePath(), this.myMergeContext.getRepositoryRelativeWorkingCopyPath())) {
                return true;
            }
            queue.addAll(element.getChildren());
        }
        return false;
    }

    private static boolean checkForEntry(@NotNull LogEntry entry, @NotNull String localURL, @NotNull String relativeBranch) {
        if (entry == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(15);
        }
        if (localURL == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(16);
        }
        if (relativeBranch == null) {
            OneShotMergeInfoHelper.$$$reportNull$$$0(17);
        }
        boolean atLeastOneUnderBranch = false;
        for (LogEntryPath path : entry.getChangedPaths().values()) {
            if (Url.isAncestor(localURL, path.getPath())) {
                return true;
            }
            if (atLeastOneUnderBranch || !Url.isAncestor(relativeBranch, path.getPath())) continue;
            atLeastOneUnderBranch = true;
        }
        return !atLeastOneUnderBranch;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeList";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryRelativePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentUrl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childUrl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localURL";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "checkList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "checkPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createPropertyHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkingCopyRelativePath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "toKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNotMergedPaths";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkList";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWorkingCopyRelativePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "toKey";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkListForPaths";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkForSubtree";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkForEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class InfoProcessor
    implements PairProcessor<String, Map<String, MergeRangeList>> {
        @NotNull
        private final String myRepositoryRelativeSourcePath;
        private boolean myIsMerged;
        @NotNull
        private final String mySourceRelativePath;
        private final long myRevisionNumber;

        InfoProcessor(@NotNull String sourceRelativePath, @NotNull String repositoryRelativeSourcePath, long revisionNumber) {
            if (sourceRelativePath == null) {
                InfoProcessor.$$$reportNull$$$0(0);
            }
            if (repositoryRelativeSourcePath == null) {
                InfoProcessor.$$$reportNull$$$0(1);
            }
            this.mySourceRelativePath = sourceRelativePath;
            this.myRevisionNumber = revisionNumber;
            this.myRepositoryRelativeSourcePath = SvnUtil.ensureStartSlash(repositoryRelativeSourcePath);
        }

        public boolean isMerged() {
            return this.myIsMerged;
        }

        public boolean process(@NotNull String workingCopyRelativePath, @NotNull Map<String, MergeRangeList> mergedPathsMap) {
            if (workingCopyRelativePath == null) {
                InfoProcessor.$$$reportNull$$$0(2);
            }
            if (mergedPathsMap == null) {
                InfoProcessor.$$$reportNull$$$0(3);
            }
            boolean processed = false;
            boolean isCurrentPath = workingCopyRelativePath.equals(this.mySourceRelativePath);
            if (mergedPathsMap.isEmpty()) {
                this.myIsMerged = false;
                processed = true;
            } else {
                String mergedPathAffectingSourcePath = (String)ContainerUtil.find(mergedPathsMap.keySet(), path -> Url.isAncestor(this.myRepositoryRelativeSourcePath, SvnUtil.ensureStartSlash(path)));
                if (mergedPathAffectingSourcePath != null) {
                    MergeRangeList mergeRangeList = mergedPathsMap.get(mergedPathAffectingSourcePath);
                    processed = true;
                    this.myIsMerged = ContainerUtil.exists(mergeRangeList.getRanges(), range -> range.contains(this.myRevisionNumber) && (range.isInheritable() || isCurrentPath));
                }
            }
            return processed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceRelativePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositoryRelativeSourcePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "workingCopyRelativePath";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergedPathsMap";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/svn/mergeinfo/OneShotMergeInfoHelper$InfoProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

