/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.util.DocumentUtil;
import com.intellij.vcs.commit.BaseCommitMessageInspection;
import com.intellij.vcs.commit.BodyLimitInspectionOptions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BodyLimitInspection
extends BaseCommitMessageInspection {
    public int RIGHT_MARGIN = 72;

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Limit body line" == null) {
            BodyLimitInspection.$$$reportNull$$$0(0);
        }
        return "Limit body line";
    }

    @Override
    @NotNull
    public ConfigurableUi<Project> createOptionsConfigurable() {
        BodyLimitInspectionOptions bodyLimitInspectionOptions = new BodyLimitInspectionOptions(this);
        if (bodyLimitInspectionOptions == null) {
            BodyLimitInspection.$$$reportNull$$$0(1);
        }
        return bodyLimitInspectionOptions;
    }

    @Override
    @Nullable
    protected ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull Document document, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file2 == null) {
            BodyLimitInspection.$$$reportNull$$$0(2);
        }
        if (document == null) {
            BodyLimitInspection.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            BodyLimitInspection.$$$reportNull$$$0(4);
        }
        return (ProblemDescriptor[])IntStream.range(1, document.getLineCount()).mapToObj(line -> BodyLimitInspection.checkRightMargin(file2, document, manager, isOnTheFly, line, this.RIGHT_MARGIN, String.format("Body lines should not exceed %d characters", this.RIGHT_MARGIN), new LocalQuickFix[]{new WrapLineQuickFix(), new BaseCommitMessageInspection.ReformatCommitMessageQuickFix()})).filter(Objects::nonNull).toArray(ProblemDescriptor[]::new);
    }

    @Override
    public boolean canReformat(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            BodyLimitInspection.$$$reportNull$$$0(5);
        }
        if (document == null) {
            BodyLimitInspection.$$$reportNull$$$0(6);
        }
        return this.hasProblems(project, document);
    }

    @Override
    public void reformat(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            BodyLimitInspection.$$$reportNull$$$0(7);
        }
        if (document == null) {
            BodyLimitInspection.$$$reportNull$$$0(8);
        }
        new WrapLineQuickFix().doApplyFix(project, document, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/commit/BodyLimitInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsConfigurable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/commit/BodyLimitInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canReformat";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class WrapLineQuickFix
    extends BaseCommitMessageInspection.BaseCommitMessageQuickFix {
        protected WrapLineQuickFix() {
            super("Wrap line");
        }

        @Override
        public void doApplyFix(@NotNull Project project, @NotNull Document document, @Nullable ProblemDescriptor descriptor) {
            Editor editor;
            if (project == null) {
                WrapLineQuickFix.$$$reportNull$$$0(0);
            }
            if (document == null) {
                WrapLineQuickFix.$$$reportNull$$$0(1);
            }
            if ((editor = CommitMessage.getEditor(document)) != null) {
                TextRange range2;
                TextRange textRange = range2 = descriptor != null && descriptor.getLineNumber() >= 0 ? DocumentUtil.getLineTextRange(document, descriptor.getLineNumber()) : this.getBodyRange(document);
                if (!range2.isEmpty()) {
                    this.wrapLines(project, editor, document, BodyLimitInspection.this.RIGHT_MARGIN, range2);
                }
            }
        }

        @NotNull
        private TextRange getBodyRange(@NotNull Document document) {
            if (document == null) {
                WrapLineQuickFix.$$$reportNull$$$0(2);
            }
            TextRange textRange = document.getLineCount() > 1 ? TextRange.create((int)document.getLineStartOffset(1), (int)document.getTextLength()) : TextRange.EMPTY_RANGE;
            if (textRange == null) {
                WrapLineQuickFix.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        private void wrapLines(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, final int rightMargin, @NotNull TextRange range2) {
            if (project == null) {
                WrapLineQuickFix.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                WrapLineQuickFix.$$$reportNull$$$0(5);
            }
            if (document == null) {
                WrapLineQuickFix.$$$reportNull$$$0(6);
            }
            if (range2 == null) {
                WrapLineQuickFix.$$$reportNull$$$0(7);
            }
            CodeFormatterFacade codeFormatter = new CodeFormatterFacade(new CodeStyleSettings(false){

                public int getRightMargin(@Nullable Language language) {
                    return rightMargin;
                }
            }, null);
            List<TextRange> enabledRanges = Collections.singletonList(TextRange.create((int)0, (int)document.getTextLength()));
            codeFormatter.doWrapLongLinesIfNecessary(editor, project, document, range2.getStartOffset(), range2.getEndOffset(), enabledRanges);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/commit/BodyLimitInspection$WrapLineQuickFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/commit/BodyLimitInspection$WrapLineQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBodyRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doApplyFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getBodyRange";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "wrapLines";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

