/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.AbstractMessage;
import com.intellij.diagnostic.LogMessage;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GroupedLogMessage
extends AbstractMessage {
    private static final String INDUCED_STACKTRACES_ATTACHMENT = "induced.txt";
    private static final DateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
    private final List<AbstractMessage> myMessages;
    private AbstractMessage myProxy;

    public GroupedLogMessage(List<AbstractMessage> messages) {
        this.myMessages = messages;
    }

    public List<AbstractMessage> getMessages() {
        return this.myMessages;
    }

    @Override
    @NotNull
    public Throwable getThrowable() {
        Throwable throwable = this.myMessages.get(0).getThrowable();
        if (throwable == null) {
            GroupedLogMessage.$$$reportNull$$$0(0);
        }
        return throwable;
    }

    @Override
    @NotNull
    public String getThrowableText() {
        StringBuilder result2 = new StringBuilder();
        for (AbstractMessage each : this.myMessages) {
            if (result2.length() > 0) {
                result2.append("\n\n\n");
            }
            result2.append(each.getThrowableText());
        }
        String string = result2.toString();
        if (string == null) {
            GroupedLogMessage.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.myMessages.get(0).getMessage();
    }

    @Override
    @NotNull
    public List<Attachment> getAllAttachments() {
        List list2 = ContainerUtil.concat(this.getMessages(), message -> message.getAllAttachments());
        if (list2 == null) {
            GroupedLogMessage.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    public void setRead(boolean isRead) {
        super.setRead(isRead);
        for (AbstractMessage message : this.myMessages) {
            message.setRead(isRead);
        }
    }

    @Override
    public void setAssigneeId(@Nullable Integer assigneeId) {
        super.setAssigneeId(assigneeId);
        for (AbstractMessage message : this.myMessages) {
            message.setAssigneeId(assigneeId);
        }
    }

    AbstractMessage getProxyMessage() {
        if (this.myProxy == null) {
            AbstractMessage mainCause = this.myMessages.get(0);
            ArrayList<Attachment> attachments = new ArrayList<Attachment>(mainCause.getAllAttachments());
            StringBuilder stacktraces = new StringBuilder("Following exceptions happened soon after this one, most probably they are induced.");
            for (AbstractMessage each : this.myMessages) {
                if (each == mainCause) continue;
                stacktraces.append("\n\n\n").append(TIMESTAMP_FORMAT.format(each.getDate())).append('\n');
                if (!StringUtil.isEmptyOrSpaces((String)each.getMessage())) {
                    stacktraces.append(each.getMessage()).append('\n');
                }
                stacktraces.append(each.getThrowableText());
            }
            attachments.add(new Attachment(INDUCED_STACKTRACES_ATTACHMENT, stacktraces.toString()));
            this.myProxy = new ProxyLogMessage(mainCause.getThrowable(), mainCause.getMessage(), attachments, this);
        }
        return this.myProxy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/diagnostic/GroupedLogMessage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAttachments";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ProxyLogMessage
    extends LogMessage {
        private final GroupedLogMessage myOriginal;

        private ProxyLogMessage(Throwable throwable, String message, List<Attachment> attachments, GroupedLogMessage original) {
            super(throwable, message, attachments);
            this.myOriginal = original;
        }

        @Override
        public void setRead(boolean isRead) {
            super.setRead(isRead);
            this.myOriginal.setRead(isRead);
        }
    }
}

