/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.codeInsight.template.postfix.templates.editable.EditablePostfixTemplateWithMultipleExpressions;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateEditor;
import com.intellij.codeInsight.template.postfix.templates.editable.PostfixTemplateExpressionCondition;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplateEditorBase<Condition extends PostfixTemplateExpressionCondition>
implements PostfixTemplateEditor {
    @NotNull
    protected final PostfixTemplateProvider myProvider;
    @NotNull
    protected final Editor myTemplateEditor;
    @NotNull
    protected final JBList<Condition> myExpressionTypesList;
    @NotNull
    protected final DefaultListModel<Condition> myExpressionTypesListModel;
    @NotNull
    protected final JPanel myTemplateEditorPanel;
    @NotNull
    protected final JPanel myExpressionTypesPanel;
    @NotNull
    protected final JBCheckBox myApplyToTheTopmostJBCheckBox;
    @NotNull
    protected final JPanel myEditTemplateAndConditionsPanel;
    @NotNull
    protected final JBLabel myExpressionVariableHint;

    public PostfixTemplateEditorBase(@NotNull PostfixTemplateProvider provider, boolean showExpressionTypes) {
        if (provider == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(0);
        }
        this(provider, PostfixTemplateEditorBase.createSimpleEditor(), showExpressionTypes);
    }

    public PostfixTemplateEditorBase(@NotNull PostfixTemplateProvider provider, @NotNull Editor templateEditor, boolean showExpressionTypes) {
        if (provider == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(1);
        }
        if (templateEditor == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(2);
        }
        this.myProvider = provider;
        this.myTemplateEditor = templateEditor;
        this.myApplyToTheTopmostJBCheckBox = new JBCheckBox("Apply to the &topmost expression");
        DialogUtil.registerMnemonic((AbstractButton)this.myApplyToTheTopmostJBCheckBox, (char)'&');
        this.myTemplateEditorPanel = new JPanel(new BorderLayout());
        this.myTemplateEditorPanel.add(this.myTemplateEditor.getComponent());
        this.myExpressionVariableHint = new JBLabel("Use $EXPR$ variable to refer target expression");
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myExpressionVariableHint);
        this.myExpressionVariableHint.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.myExpressionTypesListModel = JBList.createDefaultListModel((Object[])new PostfixTemplateExpressionCondition[0]);
        this.myExpressionTypesList = new JBList(this.myExpressionTypesListModel);
        this.myExpressionTypesList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<PostfixTemplateExpressionCondition>(){

            protected void customizeCellRenderer(@NotNull JList<? extends PostfixTemplateExpressionCondition> list2, PostfixTemplateExpressionCondition value, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.append(value.getPresentableName());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplateEditorBase$1", "customizeCellRenderer"));
            }
        });
        this.myExpressionTypesPanel = new JPanel(new BorderLayout());
        FormBuilder builder2 = FormBuilder.createFormBuilder();
        if (showExpressionTypes) {
            this.myExpressionTypesPanel.add(ToolbarDecorator.createDecorator(this.myExpressionTypesList).setAddAction(button -> this.showAddExpressionTypePopup((AnActionButton)button)).setRemoveAction(button -> ListUtil.removeSelectedItems(this.myExpressionTypesList)).disableUpDownActions().createPanel());
            this.myExpressionTypesPanel.setMinimumSize(new Dimension(-1, 100));
            builder2.addLabeledComponent("Applicable expression types:", (JComponent)this.myExpressionTypesPanel, true);
        }
        builder2.addComponent((JComponent)this.myApplyToTheTopmostJBCheckBox);
        builder2.addComponent((JComponent)this.myTemplateEditorPanel);
        builder2.addComponent((JComponent)this.myExpressionVariableHint);
        this.myEditTemplateAndConditionsPanel = builder2.getPanel();
    }

    @NotNull
    protected static Editor createEditor(@NotNull Project project, @NotNull Document document) {
        if (project == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(3);
        }
        if (document == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(4);
        }
        Editor editor = TemplateEditorUtil.createEditor(false, document, project);
        if (editor == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(5);
        }
        return editor;
    }

    @NotNull
    private static Editor createSimpleEditor() {
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        Editor editor = PostfixTemplateEditorBase.createEditor(defaultProject, EditorFactory.getInstance().createDocument((CharSequence)""));
        if (editor == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(6);
        }
        return editor;
    }

    protected final void showAddExpressionTypePopup(@NotNull AnActionButton button) {
        if (button == null) {
            PostfixTemplateEditorBase.$$$reportNull$$$0(7);
        }
        DefaultActionGroup group = new DefaultActionGroup();
        this.fillConditions(group);
        DataContext context = DataManager.getInstance().getDataContext((Component)button.getContextComponent());
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, context, JBPopupFactory.ActionSelectionAid.ALPHA_NUMBERING, true, null);
        popup2.show((RelativePoint)ObjectUtils.assertNotNull((Object)button.getPreferredPopupPoint()));
    }

    protected abstract void fillConditions(@NotNull DefaultActionGroup var1);

    public void setTemplate(@Nullable PostfixTemplate rawTemplate) {
        if (!(rawTemplate instanceof EditablePostfixTemplateWithMultipleExpressions)) {
            return;
        }
        EditablePostfixTemplateWithMultipleExpressions template = (EditablePostfixTemplateWithMultipleExpressions)rawTemplate;
        this.myExpressionTypesListModel.clear();
        for (PostfixTemplateExpressionCondition condition : template.getExpressionConditions()) {
            this.myExpressionTypesListModel.addElement(condition);
        }
        this.myApplyToTheTopmostJBCheckBox.setSelected(template.isUseTopmostExpression());
        ApplicationManager.getApplication().runWriteAction(() -> this.myTemplateEditor.getDocument().setText((CharSequence)template.getLiveTemplate().getString()));
    }

    @Override
    public String getHelpId() {
        return "reference.custom.postfix.templates";
    }

    public void dispose() {
        TemplateEditorUtil.disposeTemplateEditor(this.myTemplateEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplateEditorBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/postfix/settings/PostfixTemplateEditorBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimpleEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showAddExpressionTypePopup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class AddConditionAction
    extends DumbAwareAction {
        @NotNull
        private final Condition myCondition;
        final /* synthetic */ PostfixTemplateEditorBase this$0;

        public AddConditionAction(Condition condition) {
            this.this$0 = this$0;
            super(condition.getPresentableName());
            this.myCondition = condition;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddConditionAction.$$$reportNull$$$0(0);
            }
            this.this$0.myExpressionTypesListModel.addElement(this.myCondition);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/template/postfix/settings/PostfixTemplateEditorBase$AddConditionAction", "actionPerformed"));
        }
    }
}

