/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.Size;
import com.sun.glass.ui.monocle.NativeCursor;
import com.sun.glass.ui.monocle.NativeCursors;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.NativeScreen;
import com.sun.glass.ui.monocle.SysFS;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class OMAPCursor
extends NativeCursor {
    private int hotspotX;
    private int hotspotY;
    private int offsetX;
    private int offsetY;
    private int cursorX;
    private int cursorY;
    private static final int INT_KEY = 0x12121212;
    private static final int SHORT_KEY = 43947;
    private static final int CURSOR_WIDTH = 16;
    private static final int CURSOR_HEIGHT = 16;
    private Buffer cursorBuffer;
    private Buffer offsetCursorBuffer;
    private byte[] offsetCursor;
    private int screenWidth;
    private int screenHeight;
    private int cursorDepth;
    private int transparentPixel;

    OMAPCursor() {
        try {
            SysFS.write("/sys/class/graphics/fb1/virtual_size", "16,16");
            SysFS.write("/sys/devices/platform/omapdss/overlay1/output_size", "16,16");
            SysFS.write("/sys/devices/platform/omapdss/manager0/trans_key_enabled", "1");
            SysFS.write("/sys/devices/platform/omapdss/manager0/trans_key_type", "video-source");
            this.cursorDepth = SysFS.readInt("/sys/class/graphics/fb1/bits_per_pixel");
            switch (this.cursorDepth) {
                case 16: {
                    this.transparentPixel = 43947;
                    break;
                }
                case 32: {
                    this.transparentPixel = 0x12121212;
                    break;
                }
                default: {
                    throw new IOException("Cannot use an OMAP cursor with a bit depth of " + this.cursorDepth);
                }
            }
            SysFS.write("/sys/devices/platform/omapdss/manager0/trans_key_value", Long.toString(this.transparentPixel));
        }
        catch (IOException e) {
            e.printStackTrace();
            System.err.println("Failed to initialize OMAP cursor");
        }
        NativeScreen screen = NativePlatformFactory.getNativePlatform().getScreen();
        this.screenWidth = screen.getWidth();
        this.screenHeight = screen.getHeight();
    }

    @Override
    Size getBestSize() {
        return new Size(16, 16);
    }

    @Override
    void setVisibility(boolean visibility) {
        try {
            SysFS.write("/sys/devices/platform/omapdss/overlay1/enabled", visibility ? "1" : "0");
        }
        catch (IOException e) {
            System.err.format("Failed to %s OMAP cursor\n", visibility ? "enable" : "disable");
        }
        this.isVisible = visibility;
    }

    private void updateImage(boolean always) {
        int newOffsetX = Math.max(0, 16 + this.cursorX - this.screenWidth);
        int newOffsetY = Math.max(0, 16 + this.cursorY - this.screenHeight);
        if (newOffsetX != this.offsetX || newOffsetY != this.offsetY || always) {
            NativeCursors.offsetCursor(this.cursorBuffer, this.offsetCursorBuffer, newOffsetX, newOffsetY, 16, 16, this.cursorDepth, this.transparentPixel);
            this.offsetX = newOffsetX;
            this.offsetY = newOffsetY;
            try {
                SysFS.write("/dev/fb1", this.offsetCursor);
            }
            catch (IOException e) {
                System.err.println("Failed to write OMAP cursor image");
            }
        }
    }

    @Override
    void setImage(byte[] cursorImage) {
        ByteBuffer bb = ByteBuffer.allocate(cursorImage.length);
        this.cursorBuffer = this.cursorDepth == 32 ? bb.asIntBuffer() : bb.asShortBuffer();
        NativeCursors.colorKeyCursor(cursorImage, this.cursorBuffer, this.cursorDepth, this.transparentPixel);
        this.offsetCursor = new byte[cursorImage.length];
        bb = ByteBuffer.wrap(this.offsetCursor);
        this.offsetCursorBuffer = this.cursorDepth == 32 ? bb.asIntBuffer() : bb.asShortBuffer();
        this.updateImage(true);
    }

    @Override
    void setLocation(int x, int y) {
        this.cursorX = x;
        this.cursorY = y;
        this.updateImage(false);
        try {
            SysFS.write("/sys/devices/platform/omapdss/overlay1/position", this.cursorX - this.hotspotX - this.offsetX + "," + (this.cursorY - this.hotspotY - this.offsetY));
        }
        catch (IOException e) {
            System.err.println("Failed to set OMAP cursor position");
        }
    }

    @Override
    void setHotSpot(int hotspotX, int hotspotY) {
        this.hotspotX = hotspotX;
        this.hotspotY = hotspotY;
    }

    @Override
    void shutdown() {
        try {
            SysFS.write("/sys/devices/platform/omapdss/overlay1/enabled", "0");
        }
        catch (IOException e) {
            System.err.println("Failed to shut down OMAP cursor");
        }
    }
}

