/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.zaproxy.zap.extension.api.AbstractAPIGenerator;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class PhpAPIGenerator
extends AbstractAPIGenerator {
    private final String HEADER = "<?php\n/**\n * Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright 2016 the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n";
    private static final Map<String, String> nameMap;

    public PhpAPIGenerator() {
        super("php/api/zapv2/src/Zap");
    }

    public PhpAPIGenerator(String path, boolean optional) {
        super(path, optional);
    }

    public PhpAPIGenerator(String path, boolean optional, ResourceBundle resourceBundle) {
        super(path, optional, resourceBundle);
    }

    @Deprecated
    public void generatePhpFiles(List<ApiImplementor> implementors) throws IOException {
        this.generateAPIFiles(implementors);
    }

    private void generatePhpElement(ApiElement element, String component, String type, Writer out) throws IOException {
        boolean hasParams;
        block30: {
            hasParams = element.getMandatoryParamNames() != null && element.getMandatoryParamNames().size() > 0 || element.getOptionalParamNames() != null && element.getOptionalParamNames().size() > 0;
            String descTag = element.getDescriptionTag();
            if (descTag == null) {
                descTag = component + ".api." + type + "." + element.getName();
            }
            try {
                String desc = this.getMessages().getString(descTag);
                out.write("\t/**\n");
                out.write("\t * " + desc + "\n");
                if (this.isOptional()) {
                    out.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                }
                out.write("\t */\n");
            }
            catch (Exception e) {
                System.out.println("No i18n for: " + descTag);
                if (!this.isOptional()) break block30;
                out.write("\t/**\n");
                out.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                out.write("\t */\n");
            }
        }
        out.write("\tpublic function " + PhpAPIGenerator.createMethodName(element.getName()) + "(");
        String paramMan = "";
        if (element.getMandatoryParamNames() != null) {
            for (String string : element.getMandatoryParamNames()) {
                if (!paramMan.isEmpty()) {
                    paramMan = paramMan + ", ";
                }
                paramMan = paramMan + "$" + string.toLowerCase();
            }
            out.write(paramMan);
        }
        String paramOpt = "";
        if (element.getOptionalParamNames() != null) {
            for (String param : element.getOptionalParamNames()) {
                if (!paramMan.isEmpty() || !paramOpt.isEmpty()) {
                    paramOpt = paramOpt + ", ";
                }
                paramOpt = paramOpt + "$" + param.toLowerCase() + "=NULL";
            }
            out.write(paramOpt);
        }
        if (type.equals("action") || type.equals("other")) {
            if (hasParams) {
                out.write(", ");
            }
            out.write("$apikey=''");
            hasParams = true;
        }
        out.write(") {\n");
        StringBuilder stringBuilder = new StringBuilder();
        if (hasParams) {
            stringBuilder.append("array(");
            boolean first = true;
            if (element.getMandatoryParamNames() != null) {
                for (String param : element.getMandatoryParamNames()) {
                    if (first) {
                        first = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append("'" + param + "' => $" + param.toLowerCase());
                }
            }
            if (type.equals("action") || type.equals("other")) {
                if (!first) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append("'").append("apikey").append("' => $").append("apikey");
            }
            stringBuilder.append(")");
            if (element.getOptionalParamNames() != null && !element.getOptionalParamNames().isEmpty()) {
                out.write("\t\t$params = ");
                out.write(stringBuilder.toString());
                out.write(";\n");
                stringBuilder.replace(0, stringBuilder.length(), "$params");
                for (String param : element.getOptionalParamNames()) {
                    out.write("\t\tif ($" + param.toLowerCase() + " !== NULL) {\n");
                    out.write("\t\t\t$params['" + param + "'] = $" + param.toLowerCase() + ";\n");
                    out.write("\t\t}\n");
                }
            }
        }
        String method = "request";
        String baseUrl = "base";
        if (type.equals("other")) {
            method = method + "other";
            baseUrl = baseUrl + "_other";
        }
        out.write("\t\treturn $this->zap->" + method + "($this->zap->" + baseUrl + " . '" + component + "/" + type + "/" + element.getName() + "/'");
        if (hasParams) {
            out.write(", ");
            out.write(stringBuilder.toString());
            out.write(")");
            if (type.equals("view")) {
                out.write("->{'" + element.getName() + "'};\n");
            } else {
                out.write(";\n");
            }
        } else if (!type.equals("other")) {
            if (element.getName().startsWith("option")) {
                out.write(")->{'" + element.getName().substring(6) + "'};\n");
            } else {
                out.write(")->{'" + element.getName() + "'};\n");
            }
        } else {
            out.write(");\n");
        }
        out.write("\t}\n\n");
    }

    private static String createMethodName(String name) {
        if (nameMap.containsKey(name)) {
            name = nameMap.get(name);
        }
        return PhpAPIGenerator.removeAllFullStopCharacters(name);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    @Override
    protected void generateAPIFiles(ApiImplementor imp) throws IOException {
        String className = PhpAPIGenerator.safeName(imp.getPrefix().substring(0, 1).toUpperCase() + imp.getPrefix().substring(1));
        Path file = this.getDirectory().resolve(className + ".php");
        System.out.println("Generating " + file.toAbsolutePath());
        try (BufferedWriter out = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
            out.write("<?php\n/**\n * Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright 2016 the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n");
            out.write("namespace Zap;\n\n");
            out.write("\n");
            out.write("/**\n");
            out.write(" * This file was automatically generated.\n");
            out.write(" */\n");
            out.write("class " + className + " {\n\n");
            out.write("\tpublic function __construct ($zap) {\n");
            out.write("\t\t$this->zap = $zap;\n");
            out.write("\t}\n\n");
            for (ApiElement apiElement : imp.getApiViews()) {
                this.generatePhpElement(apiElement, imp.getPrefix(), "view", out);
            }
            for (ApiElement apiElement : imp.getApiActions()) {
                this.generatePhpElement(apiElement, imp.getPrefix(), "action", out);
            }
            for (ApiElement apiElement : imp.getApiOthers()) {
                this.generatePhpElement(apiElement, imp.getPrefix(), "other", out);
            }
            out.write("}\n");
        }
    }

    private static String safeName(String name) {
        if (nameMap.containsKey(name)) {
            return nameMap.get(name);
        }
        return name;
    }

    public static void main(String[] args) throws Exception {
        PhpAPIGenerator wapi = new PhpAPIGenerator();
        wapi.generateCoreAPIFiles();
    }

    static {
        HashMap<String, String> initMap = new HashMap<String, String>();
        initMap.put("Break", "Brk");
        initMap.put("break", "brk");
        initMap.put("continue", "cont");
        nameMap = Collections.unmodifiableMap(initMap);
    }
}

