"use strict";
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
require("url-search-params-polyfill");
function pathWithParams(path, additionalParams, whitelistParams, search = window.location.search) {
    const params = paramsToRecord(search);
    if (additionalParams) {
        Object.assign(params, additionalParams);
    }
    if (whitelistParams) {
        Object.keys(params).forEach(key => {
            if (!whitelistParams.includes(key)) {
                delete params[key];
            }
        });
    }
    const queryString = new URLSearchParams(params).toString();
    return `${path}${queryString ? `?${queryString}` : ''}`;
}
exports.pathWithParams = pathWithParams;
function paramsToRecord(params) {
    const records = {};
    new URLSearchParams(params).forEach((value, key) => {
        records[key] = value;
    });
    return records;
}
exports.paramsToRecord = paramsToRecord;
function getURLParameter(parameterName, search = window.location.search) {
    return new URLSearchParams(search).get(parameterName) || '';
}
exports.getURLParameter = getURLParameter;
function hasURLParameter(parameterName, search = window.location.search) {
    return !!new URLSearchParams(search).has(parameterName);
}
exports.hasURLParameter = hasURLParameter;
//# sourceMappingURL=UrlUtil.js.map