"use strict";
var __values = (this && this.__values) || function (o) {
    var m = typeof Symbol === "function" && o[Symbol.iterator], i = 0;
    if (m) return m.call(o);
    return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
};
Object.defineProperty(exports, "__esModule", { value: true });
var Electron = require("electron");
var config = require("../settings/config");
var ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
var SettingsType_1 = require("../settings/SettingsType");
var cs_CZ = require('../../locale/cs-CZ');
var da_DK = require('../../locale/da-DK');
var de_DE = require('../../locale/de-DE');
var el_GR = require('../../locale/el-GR');
var en_US = require('../../locale/en-US');
var es_ES = require('../../locale/es-ES');
var et_EE = require('../../locale/et-EE');
var fi_FI = require('../../locale/fi-FI');
var fr_FR = require('../../locale/fr-FR');
var hr_HR = require('../../locale/hr-HR');
var hu_HU = require('../../locale/hu-HU');
var it_IT = require('../../locale/it-IT');
var lt_LT = require('../../locale/lt-LT');
var nl_NL = require('../../locale/nl-NL');
var pl_PL = require('../../locale/pl-PL');
var pt_BR = require('../../locale/pt-BR');
var ro_RO = require('../../locale/ro-RO');
var ru_RU = require('../../locale/ru-RU');
var sk_SK = require('../../locale/sk-SK');
var sl_SI = require('../../locale/sl-SI');
var tr_TR = require('../../locale/tr-TR');
var uk_UA = require('../../locale/uk-UA');
var app = Electron.app || Electron.remote.app;
var LANGUAGES = {
    cs: cs_CZ,
    da: da_DK,
    de: de_DE,
    el: el_GR,
    en: en_US,
    es: es_ES,
    et: et_EE,
    fi: fi_FI,
    fr: fr_FR,
    hr: hr_HR,
    hu: hu_HU,
    it: it_IT,
    lt: lt_LT,
    nl: nl_NL,
    pl: pl_PL,
    pt: pt_BR,
    ro: ro_RO,
    ru: ru_RU,
    sk: sk_SK,
    sl: sl_SI,
    tr: tr_TR,
    uk: uk_UA,
};
exports.LANGUAGES = LANGUAGES;
var SUPPORTED_LANGUAGES = {
    en: 'English',
    cs: 'Čeština',
    da: 'Dansk',
    de: 'Deutsch',
    el: 'Ελληνικά',
    et: 'Eesti',
    es: 'Español',
    fr: 'Français',
    hr: 'Hrvatski',
    it: 'Italiano',
    lt: 'Lietuvos',
    hu: 'Magyar',
    nl: 'Nederlands',
    pl: 'Polski',
    pt: 'Português do Brasil',
    ro: 'Română',
    ru: 'Русский',
    sk: 'Slovenčina',
    sl: 'Slovenščina',
    fi: 'Suomi',
    tr: 'Türkçe',
    uk: 'Українська',
};
exports.SUPPORTED_LANGUAGES = SUPPORTED_LANGUAGES;
var current;
var getSupportedLanguageKeys = function () {
    return Object.keys(SUPPORTED_LANGUAGES);
};
var getCurrent = function () {
    if (!current) {
        var defaultLocale = parseLocale(app.getLocale().substr(0, 2));
        current = ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.LOCALE, defaultLocale);
    }
    return current;
};
exports.getCurrent = getCurrent;
var parseLocale = function (locale) {
    var languageKeys = getSupportedLanguageKeys();
    return languageKeys.find(function (languageKey) { return languageKey === locale; }) || languageKeys[0];
};
var customReplacements = {
    appName: config.NAME,
    maximumAccounts: config.MAXIMUM_ACCOUNTS.toString(),
};
var getText = function (stringIdentifier) {
    var e_1, _a;
    var strings = getCurrent();
    var str = LANGUAGES[strings][stringIdentifier] || LANGUAGES.en[stringIdentifier] || '';
    if (str) {
        try {
            for (var _b = __values(Object.keys(customReplacements)), _c = _b.next(); !_c.done; _c = _b.next()) {
                var replacement = _c.value;
                var regex = new RegExp("{{" + replacement + "}}", 'g');
                if (str.match(regex)) {
                    str = str.replace(regex, customReplacements[replacement]);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    return str;
};
exports.getText = getText;
var setLocale = function (locale) {
    current = parseLocale(locale);
    ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.LOCALE, current);
};
exports.setLocale = setLocale;
//# sourceMappingURL=locale.js.map