/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.image;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.List;
import org.sejda.impl.sambox.component.PDDocumentHandler;
import org.sejda.impl.sambox.component.PageImageWriter;
import org.sejda.impl.sambox.component.image.ExifHelper;
import org.sejda.model.exception.TaskException;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.input.Source;
import org.sejda.model.parameter.PageOrientation;
import org.sejda.model.parameter.PageSize;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.graphics.image.PDImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagesToPdfDocumentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ImagesToPdfDocumentConverter.class);
    private PDRectangle pageSize = PDRectangle.A4;
    private boolean shouldPageSizeMatchImageSize = false;
    private PageOrientation pageOrientation = PageOrientation.AUTO;
    private float marginInches = 0.0f;

    public PDDocumentHandler convert(List<Source<?>> sourceList) throws TaskException {
        PDDocumentHandler documentHandler = new PDDocumentHandler();
        documentHandler.setCreatorOnPDDocument();
        PageImageWriter imageWriter = new PageImageWriter(documentHandler.getUnderlyingPDDocument());
        for (Source<?> source : sourceList) {
            this.beforeImage(source);
            try {
                float ratio;
                PDImageXObject image = PageImageWriter.toPDXImageObject(source);
                PDRectangle mediaBox = this.pageSize;
                if (this.shouldPageSizeMatchImageSize) {
                    mediaBox = new PDRectangle((float)image.getWidth(), (float)image.getHeight());
                }
                if (this.pageOrientation == PageOrientation.LANDSCAPE) {
                    mediaBox = new PDRectangle(mediaBox.getHeight(), mediaBox.getWidth());
                } else if (this.pageOrientation == PageOrientation.AUTO && image.getWidth() > image.getHeight() && (float)image.getWidth() > mediaBox.getWidth()) {
                    LOG.debug("Switching to landscape, image dimensions are {}x{}", (Object)image.getWidth(), (Object)image.getHeight());
                    mediaBox = new PDRectangle(mediaBox.getHeight(), mediaBox.getWidth());
                }
                PDPage page = documentHandler.addBlankPage(mediaBox);
                float width = image.getWidth();
                float height = image.getHeight();
                if (width > mediaBox.getWidth()) {
                    int targetWidth = (int)mediaBox.getWidth();
                    LOG.debug("Scaling image down to fit by width {} vs {}", (Object)Float.valueOf(width), (Object)targetWidth);
                    ratio = width / (float)targetWidth;
                    width = targetWidth;
                    height = Math.round(height / ratio);
                }
                if (height > mediaBox.getHeight()) {
                    int targetHeight = (int)mediaBox.getHeight();
                    LOG.debug("Scaling image down to fit by height {} vs {}", (Object)Float.valueOf(height), (Object)targetHeight);
                    ratio = height / (float)targetHeight;
                    height = targetHeight;
                    width = Math.round(width / ratio);
                }
                if (this.marginInches > 0.0f) {
                    float newWidth = width - this.marginInches * 72.0f;
                    float newHeight = height * newWidth / width;
                    width = newWidth;
                    height = newHeight;
                }
                float x = (mediaBox.getWidth() - width) / 2.0f;
                float y = ((float)((int)mediaBox.getHeight()) - height) / 2.0f;
                imageWriter.append(page, image, (Point2D)new Point((int)x, (int)y), width, height, null, 0);
                int rotation = ExifHelper.getRotationBasedOnExifOrientation(source);
                page.setRotation(rotation);
                this.afterImage(image);
            }
            catch (TaskIOException e) {
                this.failedImage(source, e);
            }
        }
        return documentHandler;
    }

    public void beforeImage(Source<?> source) throws TaskException {
    }

    public void afterImage(PDImageXObject image) throws TaskException {
    }

    public void failedImage(Source<?> source, TaskIOException e) throws TaskException {
        throw e;
    }

    public void setPageSize(PageSize pageSize) {
        this.pageSize = new PDRectangle(pageSize.getWidth(), pageSize.getHeight());
    }

    public void setPageSize(PDRectangle pageSize) {
        this.pageSize = pageSize;
    }

    public void setShouldPageSizeMatchImageSize(boolean shouldPageSizeMatchImageSize) {
        this.shouldPageSizeMatchImageSize = shouldPageSizeMatchImageSize;
    }

    public void setPageOrientation(PageOrientation pageOrientation) {
        this.pageOrientation = pageOrientation;
    }

    public void setMarginInches(float marginInches) {
        this.marginInches = marginInches;
    }
}

