/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sejda.model.exception.TaskIOException;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.text.PDFTextStripperByArea;

public class PdfTextExtractorByArea {
    private static final int GUESSTIMATE_HEADER_FOOTER_HEIGHT = 40;

    public String extractFooterText(PDPage page) throws TaskIOException {
        return this.extractTextFromArea(page, this.getFooterAreaRectangle(page));
    }

    public String extractHeaderText(PDPage page) throws TaskIOException {
        return this.extractTextFromArea(page, this.getHeaderAreaRectangle(page));
    }

    public String extractAddedText(PDPage page, Point2D position) throws TaskIOException {
        return this.extractTextFromArea(page, this.getAddedTextAreaRectangle(page, position));
    }

    private Rectangle getAddedTextAreaRectangle(PDPage page, Point2D position) {
        PDRectangle pageSize = page.getCropBox().rotate(page.getRotation());
        int pageHeight = (int)pageSize.getHeight();
        int pageWidth = (int)pageSize.getWidth();
        int guesstimateTextHeight = 12;
        return new Rectangle((int)position.getX(), pageHeight - (int)position.getY(), pageWidth, guesstimateTextHeight);
    }

    private Rectangle getFooterAreaRectangle(PDPage page) {
        PDRectangle pageSize = page.getCropBox().rotate(page.getRotation());
        int pageHeight = (int)pageSize.getHeight();
        int pageWidth = (int)pageSize.getWidth();
        return new Rectangle(0, pageHeight - 40, pageWidth, 40);
    }

    private Rectangle getHeaderAreaRectangle(PDPage page) {
        PDRectangle pageSize = page.getCropBox().rotate(page.getRotation());
        int pageWidth = (int)pageSize.getWidth();
        return new Rectangle(0, 0, pageWidth, 40);
    }

    public String extractTextFromArea(PDPage page, Rectangle2D area) throws TaskIOException {
        try {
            PDFTextStripperByArea stripper = new PDFTextStripperByArea();
            stripper.setSortByPosition(true);
            stripper.addRegion("area1", area);
            stripper.extractRegions(page);
            String result = stripper.getTextForRegion("area1");
            result = (String)StringUtils.defaultIfBlank((CharSequence)result, (CharSequence)"");
            result = StringUtils.strip((String)result);
            result = org.sejda.core.support.util.StringUtils.normalizeWhitespace((String)result).trim();
            return result;
        }
        catch (IOException e) {
            throw new TaskIOException("An error occurred extracting text from page.", (Throwable)e);
        }
    }

    public List<String> extractTextFromAreas(PDPage page, List<Rectangle> areas) throws TaskIOException {
        ArrayList<String> results = new ArrayList<String>(areas.size());
        try {
            int i;
            PDFTextStripperByArea stripper = new PDFTextStripperByArea();
            stripper.setSortByPosition(true);
            for (i = 0; i < areas.size(); ++i) {
                stripper.addRegion("area" + i, (Rectangle2D)areas.get(i));
            }
            stripper.extractRegions(page);
            for (i = 0; i < areas.size(); ++i) {
                String text = stripper.getTextForRegion("area" + i);
                String result = (String)StringUtils.defaultIfBlank((CharSequence)text, (CharSequence)"");
                result = StringUtils.strip((String)result);
                result = org.sejda.core.support.util.StringUtils.normalizeWhitespace((String)result).trim();
                results.add(result);
            }
            return results;
        }
        catch (IOException e) {
            throw new TaskIOException("An error occurred extracting text from page.", (Throwable)e);
        }
    }
}

