/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class GraphPanel
extends JPanel {
    private int width = 800;
    private int heigth = 400;
    private int padding = 25;
    private int labelPadding = 25;
    private Color lineColor = new Color(44, 102, 230, 180);
    private Color pointColor = new Color(100, 100, 100, 180);
    private Color gridColor = new Color(200, 200, 200, 200);
    private static final Stroke GRAPH_STROKE = new BasicStroke(2.0f);
    private int pointWidth = 8;
    private int numberYDivisions = 10;
    private Map<Long, Double> scores;
    private Color mBackgroundColor;
    private String mDrawText;

    public GraphPanel(Map<Long, Double> pScores) {
        this.scores = pScores;
        this.mBackgroundColor = Color.WHITE;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int i;
        int labelWidth;
        FontMetrics metrics;
        int y1;
        int y0;
        int i2;
        int y12;
        int x1;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Long minTime = this.getMinTime();
        double maxScore = this.getMaxScore() + (double)this.padding;
        long ydist = this.getMaxTime() - minTime;
        double xScale = ((double)this.getWidth() - (double)(2 * this.padding) - (double)this.labelPadding) / (double)ydist;
        double yScale = ((double)this.getHeight() - (double)(2 * this.padding) - (double)this.labelPadding) / (maxScore - this.getMinScore());
        ArrayList<Point> graphPoints = new ArrayList<Point>();
        for (Long ypoint : this.scores.keySet()) {
            x1 = (int)(((double)(ypoint - minTime) + 0.0) * xScale + (double)this.padding + (double)this.labelPadding);
            y12 = (int)((maxScore - this.scores.get(ypoint)) * yScale + (double)this.padding);
            graphPoints.add(new Point(x1, y12));
        }
        g2.setColor(this.mBackgroundColor);
        g2.fillRect(this.padding + this.labelPadding, this.padding, this.getWidth() - 2 * this.padding - this.labelPadding, this.getHeight() - 2 * this.padding - this.labelPadding);
        g2.setColor(Color.BLACK);
        for (i2 = 0; i2 < this.numberYDivisions + 1; ++i2) {
            int x0 = this.padding + this.labelPadding;
            x1 = this.pointWidth + this.padding + this.labelPadding;
            y1 = y0 = this.getHeight() - (i2 * (this.getHeight() - this.padding * 2 - this.labelPadding) / this.numberYDivisions + this.padding + this.labelPadding);
            if (this.scores.size() > 0) {
                g2.setColor(this.gridColor);
                g2.drawLine(this.padding + this.labelPadding + 1 + this.pointWidth, y0, this.getWidth() - this.padding, y1);
                g2.setColor(Color.BLACK);
                String yLabel = (int)(this.getMinScore() + (maxScore - this.getMinScore()) * ((double)i2 * 1.0 / (double)this.numberYDivisions)) + "";
                metrics = g2.getFontMetrics();
                labelWidth = metrics.stringWidth(yLabel);
                g2.drawString(yLabel, x0 - labelWidth - 5, y0 + metrics.getHeight() / 2 - 3);
            }
            g2.drawLine(x0, y0, x1, y1);
        }
        for (i2 = 0; i2 < this.scores.size(); ++i2) {
            int x0;
            if (this.scores.size() <= 1) continue;
            x1 = x0 = (int)((double)i2 * ((double)this.getWidth() - (double)this.padding * 2.0 - (double)this.labelPadding) / (double)this.scores.size() + (double)this.padding + (double)this.labelPadding);
            y0 = this.getHeight() - this.padding - this.labelPadding;
            y1 = y0 - this.pointWidth;
            if (i2 % ((int)((double)this.scores.size() / 5.0) + 1) == 0) {
                g2.setColor(this.gridColor);
                g2.drawLine(x0, this.getHeight() - this.padding - this.labelPadding - 1 - this.pointWidth, x1, this.padding);
                g2.setColor(Color.BLACK);
                String xLabel = DateFormat.getDateTimeInstance().format(minTime + ydist * (long)i2 / (long)this.scores.size());
                metrics = g2.getFontMetrics();
                labelWidth = metrics.stringWidth(xLabel);
                g2.drawString(xLabel, x0 - labelWidth / 2, y0 + metrics.getHeight() + 3);
            }
            g2.drawLine(x0, y0, x1, y1);
        }
        g2.drawLine(this.padding + this.labelPadding, this.getHeight() - this.padding - this.labelPadding, this.padding + this.labelPadding, this.padding);
        g2.drawLine(this.padding + this.labelPadding, this.getHeight() - this.padding - this.labelPadding, this.getWidth() - this.padding, this.getHeight() - this.padding - this.labelPadding);
        Stroke oldStroke = g2.getStroke();
        g2.setColor(this.lineColor);
        g2.setStroke(GRAPH_STROKE);
        for (i = 0; i < graphPoints.size() - 1; ++i) {
            x1 = ((Point)graphPoints.get((int)i)).x;
            y12 = ((Point)graphPoints.get((int)i)).y;
            int x2 = ((Point)graphPoints.get((int)(i + 1))).x;
            int y2 = ((Point)graphPoints.get((int)(i + 1))).y;
            g2.drawLine(x1, y12, x2, y2);
        }
        g2.setStroke(oldStroke);
        g2.setColor(this.pointColor);
        for (i = 0; i < graphPoints.size(); ++i) {
            int x = ((Point)graphPoints.get((int)i)).x - this.pointWidth / 2;
            int y = ((Point)graphPoints.get((int)i)).y - this.pointWidth / 2;
            int ovalW = this.pointWidth;
            int ovalH = this.pointWidth;
            g2.fillOval(x, y, ovalW, ovalH);
        }
        if (this.mDrawText != null) {
            this.drawRotate(g2, this.mDrawText);
        }
    }

    public void drawRotate(Graphics2D g2, String text) {
        double place = Math.sqrt(this.getWidth() * this.getWidth() + this.getHeight() * this.getHeight());
        double angle = Math.acos((double)this.getWidth() / place);
        Graphics2D g2d = (Graphics2D)g2.create();
        g2d.setFont(g2d.getFont().deriveFont(128.0f));
        int stringWidth = g2d.getFontMetrics().stringWidth(text);
        g2d.translate((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f);
        g2d.rotate(-angle);
        double effectiveStringWidth = place / (double)(2.0f * (float)stringWidth);
        g2d.scale(effectiveStringWidth, effectiveStringWidth);
        g2d.drawString(text, (int)(-0.5f * (float)stringWidth), 0);
        g2d.dispose();
    }

    private double getMinScore() {
        double minScore = Double.MAX_VALUE;
        for (Double score : this.scores.values()) {
            minScore = Math.min(minScore, score);
        }
        return minScore;
    }

    private double getMaxScore() {
        double maxScore = Double.MIN_VALUE;
        for (Double score : this.scores.values()) {
            maxScore = Math.max(maxScore, score);
        }
        return maxScore;
    }

    private Long getMinTime() {
        Long minTime = Long.MAX_VALUE;
        for (Long Time2 : this.scores.keySet()) {
            minTime = Math.min(minTime, Time2);
        }
        return minTime;
    }

    private Long getMaxTime() {
        Long maxTime = Long.MIN_VALUE;
        for (Long Time2 : this.scores.keySet()) {
            maxTime = Math.max(maxTime, Time2);
        }
        return maxTime;
    }

    public void setScores(Map<Long, Double> scores) {
        this.scores = scores;
        this.invalidate();
        this.repaint();
    }

    public Map<Long, Double> getScores() {
        return this.scores;
    }

    private static void createAndShowGui() {
        LinkedHashMap<Long, Double> scores = new LinkedHashMap<Long, Double>();
        Random random = new Random();
        int maxDataPoints = 40;
        int maxScore = 10;
        long time = System.currentTimeMillis();
        for (int i = 0; i < maxDataPoints; ++i) {
            scores.put(time, random.nextDouble() * (double)maxScore);
            time = (long)((double)time + random.nextDouble() * 1000.0 * 60.0);
        }
        GraphPanel mainPanel = new GraphPanel(scores);
        mainPanel.setDrawText("Calculating");
        mainPanel.setPreferredSize(new Dimension(800, 600));
        JFrame frame = new JFrame("DrawGraph");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(mainPanel);
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GraphPanel.createAndShowGui();
            }
        });
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public void setBackgroundColor(Color pBackgroundColor) {
        this.mBackgroundColor = pBackgroundColor;
    }

    public String getDrawText() {
        return this.mDrawText;
    }

    public void setDrawText(String pDrawText) {
        this.mDrawText = pDrawText;
    }
}

