/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.ant;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.source.ant.UserCancel;
import org.netbeans.modules.java.source.usages.BuildArtifactMapperImpl;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

public class TranslateClassPath
extends Task {
    private String classpath;
    private String targetProperty;
    private boolean clean;
    private boolean moduleOriented;

    public void setClasspath(String cp) {
        this.classpath = cp;
    }

    public void setTargetProperty(String tp) {
        this.targetProperty = tp;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public void setModuleOriented(boolean moduleOriented) {
        this.moduleOriented = moduleOriented;
    }

    public void execute() throws BuildException {
        if (this.classpath == null) {
            throw new BuildException("Classpath must be set.");
        }
        if (this.targetProperty == null) {
            throw new BuildException("Target property must be set.");
        }
        Project p = this.getProject();
        String translated = this.translate(this.classpath);
        p.setProperty(this.targetProperty, translated);
    }

    private String translate(String classpath) {
        StringBuilder cp = new StringBuilder();
        boolean first = true;
        boolean disableSources = Boolean.valueOf(this.getProject().getProperty("maven.disableSources"));
        for (String path : PropertyUtils.tokenizePath((String)classpath)) {
            File[] files = this.translateEntry(path, disableSources);
            if (files.length == 0) continue;
            for (File f : files) {
                if (!first) {
                    cp.append(File.pathSeparatorChar);
                }
                cp.append(f.getAbsolutePath());
                first = false;
            }
        }
        return cp.toString();
    }

    private File[] translateEntry(String path, boolean disableSources) throws BuildException {
        HackedFile entryFile = new HackedFile(path);
        try {
            URL entry = FileUtil.urlForArchiveOrDir((File)entryFile);
            SourceForBinaryQuery.Result2 r = SourceForBinaryQuery.findSourceRoots2((URL)entry);
            boolean appendEntry = false;
            if (!disableSources && r.preferSources() && r.getRoots().length > 0) {
                ArrayList<File> translated = new ArrayList<File>();
                for (FileObject source : r.getRoots()) {
                    Boolean bamiResult;
                    File sourceFile = FileUtil.toFile((FileObject)source);
                    if (sourceFile == null) {
                        this.log("Source URL: " + source.toURL().toExternalForm() + " cannot be translated to file, skipped", 1);
                        appendEntry = true;
                        continue;
                    }
                    Boolean bl = bamiResult = this.clean ? BuildArtifactMapperImpl.clean((URL)Utilities.toURI((File)sourceFile).toURL()) : BuildArtifactMapperImpl.ensureBuilt((URL)Utilities.toURI((File)sourceFile).toURL(), (Object)this.getProject(), (boolean)true, (boolean)true);
                    if (bamiResult == null) {
                        appendEntry = true;
                        continue;
                    }
                    if (!bamiResult.booleanValue()) {
                        throw new UserCancel();
                    }
                    for (URL binary : BinaryForSourceQuery.findBinaryRoots((URL)source.toURL()).getRoots()) {
                        File finaryFile;
                        FileObject binaryFO = URLMapper.findFileObject((URL)binary);
                        File file = finaryFile = binaryFO != null ? FileUtil.toFile((FileObject)binaryFO) : null;
                        if (finaryFile == null) continue;
                        if (this.moduleOriented && finaryFile.isDirectory() && "jar".equals(entry.getProtocol())) {
                            boolean hasModuleInfo;
                            boolean bl2 = hasModuleInfo = finaryFile.listFiles(new FilenameFilter(){

                                @Override
                                public boolean accept(File dir, String name) {
                                    return "module-info.class".equals(name);
                                }
                            }).length > 0;
                            if (!hasModuleInfo) {
                                File jarFile = new File(finaryFile.getParentFile(), entryFile.getName());
                                Jar jarTask = new Jar();
                                jarTask.setProject(this.getProject());
                                jarTask.setDestFile(jarFile);
                                jarTask.setBasedir(finaryFile);
                                jarTask.setExcludes(".netbeans*");
                                jarTask.execute();
                                translated.add(jarFile);
                                continue;
                            }
                        }
                        translated.add(finaryFile);
                    }
                }
                if (appendEntry) {
                    translated.add(entryFile);
                }
                return translated.toArray(new File[translated.size()]);
            }
            return new File[]{entryFile};
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private static final class HackedFile
    extends File {
        private static final InvalidPathException IP = new InvalidPathException("", ""){

            @Override
            public Throwable fillInStackTrace() {
                return this;
            }
        };
        private final String path;

        private HackedFile(String path) {
            super(path);
            this.path = path;
        }

        @Override
        public boolean isDirectory() {
            return this.exists() ? super.isDirectory() : this.path.endsWith(File.separator);
        }

        @Override
        public File getAbsoluteFile() {
            return this;
        }

        @Override
        public Path toPath() {
            if (this.exists()) {
                return super.toPath();
            }
            throw IP;
        }
    }
}

