/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc.editor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.webmvc.editor.AddBeanPanel;
import org.netbeans.modules.spring.webmvc.editor.AddBeanPanelVisual;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class BeanCodeGenerator
implements CodeGenerator {
    private static final String BEANS_END_TAG = "</beans>";
    private static final String CONTEXT_CONFIG_LOCATION = "contextConfigLocation";
    private static final String DISPATCHER_SERVLET_NAME = "dispatcher-servlet";
    private static final String JAVA_MIME = "text/x-java";
    private Document document;
    private FileObject fileObject;

    private BeanCodeGenerator(JTextComponent component) {
        this.document = component.getDocument();
        this.fileObject = NbEditorUtilities.getFileObject((Document)this.document);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(BeanCodeGenerator.class, (String)"MSG_BeanCodeGenerator");
    }

    public void invoke() {
        AddBeanPanel panel = new AddBeanPanel(this.document);
        AddBeanPanelVisual comp = new AddBeanPanelVisual(panel);
        boolean accept = comp.showDialog();
        if (accept) {
            this.createBean(panel.getId(), panel.getClassName());
        }
    }

    private void insertBean(String componentStr, FileObject fo) {
        try {
            DataObject dataObject = DataObject.find((FileObject)fo);
            if (dataObject != null) {
                StyledDocument doc;
                EditorCookie ec = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                LineCookie lc = (LineCookie)dataObject.getCookie(LineCookie.class);
                if (ec != null && lc != null && (doc = ec.openDocument()) != null) {
                    Line line;
                    int offset = doc.getText(0, doc.getLength()).indexOf(BEANS_END_TAG) - 1;
                    doc.insertString(offset, componentStr, null);
                    int lineNumber = NbDocument.findLineNumber((StyledDocument)doc, (int)(offset += componentStr.length()));
                    if (lineNumber != -1 && (line = lc.getLineSet().getCurrent(lineNumber)) != null) {
                        int lineOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)lineNumber);
                        int column = offset - lineOffset;
                        line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, column);
                    }
                }
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void createBean(String id, String className) {
        SpringScope scope = SpringScope.getSpringScope((FileObject)this.fileObject);
        String lineSep = System.getProperty("line.separator");
        String insertStr = lineSep + "    <bean id=\"" + id + "\" class=\"" + className + "\"/>";
        if (!JAVA_MIME.equals(this.fileObject.getMIMEType())) {
            File file = FileUtil.toFile((FileObject)this.fileObject);
            if (scope.getConfigFileManager().getConfigFiles().contains(file)) {
                this.insertBean(insertStr, this.fileObject);
                return;
            }
        }
        for (File file : scope.getConfigFileManager().getConfigFiles()) {
            FileObject fo = FileUtil.toFileObject((File)file);
            if (this.isDispatcherServlet(fo)) continue;
            this.insertBean(insertStr, fo);
            break;
        }
    }

    private boolean isDispatcherServlet(FileObject configFile) {
        return configFile.getName().equals(DISPATCHER_SERVLET_NAME);
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup context) {
            FileObject fo;
            WebModule webModule;
            JTextComponent component = (JTextComponent)context.lookup(JTextComponent.class);
            ArrayList<BeanCodeGenerator> generators = new ArrayList<BeanCodeGenerator>();
            Document doc = component.getDocument();
            if (doc != null && (webModule = WebModule.getWebModule((FileObject)(fo = NbEditorUtilities.getFileObject((Document)doc)))) != null && this.springConfigExist(webModule)) {
                generators.add(new BeanCodeGenerator(component));
            }
            return generators;
        }

        private boolean springConfigExist(WebModule webModule) {
            FileObject dd = webModule.getDeploymentDescriptor();
            if (dd == null) {
                return false;
            }
            try {
                InitParam[] parameters;
                WebApp webApp = DDProvider.getDefault().getDDRoot(dd);
                for (InitParam param : parameters = webApp.getContextParam()) {
                    if (!param.getParamName().startsWith(BeanCodeGenerator.CONTEXT_CONFIG_LOCATION)) continue;
                    return true;
                }
            }
            catch (IOException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
            return false;
        }
    }
}

