/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.util;

import com.sun.xml.ws.transport.tcp.client.WSConnectionManager;
import com.sun.xml.ws.transport.tcp.connectioncache.spi.transport.ContactInfo;
import com.sun.xml.ws.transport.tcp.resources.MessagesMessages;
import com.sun.xml.ws.transport.tcp.servicechannel.ServiceChannelException;
import com.sun.xml.ws.transport.tcp.util.ConnectionSession;
import com.sun.xml.ws.transport.tcp.util.VersionMismatchException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public final class WSTCPURI
implements ContactInfo<ConnectionSession> {
    public String host;
    public int port;
    public String path;
    public int customPort = -1;
    private String uri2string;
    private Map<String, String> params;

    public WSTCPURI() {
    }

    private WSTCPURI(String host, int port, String path, Map<String, String> params, String uri2string) {
        this.host = host;
        this.port = port;
        this.path = path;
        this.params = params;
        this.uri2string = uri2string;
    }

    public String getParameter(String name) {
        if (this.params != null) {
            return this.params.get(name);
        }
        return null;
    }

    public static WSTCPURI parse(String uri) {
        try {
            return WSTCPURI.parse(new URI(uri));
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    public static WSTCPURI parse(URI uri) {
        String path = uri.getPath();
        String query = uri.getQuery();
        HashMap<String, String> params = null;
        if (query != null && query.length() > 0) {
            String[] paramsStr = query.split(";");
            params = new HashMap<String, String>(paramsStr.length);
            for (String paramStr : paramsStr) {
                String[] paramAsgn;
                if (paramStr.length() <= 0 || (paramAsgn = paramStr.split("=")) == null || paramAsgn.length != 2 || paramAsgn[0].length() <= 0 || paramAsgn[1].length() <= 0) continue;
                params.put(paramAsgn[0], paramAsgn[1]);
            }
        }
        return new WSTCPURI(uri.getHost(), uri.getPort(), path, params, uri.toASCIIString());
    }

    public int getCustomPort() {
        return this.customPort;
    }

    public void setCustomPort(int customPort) {
        this.customPort = customPort;
    }

    public int getEffectivePort() {
        if (this.customPort == -1) {
            return this.port;
        }
        return this.customPort;
    }

    public String toString() {
        return this.uri2string;
    }

    public boolean equals(Object o) {
        if (o instanceof WSTCPURI) {
            boolean basicResult;
            WSTCPURI toCmp = (WSTCPURI)o;
            boolean bl = basicResult = this.port == toCmp.port && this.host.equals(toCmp.host);
            if (this.customPort == -1 && toCmp.customPort == -1) {
                return basicResult;
            }
            return basicResult && this.customPort == toCmp.customPort;
        }
        return false;
    }

    public int hashCode() {
        return this.host.hashCode() + (this.port << 2) + this.customPort;
    }

    @Override
    public ConnectionSession createConnection() throws IOException {
        try {
            return WSConnectionManager.getInstance().createConnectionSession(this);
        }
        catch (VersionMismatchException e) {
            throw new IOException(e.getMessage());
        }
        catch (ServiceChannelException e) {
            throw new IOException(MessagesMessages.WSTCP_0024_SERVICE_CHANNEL_EXCEPTION((Object)e.getFaultInfo().getErrorCode(), e.getMessage()));
        }
    }

    public static final class WSTCPURI2StringJAXBAdapter
    extends XmlAdapter<String, WSTCPURI> {
        @Override
        public String marshal(WSTCPURI tcpURI) throws Exception {
            return tcpURI.toString();
        }

        @Override
        public WSTCPURI unmarshal(String uri) throws Exception {
            return WSTCPURI.parse(uri);
        }
    }
}

