/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.zip;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.project.ui.zip.Bundle;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ChangeImportFolder
extends JPanel {
    private JButton folderButton;
    private JTextField folderField;
    private JLabel folderLabel;

    public ChangeImportFolder() {
        this.initComponents();
    }

    JTextField getFolderField() {
        return this.folderField;
    }

    boolean checkImportFolder(NotificationLineSupport notifications, String entry) {
        notifications.clearMessages();
        String updatedPath = this.folderField.getText();
        File updatedFile = new File(updatedPath, entry);
        File folderToImport = new File(updatedPath);
        if (updatedFile.exists()) {
            notifications.setWarningMessage(Bundle.ERR_project_folder_already_exists(entry));
            return false;
        }
        if (updatedPath.isEmpty()) {
            notifications.setInformationMessage(Bundle.ERR_no_folder());
            return false;
        }
        if (!folderToImport.isDirectory()) {
            notifications.setErrorMessage(Bundle.ERR_folder_nonexistent(updatedPath));
            return false;
        }
        return true;
    }

    private void initComponents() {
        this.folderLabel = new JLabel();
        this.folderField = new JTextField();
        this.folderButton = new JButton();
        this.setPreferredSize(new Dimension(371, 55));
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)NbBundle.getMessage(ChangeImportFolder.class, (String)"ChangeImportFolder.folderLabel.text"));
        this.folderField.setEditable(false);
        this.folderField.setText(NbBundle.getMessage(ChangeImportFolder.class, (String)"ChangeImportFolder.folderField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.folderButton, (String)NbBundle.getMessage(ChangeImportFolder.class, (String)"ChangeImportFolder.folderButton.text"));
        this.folderButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangeImportFolder.this.folderButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.folderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.folderField, -2, 197, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.folderButton).addContainerGap(17, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.folderLabel, -1, 31, Short.MAX_VALUE).addComponent(this.folderField, -2, -1, -2).addComponent(this.folderButton)).addContainerGap()));
    }

    private void folderButtonActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        if (fc.showSaveDialog(this) == 0) {
            this.folderField.setText(fc.getSelectedFile().getAbsolutePath());
            this.firePropertyChange("validity", null, null);
        }
    }
}

