/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public class HierarchicalLayout<N, E>
extends GraphLayout<N, E> {
    public static final boolean TRACE = false;
    public static final boolean CHECK = false;
    public static final int SWEEP_ITERATIONS = 3;
    public static final int CROSSING_ITERATIONS = 3;
    public static final int DUMMY_WIDTH = 1;
    public static final int X_OFFSET = 20;
    public static final int LAYER_OFFSET = 30;
    private int dummyWidth = 1;
    private int xOffset;
    private int layerOffset;
    private int layerCount;
    private UniversalGraph<N, E> graph;
    private List<LayoutNode> nodes;
    private Collection<N> nodesSubset = null;
    private HashMap<N, LayoutNode> vertexToLayoutNode;
    private Set<E> reversedLinks;
    private List<LayoutNode>[] layers;
    private boolean animate = false;
    private boolean invert = true;
    private Comparator<LayoutNode> crossingNodeComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            float f = n1.crossingNumber - n2.crossingNumber;
            if (f < 0.0f) {
                return -1;
            }
            if (f > 0.0f) {
                return 1;
            }
            return 0;
        }
    };
    private final Comparator<LayoutNode> nodePositionComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            int res = n1.pos - n2.pos;
            if (res == 0 && (res = n1.toString().compareTo(n1.toString())) == 0) {
                res = System.identityHashCode(n1) - System.identityHashCode(n2);
            }
            return res;
        }
    };
    private final Comparator<LayoutNode> nodeProcessingDownComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            if (n1.vertex == null && n2.vertex == null) {
                int res = n1.toString().compareTo(n1.toString());
                if (res == 0) {
                    res = System.identityHashCode(n1) - System.identityHashCode(n2);
                }
                return res;
            }
            if (n1.vertex == null) {
                return -1;
            }
            if (n2.vertex == null) {
                return 1;
            }
            int res = n1.preds.size() - n2.preds.size();
            if (res == 0 && (res = n1.toString().compareTo(n1.toString())) == 0) {
                res = System.identityHashCode(n1) - System.identityHashCode(n2);
            }
            return res;
        }
    };
    private final Comparator<LayoutNode> nodeProcessingUpComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            if (n1.vertex == null && n2.vertex == null) {
                int res = n1.toString().compareTo(n1.toString());
                if (res == 0) {
                    res = System.identityHashCode(n1) - System.identityHashCode(n2);
                }
                return res;
            }
            if (n1.vertex == null) {
                return -1;
            }
            if (n2.vertex == null) {
                return 1;
            }
            int res = n1.succs.size() - n2.succs.size();
            if (res == 0 && (res = n1.toString().compareTo(n1.toString())) == 0) {
                res = System.identityHashCode(n1) - System.identityHashCode(n2);
            }
            return res;
        }
    };

    public HierarchicalLayout(GraphScene<N, E> scene, boolean animate, boolean inverted, int xOffset, int layerOffset) {
        this.animate = animate;
        this.xOffset = xOffset > 0 ? xOffset : 20;
        this.layerOffset = layerOffset > 0 ? layerOffset : 30;
        this.invert = inverted;
    }

    public HierarchicalLayout(GraphScene<N, E> scene, boolean animate, boolean inverted) {
        this(scene, animate, inverted, 20, 30);
    }

    public HierarchicalLayout(GraphScene<N, E> scene, boolean animate) {
        this(scene, animate, false);
    }

    public HierarchicalLayout() {
        this(null, false);
    }

    @Override
    protected void performGraphLayout(UniversalGraph<N, E> graph) {
        this.graph = graph;
        this.vertexToLayoutNode = new HashMap();
        this.reversedLinks = new HashSet();
        this.nodes = new ArrayList<LayoutNode>();
        new BuildDatastructure().start();
        new ReverseEdges().start();
        new AssignLayers().start();
        new CreateDummyNodes().start();
        new CrossingReduction().start();
        new AssignXCoordinates().start();
        new AssignYCoordinates().start();
        new WriteResult().start();
    }

    @Override
    protected void performNodesLayout(UniversalGraph<N, E> arg0, Collection<N> arg1) {
        this.nodesSubset = arg1;
        this.performGraphLayout(arg0);
    }

    static /* synthetic */ List[] access$1902(HierarchicalLayout x0, List[] x1) {
        x0.layers = x1;
        return x1;
    }

    private class WriteResult
    extends AlgorithmPart {
        private int pointCount;

        private WriteResult() {
        }

        @Override
        protected void run() {
            Object w;
            ArrayList points;
            Point p;
            Point p22;
            HashMap vertexPositions = new HashMap();
            HashMap linkPositions = new HashMap();
            for (Object v : HierarchicalLayout.this.graph.getNodes()) {
                LayoutNode n = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(v);
                assert (!vertexPositions.containsKey(v));
                vertexPositions.put(v, new Point(n.x + n.xOffset, n.y + n.yOffset));
            }
            for (LayoutNode n : HierarchicalLayout.this.nodes) {
                for (LayoutEdge e : n.succs) {
                    if (e.link == null) continue;
                    Object link = e.link;
                    ArrayList points2 = new ArrayList();
                    p22 = new Point(e.from.x + e.relativeFrom, e.from.y + e.from.height - e.from.bottomYOffset);
                    points2.add(p22);
                    LayoutNode cur = e.to;
                    LayoutNode other = e.from;
                    LayoutEdge curEdge = e;
                    while (cur.vertex == null && cur.succs.size() != 0) {
                        points2.add(new Point(cur.x + cur.width / 2, cur.y));
                        points2.add(new Point(cur.x + cur.width / 2, cur.y + cur.height));
                        if (cur.succs.size() == 0) break;
                        assert (cur.succs.size() == 1);
                        curEdge = cur.succs.get(0);
                        cur = curEdge.to;
                    }
                    p22 = new Point(cur.x + curEdge.relativeTo, cur.y + cur.yOffset);
                    points2.add(p22);
                    if (HierarchicalLayout.this.reversedLinks.contains(link)) {
                        Collections.reverse(points2);
                    }
                    linkPositions.put(e.link, points2);
                    e.link = null;
                }
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            for (LayoutEdge v : vertexPositions.keySet()) {
                p = (Point)vertexPositions.get(v);
                minX = Math.min(minX, p.x);
                minY = Math.min(minY, p.y);
            }
            for (LayoutEdge l : linkPositions.keySet()) {
                points = (ArrayList)linkPositions.get(l);
                for (Point p22 : points) {
                    if (p22 == null) continue;
                    minX = Math.min(minX, p22.x);
                    minY = Math.min(minY, p22.y);
                }
            }
            for (LayoutEdge v : vertexPositions.keySet()) {
                p = (Point)vertexPositions.get(v);
                p.x -= minX;
                p.y -= minY;
                w = HierarchicalLayout.this.graph.getScene().findWidget(v);
                if (HierarchicalLayout.this.animate) {
                    HierarchicalLayout.this.graph.getScene().getSceneAnimator().animatePreferredLocation((Widget)w, p);
                    continue;
                }
                ((Widget)w).setPreferredLocation(p);
            }
            for (LayoutEdge l : linkPositions.keySet()) {
                points = (List)linkPositions.get(l);
                w = points.iterator();
                while (w.hasNext()) {
                    p22 = (Point)w.next();
                    if (p22 == null) continue;
                    p22.x -= minX;
                    p22.y -= minY;
                }
                if (HierarchicalLayout.this.invert && points.size() > 3) {
                    int numPoints = points.size();
                    ArrayList invertedPoints = new ArrayList(numPoints);
                    invertedPoints.add(points.get(0));
                    for (int i = numPoints - 2; i > 0; --i) {
                        invertedPoints.add(points.get(i));
                    }
                    invertedPoints.add(points.get(numPoints - 1));
                    points = invertedPoints;
                }
                if (!((w = HierarchicalLayout.this.graph.getScene().findWidget(l)) instanceof ConnectionWidget)) continue;
                ConnectionWidget cw = (ConnectionWidget)w;
                cw.setControlPoints(points, true);
            }
            HierarchicalLayout.this.graph.getScene().validate();
            HierarchicalLayout.this.graph.getScene().repaint();
            HierarchicalLayout.this.graph.getScene().revalidate();
        }

        @Override
        protected void printStatistics() {
            System.out.println("Number of nodes: " + HierarchicalLayout.this.nodes.size());
            int edgeCount = 0;
            for (LayoutNode n : HierarchicalLayout.this.nodes) {
                edgeCount += n.succs.size();
            }
            System.out.println("Number of edges: " + edgeCount);
            System.out.println("Number of points: " + this.pointCount);
        }
    }

    private class AssignYCoordinates
    extends AlgorithmPart {
        private AssignYCoordinates() {
        }

        @Override
        protected void run() {
            int curY = 0;
            for (int i = 0; i < HierarchicalLayout.this.layers.length; ++i) {
                int maxHeight = 0;
                int baseLine = 0;
                int bottomBaseLine = 0;
                for (LayoutNode n : HierarchicalLayout.this.layers[i]) {
                    maxHeight = Math.max(maxHeight, n.height - n.yOffset - n.bottomYOffset);
                    baseLine = Math.max(baseLine, n.yOffset);
                    bottomBaseLine = Math.max(bottomBaseLine, n.bottomYOffset);
                }
                for (LayoutNode n : HierarchicalLayout.this.layers[i]) {
                    if (n.vertex == null) {
                        n.y = curY;
                        n.height = maxHeight + baseLine + bottomBaseLine;
                        continue;
                    }
                    n.y = curY + baseLine + (maxHeight - (n.height - n.yOffset - n.bottomYOffset)) / 2 - n.yOffset;
                }
                curY += maxHeight + baseLine + bottomBaseLine;
                curY += HierarchicalLayout.this.layerOffset;
            }
        }
    }

    private class NodeRow {
        private TreeSet<LayoutNode> treeSet;
        private ArrayList<Integer> space;

        public NodeRow(ArrayList<Integer> space) {
            this.treeSet = new TreeSet(HierarchicalLayout.this.nodePositionComparator);
            this.space = space;
        }

        public int offset(LayoutNode n1, LayoutNode n2) {
            int v1 = this.space.get(n1.pos) + n1.width;
            int v2 = this.space.get(n2.pos);
            return v2 - v1;
        }

        public void insert(LayoutNode n, int pos) {
            SortedSet<LayoutNode> headSet = this.treeSet.headSet(n);
            SortedSet<LayoutNode> tailSet = this.treeSet.tailSet(n);
            LayoutNode leftNeighbor = null;
            int minX = Integer.MIN_VALUE;
            if (!headSet.isEmpty()) {
                leftNeighbor = headSet.last();
                minX = leftNeighbor.x + leftNeighbor.width + this.offset(leftNeighbor, n);
            }
            LayoutNode rightNeighbor = null;
            int maxX = Integer.MAX_VALUE;
            if (!tailSet.isEmpty()) {
                rightNeighbor = tailSet.first();
                maxX = rightNeighbor.x - this.offset(n, rightNeighbor) - n.width;
            }
            assert (minX <= maxX);
            if (pos >= minX && pos <= maxX) {
                n.x = pos;
            } else if (Math.abs((long)pos - (long)minX) < Math.abs((long)pos - (long)maxX)) {
                assert (minX != Integer.MIN_VALUE);
                n.x = minX;
            } else {
                assert (maxX != Integer.MAX_VALUE);
                n.x = maxX;
            }
            this.treeSet.add(n);
        }
    }

    private class AssignXCoordinates
    extends AlgorithmPart {
        private ArrayList<Integer>[] space;
        private ArrayList<LayoutNode>[] downProcessingOrder;
        private ArrayList<LayoutNode>[] upProcessingOrder;

        private AssignXCoordinates() {
        }

        private void initialPositions() {
            for (LayoutNode n : HierarchicalLayout.this.nodes) {
                n.x = this.space[n.layer].get(n.pos);
            }
        }

        @Override
        protected void run() {
            int i;
            this.space = new ArrayList[HierarchicalLayout.this.layers.length];
            this.downProcessingOrder = new ArrayList[HierarchicalLayout.this.layers.length];
            this.upProcessingOrder = new ArrayList[HierarchicalLayout.this.layers.length];
            for (i = 0; i < HierarchicalLayout.this.layers.length; ++i) {
                this.space[i] = new ArrayList();
                this.downProcessingOrder[i] = new ArrayList();
                this.upProcessingOrder[i] = new ArrayList();
                int curX = 0;
                for (LayoutNode n : HierarchicalLayout.this.layers[i]) {
                    this.space[i].add(curX);
                    curX += n.width + HierarchicalLayout.this.xOffset;
                    this.downProcessingOrder[i].add(n);
                    this.upProcessingOrder[i].add(n);
                }
                Collections.sort(this.downProcessingOrder[i], HierarchicalLayout.this.nodeProcessingDownComparator);
                Collections.sort(this.upProcessingOrder[i], HierarchicalLayout.this.nodeProcessingUpComparator);
            }
            this.initialPositions();
            for (i = 0; i < 3; ++i) {
                this.sweepDown();
                this.sweepUp();
            }
            this.sweepDown();
            this.sweepUp();
        }

        private int calculateOptimalDown(LayoutNode n) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            if (n.preds.size() == 0) {
                return n.x;
            }
            for (LayoutEdge e : n.preds) {
                int cur = e.from.x + e.relativeFrom - e.relativeTo;
                values.add(cur);
            }
            return this.median(values);
        }

        private int calculateOptimalUp(LayoutNode n) {
            ArrayList<Integer> values = new ArrayList<Integer>();
            if (n.succs.size() == 0) {
                return n.x;
            }
            for (LayoutEdge e : n.succs) {
                int cur = e.to.x + e.relativeTo - e.relativeFrom;
                values.add(cur);
            }
            return this.median(values);
        }

        private int median(List<Integer> values) {
            Collections.sort(values);
            if (values.size() % 2 == 0) {
                return (values.get(values.size() / 2 - 1) + values.get(values.size() / 2)) / 2;
            }
            return values.get(values.size() / 2);
        }

        private void sweepUp() {
            for (int i = HierarchicalLayout.this.layers.length - 2; i >= 0; --i) {
                NodeRow r = new NodeRow(this.space[i]);
                for (LayoutNode n : this.upProcessingOrder[i]) {
                    int optimal = this.calculateOptimalUp(n);
                    r.insert(n, optimal);
                }
            }
        }

        private void sweepDown() {
            for (int i = 1; i < HierarchicalLayout.this.layers.length; ++i) {
                NodeRow r = new NodeRow(this.space[i]);
                for (LayoutNode n : this.downProcessingOrder[i]) {
                    int optimal = this.calculateOptimalDown(n);
                    r.insert(n, optimal);
                }
            }
        }
    }

    private class CrossingReduction
    extends AlgorithmPart {
        private CrossingReduction() {
        }

        @Override
        public void preCheck() {
            for (LayoutNode n : HierarchicalLayout.this.nodes) {
                assert (n.layer < HierarchicalLayout.this.layerCount);
            }
        }

        @Override
        protected void run() {
            int i;
            HierarchicalLayout.access$1902(HierarchicalLayout.this, new List[HierarchicalLayout.this.layerCount]);
            for (int i2 = 0; i2 < HierarchicalLayout.this.layerCount; ++i2) {
                ((HierarchicalLayout)HierarchicalLayout.this).layers[i2] = new ArrayList();
            }
            HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
            for (LayoutNode n : HierarchicalLayout.this.nodes) {
                if (n.layer == 0) {
                    HierarchicalLayout.this.layers[0].add(n);
                    visited.add(n);
                    continue;
                }
                if (n.preds.size() != 0) continue;
                HierarchicalLayout.this.layers[n.layer].add(n);
                visited.add(n);
            }
            for (i = 0; i < HierarchicalLayout.this.layers.length - 1; ++i) {
                for (LayoutNode n : HierarchicalLayout.this.layers[i]) {
                    for (LayoutEdge e : n.succs) {
                        if (visited.contains(e.to)) continue;
                        visited.add(e.to);
                        HierarchicalLayout.this.layers[i + 1].add(e.to);
                    }
                }
            }
            this.updatePositions();
            for (i = 0; i < 3; ++i) {
                this.downSweep();
                this.upSweep();
            }
        }

        private void updatePositions() {
            for (int i = 0; i < HierarchicalLayout.this.layers.length; ++i) {
                int z = 0;
                for (LayoutNode n : HierarchicalLayout.this.layers[i]) {
                    n.pos = z++;
                }
            }
        }

        private void downSweep() {
            for (int i = 1; i < HierarchicalLayout.this.layerCount; ++i) {
                for (LayoutNode n : HierarchicalLayout.this.layers[i]) {
                    float sum = 0.0f;
                    for (LayoutEdge e : n.preds) {
                        float cur = e.from.pos;
                        if (e.from.width != 0 && e.relativeFrom != 0) {
                            cur += (float)e.relativeFrom / (float)e.from.width;
                        }
                        sum += cur;
                    }
                    if (n.preds.size() <= 0) continue;
                    n.crossingNumber = sum /= (float)n.preds.size();
                }
                Collections.sort(HierarchicalLayout.this.layers[i], HierarchicalLayout.this.crossingNodeComparator);
                int z = 0;
                for (LayoutNode n : HierarchicalLayout.this.layers[i]) {
                    n.pos = z++;
                }
            }
        }

        private void upSweep() {
            for (int i = HierarchicalLayout.this.layerCount - 1; i >= 0; --i) {
                for (LayoutNode n : HierarchicalLayout.this.layers[i]) {
                    float sum = 0.0f;
                    for (LayoutEdge e : n.succs) {
                        float cur = e.to.pos;
                        if (e.to.width != 0 && e.relativeTo != 0) {
                            cur += (float)e.relativeTo / (float)e.to.width;
                        }
                        sum += cur;
                    }
                    if (n.succs.size() <= 0) continue;
                    n.crossingNumber = sum /= (float)n.succs.size();
                }
                Collections.sort(HierarchicalLayout.this.layers[i], HierarchicalLayout.this.crossingNodeComparator);
                int z = 0;
                for (LayoutNode n : HierarchicalLayout.this.layers[i]) {
                    n.pos = z++;
                }
            }
        }

        private int evaluate() {
            return 0;
        }

        @Override
        public void postCheck() {
            HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
            for (int i = 0; i < HierarchicalLayout.this.layers.length; ++i) {
                for (LayoutNode n : HierarchicalLayout.this.layers[i]) {
                    assert (!visited.contains(n));
                    assert (n.layer == i);
                    visited.add(n);
                }
            }
        }
    }

    private class CreateDummyNodes
    extends AlgorithmPart {
        private int oldNodeCount;

        private CreateDummyNodes() {
        }

        @Override
        protected void preCheck() {
            for (LayoutNode n : HierarchicalLayout.this.nodes) {
                for (LayoutEdge e : n.succs) {
                    assert (e.from != null);
                    assert (e.from == n);
                    assert (e.from.layer < e.to.layer);
                }
                for (LayoutEdge e : n.preds) {
                    assert (e.to != null);
                    assert (e.to == n);
                }
            }
        }

        @Override
        protected void run() {
            this.oldNodeCount = HierarchicalLayout.this.nodes.size();
            ArrayList currentNodes = new ArrayList(HierarchicalLayout.this.nodes);
            for (LayoutNode n : currentNodes) {
                for (LayoutEdge e : n.succs) {
                    this.processSingleEdge(e);
                }
            }
        }

        private void processSingleEdge(LayoutEdge e) {
            LayoutNode n = e.from;
            if (e.to.layer > n.layer + 1) {
                LayoutEdge last = e;
                for (int i = n.layer + 1; i < last.to.layer; ++i) {
                    last = this.addBetween(last, i);
                }
            }
        }

        private LayoutEdge addBetween(LayoutEdge e, int layer) {
            LayoutNode n = new LayoutNode();
            n.width = HierarchicalLayout.this.dummyWidth;
            n.height = 0;
            n.layer = layer;
            n.preds.add(e);
            HierarchicalLayout.this.nodes.add(n);
            LayoutEdge result = new LayoutEdge();
            n.succs.add(result);
            result.from = n;
            result.relativeFrom = n.width / 2;
            result.to = e.to;
            result.relativeTo = e.relativeTo;
            e.relativeTo = n.width / 2;
            e.to.preds.remove(e);
            e.to.preds.add(result);
            e.to = n;
            return result;
        }

        @Override
        public void printStatistics() {
            System.out.println("Dummy nodes created: " + (HierarchicalLayout.this.nodes.size() - this.oldNodeCount));
        }

        @Override
        public void postCheck() {
            ArrayList currentNodes = new ArrayList(HierarchicalLayout.this.nodes);
            for (LayoutNode n : currentNodes) {
                for (LayoutEdge e : n.succs) {
                    assert (e.from.layer == e.to.layer - 1);
                }
            }
            for (int i = 0; i < HierarchicalLayout.this.layers.length; ++i) {
                assert (HierarchicalLayout.this.layers[i].size() > 0);
                for (LayoutNode n : HierarchicalLayout.this.layers[i]) {
                    assert (n.layer == i);
                }
            }
        }
    }

    private class AssignLayers
    extends AlgorithmPart {
        private AssignLayers() {
        }

        @Override
        public void preCheck() {
            for (LayoutNode n : HierarchicalLayout.this.nodes) {
                assert (n.layer == -1);
            }
        }

        @Override
        protected void run() {
            HashSet<LayoutNode> set = new HashSet<LayoutNode>();
            for (LayoutNode n : HierarchicalLayout.this.nodes) {
                if (n.preds.size() != 0) continue;
                set.add(n);
                n.layer = 0;
            }
            int z = 1;
            HashSet<Object> newSet = new HashSet();
            HashSet<LayoutNode> failed = new HashSet<LayoutNode>();
            while (!set.isEmpty()) {
                newSet.clear();
                failed.clear();
                for (LayoutNode layoutNode : set) {
                    for (LayoutEdge se : layoutNode.succs) {
                        LayoutNode s = se.to;
                        if (newSet.contains(s) || failed.contains(s)) continue;
                        boolean ok = true;
                        for (LayoutEdge pe : s.preds) {
                            LayoutNode p = pe.from;
                            if (p.layer != -1) continue;
                            ok = false;
                            break;
                        }
                        if (ok) {
                            newSet.add(s);
                            continue;
                        }
                        failed.add(s);
                    }
                }
                for (LayoutNode layoutNode : newSet) {
                    layoutNode.layer = z;
                }
                HashSet<LayoutNode> tmp = set;
                set = newSet;
                newSet = tmp;
                ++z;
            }
            this.optimize(set);
            HierarchicalLayout.this.layerCount = z - 1;
        }

        public void optimize(HashSet<LayoutNode> set) {
            for (LayoutNode n : set) {
                if (n.preds.size() != 0 || n.succs.size() <= 0) continue;
                int minLayer = n.succs.get((int)0).to.layer;
                for (LayoutEdge e : n.succs) {
                    minLayer = Math.min(minLayer, e.to.layer);
                }
                n.layer = minLayer - 1;
            }
        }

        @Override
        public void printStatistics() {
        }

        @Override
        public void postCheck() {
            for (LayoutNode n : HierarchicalLayout.this.nodes) {
                assert (n.layer >= 0);
                assert (n.layer < HierarchicalLayout.this.layerCount);
                for (LayoutEdge e : n.succs) {
                    assert (e.from.layer < e.to.layer);
                }
            }
        }
    }

    private class ReverseEdges
    extends AlgorithmPart {
        private HashSet<LayoutNode> visited;
        private HashSet<LayoutNode> active;

        private ReverseEdges() {
        }

        @Override
        protected void run() {
            for (LayoutNode node : HierarchicalLayout.this.nodes) {
                ArrayList<LayoutEdge> succs = new ArrayList<LayoutEdge>(node.succs);
                for (LayoutEdge e : succs) {
                    assert (e.from == node);
                    if (e.to != node) continue;
                    node.succs.remove(e);
                    node.preds.remove(e);
                }
            }
            this.visited = new HashSet();
            this.active = new HashSet();
            for (LayoutNode node : HierarchicalLayout.this.nodes) {
                this.DFS(node);
            }
        }

        private void DFS(LayoutNode startNode) {
            if (this.visited.contains(startNode)) {
                return;
            }
            Stack<LayoutNode> stack = new Stack<LayoutNode>();
            stack.push(startNode);
            while (!stack.empty()) {
                LayoutNode node = (LayoutNode)stack.pop();
                if (this.visited.contains(node)) {
                    this.active.remove(node);
                    continue;
                }
                stack.push(node);
                this.visited.add(node);
                this.active.add(node);
                ArrayList<LayoutEdge> succs = new ArrayList<LayoutEdge>(node.succs);
                for (LayoutEdge e : succs) {
                    if (this.active.contains(e.to)) {
                        assert (this.visited.contains(e.to));
                        this.reverseEdge(e);
                        continue;
                    }
                    if (this.visited.contains(e.to)) continue;
                    stack.push(e.to);
                }
            }
        }

        private void reverseAllInputs(LayoutNode node) {
            for (LayoutEdge e : node.preds) {
                assert (!HierarchicalLayout.this.reversedLinks.contains(e.link));
                HierarchicalLayout.this.reversedLinks.add(e.link);
                node.succs.add(e);
                e.from.preds.add(e);
                e.from.succs.remove(e);
                int oldRelativeFrom = e.relativeFrom;
                int oldRelativeTo = e.relativeTo;
                e.to = e.from;
                e.from = node;
                e.relativeFrom = oldRelativeTo;
                e.relativeTo = oldRelativeFrom;
            }
            node.preds.clear();
        }

        private void reverseEdge(LayoutEdge e) {
            assert (!HierarchicalLayout.this.reversedLinks.contains(e.link));
            HierarchicalLayout.this.reversedLinks.add(e.link);
            LayoutNode oldFrom = e.from;
            LayoutNode oldTo = e.to;
            int oldRelativeFrom = e.relativeFrom;
            int oldRelativeTo = e.relativeTo;
            e.from = oldTo;
            e.to = oldFrom;
            e.relativeFrom = oldRelativeTo;
            e.relativeTo = oldRelativeFrom;
            oldFrom.succs.remove(e);
            oldFrom.preds.add(e);
            oldTo.preds.remove(e);
            oldTo.succs.add(e);
        }

        @Override
        public void postCheck() {
            for (LayoutNode n : HierarchicalLayout.this.nodes) {
                LinkedList<LayoutNode> queue = new LinkedList<LayoutNode>();
                for (LayoutEdge e : n.succs) {
                    LayoutNode s = e.to;
                    queue.add(s);
                    this.visited.add(s);
                }
                HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
                while (!queue.isEmpty()) {
                    LayoutNode curNode = (LayoutNode)queue.remove();
                    for (LayoutEdge e : curNode.succs) {
                        assert (e.to != n);
                        if (visited.contains(e.to)) continue;
                        queue.add(e.to);
                        visited.add(e.to);
                    }
                }
            }
        }
    }

    private class BuildDatastructure
    extends AlgorithmPart {
        private BuildDatastructure() {
        }

        @Override
        protected void run() {
            Collection vertices = HierarchicalLayout.this.nodesSubset == null ? HierarchicalLayout.this.graph.getNodes() : HierarchicalLayout.this.nodesSubset;
            for (Object v : vertices) {
                LayoutNode node = new LayoutNode();
                Widget w = HierarchicalLayout.this.graph.getScene().findWidget(v);
                assert (w != null);
                Rectangle r = w.getBounds();
                if (r == null) {
                    r = w.getPreferredBounds();
                }
                Dimension size = r.getSize();
                node.width = (int)size.getWidth();
                node.height = (int)size.getHeight();
                node.vertex = v;
                HierarchicalLayout.this.nodes.add(node);
                HierarchicalLayout.this.vertexToLayoutNode.put(v, node);
            }
            Collection links = HierarchicalLayout.this.graph.getEdges();
            for (Object l : links) {
                LayoutEdge edge = new LayoutEdge();
                assert (HierarchicalLayout.this.vertexToLayoutNode.containsKey(HierarchicalLayout.this.graph.getEdgeSource(l)));
                assert (HierarchicalLayout.this.vertexToLayoutNode.containsKey(HierarchicalLayout.this.graph.getEdgeTarget(l)));
                if (HierarchicalLayout.this.invert) {
                    edge.to = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(HierarchicalLayout.this.graph.getEdgeSource(l));
                    edge.from = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(HierarchicalLayout.this.graph.getEdgeTarget(l));
                } else {
                    edge.from = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(HierarchicalLayout.this.graph.getEdgeSource(l));
                    edge.to = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(HierarchicalLayout.this.graph.getEdgeTarget(l));
                }
                Widget w = HierarchicalLayout.this.graph.getScene().findWidget(HierarchicalLayout.this.graph.getEdgeSource(l));
                assert (w != null);
                Rectangle r = w.getBounds();
                if (r == null) {
                    r = w.getPreferredBounds();
                }
                Dimension size = r.getSize();
                edge.relativeFrom = size.width / 2;
                w = HierarchicalLayout.this.graph.getScene().findWidget(HierarchicalLayout.this.graph.getEdgeTarget(l));
                assert (w != null);
                r = w.getBounds();
                if (r == null) {
                    r = w.getPreferredBounds();
                }
                size = r.getSize();
                edge.relativeTo = size.width / 2;
                edge.link = l;
                edge.from.succs.add(edge);
                edge.to.preds.add(edge);
            }
        }

        @Override
        public void postCheck() {
            assert (HierarchicalLayout.this.vertexToLayoutNode.keySet().size() == HierarchicalLayout.this.nodes.size());
            assert (HierarchicalLayout.this.nodes.size() == HierarchicalLayout.this.graph.getNodes().size());
            for (Object v : HierarchicalLayout.this.graph.getNodes()) {
                LayoutNode node = (LayoutNode)HierarchicalLayout.this.vertexToLayoutNode.get(v);
                assert (node != null);
                for (LayoutEdge e : node.succs) {
                    assert (e.from == node);
                }
                for (LayoutEdge e : node.preds) {
                    assert (e.to == node);
                }
            }
        }
    }

    private abstract class AlgorithmPart {
        private AlgorithmPart() {
        }

        public void start() {
            long start = 0L;
            this.run();
        }

        protected abstract void run();

        protected void printStatistics() {
        }

        protected void postCheck() {
        }

        protected void preCheck() {
        }
    }

    private class LayoutEdge {
        public LayoutNode from;
        public LayoutNode to;
        public int relativeFrom;
        public int relativeTo;
        public E link;

        private LayoutEdge() {
        }
    }

    private class LayoutNode {
        public int x;
        public int y;
        public int width;
        public int height;
        public int layer = -1;
        public int xOffset;
        public int yOffset;
        public int bottomYOffset;
        public N vertex;
        public List<LayoutEdge> preds = new ArrayList<LayoutEdge>();
        public List<LayoutEdge> succs = new ArrayList<LayoutEdge>();
        public int pos = -1;
        public float crossingNumber;

        private LayoutNode() {
        }

        public String toString() {
            return "Node " + this.vertex;
        }
    }
}

